/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.docker.instantiators;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import java.io.File;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.docker.instantiators.AbstractDockerInstantiator;
import net.ssehub.easy.instantiation.docker.instantiators.DockerLogin;

@Instantiator(value="dockerBuildImage")
public class DockerBuildImage
extends AbstractDockerInstantiator {
    private static final boolean BUILD_WITH_CACHE = Boolean.valueOf(System.getProperty("easy.docker.buildImageWithCache", "true"));

    public static String dockerBuildImage(Path baseDirectory, Path dockerFile, String name) throws VilException {
        if (DockerBuildImage.skip()) {
            return SKIP_ID;
        }
        HashSet<String> tags = new HashSet<String>();
        tags.add(name);
        IInstantiatorTracer tracer = TracerFactory.getInstance().createInstantiatorTracerImpl();
        try {
            long start = System.currentTimeMillis();
            File dockerfile = dockerFile.getAbsolutePath();
            BuildImageCmd cmd = DockerBuildImage.createClient().buildImageCmd().withDockerfile(dockerfile).withPull(Boolean.valueOf(true)).withNoCache(Boolean.valueOf(!BUILD_WITH_CACHE)).withBaseDirectory(baseDirectory.getAbsolutePath()).withTags(tags);
            AuthConfigurations aCfgs = DockerLogin.getAuthConfigs();
            if (aCfgs != null) {
                cmd.withBuildAuthConfigs(aCfgs);
            }
            tracer.traceMessage("Building docker image " + name + ". Please wait...");
            String taskDescription = "Docker build";
            TracerFactory.ensureTasks((String)"Docker build");
            final AtomicInteger count = new AtomicInteger(0);
            final AtomicReference cbThrowable = new AtomicReference();
            String imageId = (cmd.exec((ResultCallback)new BuildImageResultCallback(){

                public void onNext(BuildResponseItem item) {
                    super.onNext(item);
                    EASyLoggerFactory.INSTANCE.getLogger(((Object)((Object)this)).getClass(), "docker").info("Docker response Docker build: " + item.getId() + " " + item.getStatus());
                    int cnt = count.incrementAndGet();
                    TracerFactory.progressSubTask((int)cnt, (int)(cnt + 1), (String)"Docker build");
                }

                public void onError(Throwable th) {
                    cbThrowable.set(th);
                }
            })).awaitImageId();
            TracerFactory.closeTasks((String)"Docker build");
            DockerBuildImage.handleThrowable((Throwable)cbThrowable.get(), tracer, DockerBuildImage.getTask(name));
            tracer.traceMessage(DockerBuildImage.getTask(name) + " completed " + imageId + " in " + (System.currentTimeMillis() - start) + " ms");
            return imageId;
        }
        catch (Exception e) {
            DockerBuildImage.handleThrowable(e, tracer, DockerBuildImage.getTask(name));
            return null;
        }
    }

    private static String getTask(String name) {
        return "Building docker image " + name;
    }
}

