/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.json;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.Formatting;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.json.INodeParent;
import net.ssehub.easy.instantiation.json.JsonArtifactCreator;
import net.ssehub.easy.instantiation.json.JsonNode;
import org.apache.commons.io.FileUtils;

@ArtifactCreator(value=JsonArtifactCreator.class)
public class JsonFileArtifact
extends FileArtifact
implements IStringValueProvider,
INodeParent {
    private JsonNode data = new JsonNode(this);
    private boolean changedByNodes = false;

    public JsonFileArtifact() {
    }

    protected JsonFileArtifact(File file, ArtifactModel model) {
        super(file, model);
        this.initialize();
    }

    private void initialize() {
        File f = this.getPath().getAbsolutePath();
        try {
            if (f.exists()) {
                ObjectMapper mapper = new ObjectMapper();
                java.util.Map data = (java.util.Map)mapper.readValue(FileUtils.readFileToByteArray((File)f), java.util.Map.class);
                this.data = new JsonNode((Object)data, (INodeParent)this);
            }
        }
        catch (Throwable e) {
            EASyLoggerFactory.INSTANCE.getLogger(JsonFileArtifact.class, "net.ssehub.easy.instantiation.yaml").warn("While reading " + String.valueOf(f) + ": " + e.getMessage());
        }
    }

    public void artifactChanged(Object cause) throws VilException {
        super.artifactChanged(cause);
        this.initialize();
    }

    public static JsonFileArtifact create() {
        return new JsonFileArtifact();
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(String val) throws VilException {
        Path path = Path.convert((String)val);
        return (FileArtifact)ArtifactFactory.createArtifact(JsonFileArtifact.class, (Object)path.getAbsolutePath(), (ArtifactModel)path.getArtifactModel());
    }

    @Invisible
    @Conversion
    public static JsonFileArtifact convert(IFileSystemArtifact val) {
        JsonFileArtifact convertedValue = null;
        if (val instanceof JsonFileArtifact) {
            convertedValue = (JsonFileArtifact)val;
        } else if (val instanceof FileArtifact) {
            FileArtifact fa = (FileArtifact)val;
            try {
                convertedValue = (JsonFileArtifact)ArtifactFactory.createArtifact(JsonFileArtifact.class, (Object)fa.getPath().getAbsolutePath(), null);
            }
            catch (VilException e) {
                EASyLoggerFactory.INSTANCE.getLogger(JsonFileArtifact.class, "net.ssehub.easy.instantiation.yaml").error(e.getMessage());
            }
        }
        return convertedValue;
    }

    public boolean has(String name) {
        return this.data.has(name);
    }

    public JsonNode addValue(String name, Object value) {
        return this.data.addValue(name, value);
    }

    public JsonNode addObject(String name) {
        return this.data.addObject(name);
    }

    public JsonNode delete(String name) {
        return this.data.delete(name);
    }

    public JsonNode addList(String name, Sequence<?> value) {
        return this.data.addList(name, value);
    }

    public JsonNode addValues(Map<Object, Object> value) {
        return this.data.addValues(value);
    }

    public JsonNode addMap(String name, Map<?, ?> value) {
        return this.data.addMap(name, value);
    }

    public JsonNode getData() {
        return this.data;
    }

    public void store() throws VilException {
        super.store();
        if (this.changedByNodes) {
            try {
                File file = this.getPath().getAbsolutePath();
                file.getParentFile().mkdirs();
                IndentationConfiguration iCfg = Formatting.getIndentationConfiguration();
                FormattingConfiguration fCfg = Formatting.getFormattingConfiguration();
                ObjectMapper mapper = new ObjectMapper();
                JsonNode.Sorting sorting = JsonNode.Sorting.NONE;
                try {
                    sorting = JsonNode.Sorting.valueOf(fCfg.getProfileArgument("sorting", "NONE").toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ObjectWriter writer = mapper.writer();
                if (Boolean.valueOf(fCfg.getProfileArgument("prettyPrint", "true")).booleanValue()) {
                    int indent = 1;
                    if (fCfg.getIndentSteps() > 0) {
                        indent = fCfg.getIndentSteps();
                    } else if (iCfg.getIndentationStep() > 0) {
                        indent = iCfg.getIndentationStep();
                    }
                    Object indentString = "";
                    int i = 1;
                    while (i < indent) {
                        indentString = (String)indentString + " ";
                        ++i;
                    }
                    DefaultIndenter indenter = new DefaultIndenter((String)indentString, DefaultIndenter.SYS_LF);
                    DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
                    printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
                    printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
                    writer = mapper.writer((PrettyPrinter)printer);
                }
                writer.writeValue(file, this.data.getData(sorting));
                this.changedByNodes = false;
            }
            catch (IOException e) {
                throw new VilException(e.getMessage(), (Throwable)e, 50001);
            }
        }
    }

    @Override
    public void notifyChanged() {
        this.changedByNodes = true;
    }
}

