/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.yaml;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.yaml.ClassMap;
import net.ssehub.easy.instantiation.yaml.INodeParent;
import net.ssehub.easy.instantiation.yaml.YamlNode;
import net.ssehub.easy.instantiation.yaml.YamlStructure;

public class YamlList
extends YamlStructure {
    private List<Object> data;

    YamlList(List<Object> data, INodeParent parent) {
        super(parent);
        this.data = data;
    }

    public YamlList addValue(Object value) {
        this.data.add(value);
        return this;
    }

    public YamlList addValues(Sequence<?> values) {
        for (Object o : values) {
            this.data.add(o);
        }
        return this;
    }

    public YamlNode addObject() {
        YamlNode obj = new YamlNode(new ClassMap(), (INodeParent)this);
        this.addValue(obj);
        return obj;
    }

    public YamlList addList() {
        YamlList result = new YamlList(new ArrayList<Object>(), this);
        this.addValue(result);
        return result;
    }

    public YamlNode addMap(String name) {
        YamlNode result = new YamlNode(this);
        this.addValue(result);
        return result;
    }

    public int getSize() {
        return this.data.size();
    }

    public Sequence<Object> getListValue() {
        return new ListSequence(this.data, new TypeDescriptor[]{TypeRegistry.anyType()});
    }

    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return comparator != null ? "YamlNode" : this.data.toString();
    }

    @Override
    @Invisible
    List<Object> getData(YamlStructure.Sorting sorting) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : this.data) {
            if (value instanceof YamlStructure) {
                YamlStructure valueNode = (YamlStructure)value;
                value = valueNode.hasData() ? valueNode.getData(sorting) : null;
            }
            result.add(value);
        }
        return result;
    }

    @Override
    @Invisible
    boolean hasData() {
        return this.data != null && this.data.size() > 0;
    }
}

