/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics;

import java.io.File;
import java.net.URL;

public class Environment {
    private Environment() {
    }

    public static boolean runsInEclipse() {
        boolean result;
        if (System.getProperty("easy.notInEclipse", null) != null) {
            result = false;
        } else {
            String eclipseVersion = System.getProperty("eclipse.buildId", "");
            int major = Environment.parseVersionPart(eclipseVersion, 0);
            int minor = Environment.parseVersionPart(eclipseVersion, 1);
            result = (System.getProperty("eclipse.product", null) != null || System.getProperty("eclipse.home.location", null) != null) && System.getProperty("eclipse.pde.launch") != null;
            result |= System.getProperty("eclipse.vmargs") != null && System.getProperty("equinox.init.uuid") != null;
            if (major >= 4 && minor >= 7) {
                result &= System.getProperty("eclipse.product", "").indexOf("junit") < 0;
            }
        }
        return result;
    }

    private static int parseVersionPart(String version, int part) {
        int result;
        int count = 0;
        int pos = 0;
        while (count < part && pos >= 0 && pos < version.length()) {
            pos = version.indexOf(46, pos + 1);
            ++count;
        }
        if (pos >= 0 && pos < version.length()) {
            int nextPos;
            if (version.charAt(pos) == '.') {
                ++pos;
            }
            version = (nextPos = version.indexOf(46, pos + 1)) > 0 ? version.substring(pos, nextPos) : version.substring(pos);
        }
        try {
            result = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            result = 0;
        }
        return result;
    }

    public static boolean isWinOS() {
        return System.getProperty("os.name").contains("win") || System.getProperty("os.name").contains("Win");
    }

    public static File toFile(URL localURL) {
        String path = localURL.getPath();
        return new File(path);
    }
}

