/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.messages;

import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Status;

public class Message
implements IMessage {
    private String description;
    private Status status;

    public Message(String description, Status status) {
        this.description = description;
        this.status = status;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDetailedDescription() {
        return this.description;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public static boolean containsError(List<Message> messages) {
        boolean hasError = false;
        if (messages != null) {
            int m = 0;
            while (!hasError && m < messages.size()) {
                hasError = Status.ERROR == messages.get(m).getStatus();
                ++m;
            }
        }
        return hasError;
    }

    public static String toString(List<Message> messages, Status filter) {
        StringBuilder result = new StringBuilder();
        if (messages != null) {
            int count = 0;
            int m = 0;
            while (m < messages.size()) {
                Message msg = messages.get(m);
                if (filter == null || filter == msg.getStatus()) {
                    if (count > 0) {
                        result.append(", ");
                    }
                    result.append(msg.getStatus());
                    result.append(":");
                    result.append(msg.getDescription());
                }
                ++m;
            }
        }
        return result.toString();
    }
}

