/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelRepository;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;

class ResolutionContext<M extends IModel> {
    private String modelName;
    private IModelRepository<M> repository;
    private M model;
    private ModelImport<M> toResolve;
    private URI modelUri;
    private List<ModelInfo<M>> inProgress;
    private IRestrictionEvaluationContext evaluationContext;
    private List<ModelImport<M>> conflicts;
    private boolean topLevel = true;
    private List<String> modelLocationPrefixes;

    public ResolutionContext(M model, URI modelUri, ResolutionContext<M> context) {
        this(model, modelUri, context.inProgress, context.repository, context.evaluationContext);
        this.topLevel = false;
    }

    public ResolutionContext(M model, URI modelUri, List<ModelInfo<M>> inProgress, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) {
        this.model = model;
        this.modelUri = modelUri;
        this.inProgress = inProgress;
        this.repository = repository;
        this.evaluationContext = evaluationContext;
        this.collectLocationPrefixes();
    }

    public ResolutionContext(String modelName, URI baseUri, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) {
        this.modelName = modelName;
        this.modelUri = baseUri;
        this.inProgress = null;
        this.repository = repository;
        this.evaluationContext = evaluationContext;
        this.collectLocationPrefixes();
    }

    private void collectLocationPrefixes() {
        if (this.modelUri != null) {
            this.modelLocationPrefixes = new ArrayList<String>();
            for (ModelLocations.Location l : this.getModelRepository().getDefaultLibraryLocations()) {
                this.collectLocationPrefixes(this.modelLocationPrefixes, l);
            }
            ModelLocations.Location modelLocation = this.getModelRepository().getLocationFor(this.getModelURI());
            if (modelLocation != null) {
                while (modelLocation.getDepending() != null) {
                    modelLocation = modelLocation.getDepending();
                }
                this.collectLocationPrefixes(this.modelLocationPrefixes, modelLocation);
            }
        }
    }

    public void setToResolve(ModelImport<M> toResolve) {
        this.toResolve = toResolve;
    }

    public ModelImport<M> getToResolve() {
        return this.toResolve;
    }

    public URI getModelURI() {
        return this.modelUri;
    }

    public M getModel() {
        return this.model;
    }

    public String getModelName() {
        return this.modelName != null ? this.modelName : this.model.getName();
    }

    public IModelRepository<M> getModelRepository() {
        return this.repository;
    }

    public List<String> getModelPaths() {
        ModelLocations.Location location;
        ArrayList<String> result = null;
        URI uri = this.getModelURI();
        if (uri != null && (location = this.repository.getLocationFor(uri)) != null && location.getDependentLocationCount() > 0) {
            result = new ArrayList<String>();
            HashSet<ModelLocations.Location> done = new HashSet<ModelLocations.Location>();
            this.enumerateDependent(location, result, done);
        }
        return result;
    }

    private void enumerateDependent(ModelLocations.Location location, List<String> results, Set<ModelLocations.Location> done) {
        if (!done.contains(location)) {
            if (!done.isEmpty()) {
                results.add(location.getLocation().toURI().toString());
            }
            done.add(location);
            int d = 0;
            while (d < location.getDependentLocationCount()) {
                this.enumerateDependent(location.getDependentLocation(d), results, done);
                ++d;
            }
        }
    }

    public boolean isLoop(ModelInfo<M> info) {
        boolean isLoop = false;
        if (this.inProgress != null) {
            int size = this.inProgress.size();
            int i = 0;
            while (!isLoop && i < size) {
                isLoop = Utils.matches(info, this.inProgress.get(i));
                ++i;
            }
        }
        return isLoop;
    }

    public IRestrictionEvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    private void lazyInitConflicts() {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ModelImport<M>>();
        }
    }

    public void addConflicts(ResolutionContext<M> context) {
        if (context.conflicts != null) {
            this.lazyInitConflicts();
            ResolutionContext.addConflicts(this.conflicts, context.conflicts);
        }
    }

    public static <M extends IModel> List<ModelImport<M>> addConflicts(List<ModelImport<M>> conflicts, List<ModelImport<M>> toAdd) {
        if (toAdd != null) {
            if (conflicts == null) {
                conflicts = new ArrayList<ModelImport<M>>();
            }
            if (conflicts.isEmpty()) {
                conflicts.addAll(toAdd);
            } else {
                HashSet<ModelImport<M>> present = new HashSet<ModelImport<M>>();
                int c = 0;
                int n = conflicts.size();
                while (c < n) {
                    present.add(conflicts.get(c));
                    ++c;
                }
                c = 0;
                n = toAdd.size();
                while (c < n) {
                    ModelImport<M> imp = toAdd.get(c);
                    if (!present.contains(imp)) {
                        conflicts.add(imp);
                    }
                    ++c;
                }
            }
        }
        return conflicts;
    }

    public void addConflict(ModelImport<M> conflict) {
        if (conflict.isConflict()) {
            this.lazyInitConflicts();
            this.conflicts.add(conflict);
        }
    }

    public ModelImport<M> getConflict(M model) throws RestrictionEvaluationException {
        return this.getConflict(model, new HashSet());
    }

    private ModelImport<M> getConflict(M model, Set<M> done) throws RestrictionEvaluationException {
        ModelImport<Object> result = null;
        if (model != null && !done.contains(model)) {
            done.add(model);
            result = this.getConflict(model.getName(), model.getVersion());
            int i = 0;
            while (result == null && i < model.getImportsCount()) {
                ModelImport<?> imp = model.getImport(i);
                if (!imp.isConflict() && imp.getResolved() != null) {
                    result = this.getConflict(imp.getResolved(), done);
                }
                ++i;
            }
        }
        return result;
    }

    private ModelImport<M> getConflict(String modelName, Version version) throws RestrictionEvaluationException {
        ModelImport<M> result = null;
        if (this.conflicts != null) {
            int c = 0;
            int n = this.conflicts.size();
            while (result == null && c < n) {
                ModelImport<M> tmp = this.conflicts.get(c);
                if (modelName.equals(tmp.getName()) && tmp.evaluateRestrictions(this.evaluationContext, version)) {
                    result = tmp;
                }
                ++c;
            }
        }
        return result;
    }

    public boolean isConflict(ModelInfo<M> info) throws RestrictionEvaluationException {
        return this.getConflict(info.getName(), info.getVersion()) != null;
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public boolean considerLoading(boolean isTransitiveEnabled) {
        return this.topLevel || !this.topLevel && isTransitiveEnabled;
    }

    private void collectLocationPrefixes(List<String> result, ModelLocations.Location location) {
        File loc = location.getLocation().getAbsoluteFile();
        try {
            loc = loc.getCanonicalFile();
        }
        catch (IOException e) {
            String tmp = loc.toString();
            loc = new File(tmp.replace("/./", "/").replace("\\.\\", "\\"));
        }
        result.add(loc.toURI().toString());
        int d = 0;
        while (d < location.getDependentLocationCount()) {
            this.collectLocationPrefixes(result, location.getDependentLocation(d));
            ++d;
        }
    }

    public List<VersionedModelInfos<M>> filterByLocations(List<VersionedModelInfos<M>> list) {
        List<VersionedModelInfos<M>> result = list;
        if (list != null && list.size() > 0 && this.modelLocationPrefixes != null && this.modelLocationPrefixes.size() > 0) {
            result = new ArrayList<VersionedModelInfos<M>>();
            int l = list.size() - 1;
            while (l >= 0) {
                VersionedModelInfos<int> infos = list.get(l);
                int size = infos.size();
                VersionedModelInfos<int> res = new VersionedModelInfos<int>(infos.getVersion());
                int i = size - 1;
                while (i >= 0) {
                    ModelInfo<int> info = infos.get(i);
                    boolean contained = false;
                    int p = 0;
                    while (!contained && p < this.modelLocationPrefixes.size()) {
                        contained = info.getLocation().toString().startsWith(this.modelLocationPrefixes.get(p));
                        ++p;
                    }
                    if (contained) {
                        res.add(info);
                    }
                    --i;
                }
                if (res.size() > 0) {
                    result.add(res);
                }
                --l;
            }
        }
        return result;
    }

    public void filterByLocation(ModelLocations.Location location) {
    }

    public boolean isInProjectFolder(ModelInfo<M> info) {
        return ModelManagement.isInProjectFolder(this.modelUri, info.getLocation());
    }
}

