/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelData;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;

public class Utils {
    private Utils() {
    }

    public static boolean matches(IModelData data1, IModelData data2) {
        boolean result;
        boolean bl = result = data1.getName().equals(data2.getName()) && Utils.sameVersion(data1.getVersion(), data2.getVersion());
        if (data1 instanceof ModelInfo && data2 instanceof ModelInfo) {
            ModelInfo info1 = (ModelInfo)data1;
            ModelInfo info2 = (ModelInfo)data2;
            result = result && info1.getLocation().compareTo(info2.getLocation()) == 0;
        }
        return result;
    }

    static boolean sameVersion(Version version1, Version version2) {
        boolean result = version1 == null ? version2 == null : version1.compareTo(version2) == 0;
        return result;
    }

    static StringBuilder appendErrors(StringBuilder builder, String errors) {
        if (errors != null && errors.length() > 0) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(errors);
        }
        return builder;
    }

    static <M extends IModel> void collectModelInfo(Collection<List<VersionedModelInfos<M>>> availableModels, List<ModelInfo<M>> info, Map<M, ModelInfo<M>> modelInfoMap) {
        for (List<VersionedModelInfos<M>> vInfos : availableModels) {
            int vInfosSize = vInfos.size();
            int i = 0;
            while (i < vInfosSize) {
                VersionedModelInfos<int> vInfo = vInfos.get(i);
                int j = 0;
                while (j < vInfo.size()) {
                    ModelInfo<int> pi = vInfo.get(j);
                    if (info != null) {
                        info.add(pi);
                    }
                    if (modelInfoMap != null && pi.isResolved()) {
                        modelInfoMap.put(pi.getResolved(), pi);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    static <M extends IModel> List<ModelInfo<M>> augmentByDepending(List<ModelInfo<M>> infos, List<ModelInfo<M>> allInfos, Map<M, ModelInfo<M>> modelInfoMap) {
        ArrayList<ModelInfo<M>> topLevel = new ArrayList<ModelInfo<M>>();
        topLevel.addAll(infos);
        HashSet<ModelInfo<M>> known = new HashSet<ModelInfo<M>>();
        known.addAll(infos);
        int lastSize = infos.size();
        while (true) {
            int j = 0;
            while (j < allInfos.size()) {
                ModelInfo<M> info = allInfos.get(j);
                if (info.isResolved() && !known.contains(info)) {
                    boolean isInteresting = false;
                    int p = 0;
                    while (p < info.getImportsCount()) {
                        ModelInfo<M> resolved;
                        ModelImport<M> imp = info.getImport(p);
                        if (!imp.isConflict() && imp.isResolved() && known.contains(resolved = modelInfoMap.get(imp.getResolved()))) {
                            isInteresting = true;
                            topLevel.remove(resolved);
                        }
                        ++p;
                    }
                    if (isInteresting) {
                        known.add(info);
                        infos.add(info);
                        topLevel.add(info);
                    }
                }
                ++j;
            }
            int curSize = infos.size();
            if (curSize == lastSize) break;
            lastSize = curSize;
        }
        return topLevel;
    }

    public static File toExistingFile(URI uri) {
        File result = null;
        if (uri != null && !(result = new File(uri)).exists()) {
            result = null;
        }
        return result;
    }

    static <M extends IModel> void enumerateImported(M model, Set<M> result, Set<M> deleteFrom) {
        if (model != null && !result.contains(model)) {
            result.add(model);
            if (deleteFrom != null) {
                deleteFrom.remove(model);
            }
            int iCount = model.getImportsCount();
            int i = 0;
            while (i < iCount) {
                Utils.enumerateImported(model.getImport(i).getResolved(), result, deleteFrom);
                ++i;
            }
        }
    }

    public static synchronized <M extends IModel> List<M> discoverImports(M mainModel) {
        ArrayList allModels = new ArrayList();
        Utils.findImportedModels(mainModel, allModels, new HashSet());
        return Utils.arrangeImportedModels(allModels);
    }

    private static <M extends IModel> void findImportedModels(M model, List<M> allModels, Set<M> done) {
        if (!done.contains(model)) {
            done.add(model);
            allModels.add(model);
            int i = 0;
            int n = model.getImportsCount();
            while (i < n) {
                Object importedModel = model.getImport(i).getResolved();
                if (importedModel != null) {
                    Utils.findImportedModels(importedModel, allModels, done);
                }
                ++i;
            }
        }
    }

    private static <M extends IModel> List<M> arrangeImportedModels(List<M> models) {
        ArrayList sequence = new ArrayList();
        HashSet done = new HashSet();
        int y = models.size() - 1;
        while (y >= 0) {
            IModel project = (IModel)models.get(y);
            if (!done.contains(project)) {
                Utils.arrangeImportedModels(project, done, sequence);
            }
            --y;
        }
        return sequence;
    }

    private static <M extends IModel> void arrangeImportedModels(M model, Set<M> alreadyVisited, List<M> sequence) {
        alreadyVisited.add(model);
        int i = 0;
        int n = model.getImportsCount();
        while (i < n) {
            Object importedProject = model.getImport(i).getResolved();
            if (importedProject != null && !alreadyVisited.contains(importedProject)) {
                Utils.arrangeImportedModels(importedProject, alreadyVisited, sequence);
            }
            ++i;
        }
        sequence.add(model);
    }

    public static <M extends IModel> void printResolution(M model, ModelManagement<M> mgt) {
        if (model != null) {
            System.out.print("Import resolution:");
            Utils.printResolution(model, mgt, new HashSet(), "");
        }
    }

    private static <M extends IModel> void printModelInfo(M model, ModelManagement<M> mgt) {
        ModelInfo<M> info;
        System.out.print(model.getName());
        if (model.getVersion() != null) {
            System.out.print(" " + String.valueOf(model.getVersion()));
        }
        if (mgt != null && (info = mgt.availableModels().getModelInfo(model)) != null) {
            System.out.print(" -> " + String.valueOf(info.getLocation()));
        }
        System.out.println();
    }

    private static <M extends IModel> void printResolution(M model, ModelManagement<M> mgt, Set<M> done, String indent) {
        boolean isDone = done.contains(model);
        String marker = isDone ? "~" : "-";
        System.out.print(indent + marker + " ");
        Utils.printModelInfo(model, mgt);
        if (!isDone) {
            done.add(model);
            if (model.getSuper() != null) {
                System.out.println(indent + "- super:");
                Utils.printResolution(model.getSuper().getResolved(), mgt, done, indent + "  ");
            }
            int m = 0;
            while (m < model.getImportsCount()) {
                ModelImport<?> imp = model.getImport(m);
                System.out.println(indent + "- import:" + imp.getName());
                Utils.printResolution(imp.getResolved(), mgt, done, indent + "  ");
                ++m;
            }
        }
    }
}

