/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;

public class VersionedModelInfos<M extends IModel> {
    private Version version;
    private List<ModelInfo<M>> infos = new ArrayList<ModelInfo<M>>();

    public VersionedModelInfos(Version version) {
        this.version = version;
    }

    public void add(ModelInfo<M> info) {
        ModelInfo<M> first;
        assert (info != null);
        if (!Version.equals(info.getVersion(), this.version)) {
            throw new IllegalArgumentException("versions do not match");
        }
        if (!this.infos.isEmpty() && !(first = this.infos.get(0)).getName().equals(info.getName())) {
            throw new IllegalArgumentException("names do not match");
        }
        int i = 0;
        while (i < this.infos.size()) {
            ModelInfo<M> tmp = this.infos.get(i);
            if (VersionedModelInfos.isSame(tmp.getLocation(), info.getLocation()) && tmp.getLoader() == info.getLoader()) {
                throw new IllegalArgumentException("URI and loader match");
            }
            ++i;
        }
        this.infos.add(info);
    }

    public static final boolean isSame(URI uri1, URI uri2) {
        return uri1 == null && uri1 == uri2 || uri1 != null && uri1.equals(uri2);
    }

    public ModelInfo<M> get(int index) {
        return this.infos.get(index);
    }

    public ModelInfo<M> get(M model) {
        ModelInfo<M> result = null;
        int size = this.infos.size();
        int i = 0;
        while (i < size) {
            ModelInfo<M> tmp = this.infos.get(i);
            if (tmp.getResolved() == model) {
                result = tmp;
            }
            ++i;
        }
        return result;
    }

    public ModelInfo<M> get(URI uri) {
        ModelInfo<M> result = null;
        int size = this.infos.size();
        int i = 0;
        while (i < size) {
            ModelInfo<M> tmp = this.infos.get(i);
            if (uri == null && tmp.getLocation() == uri || uri != null && uri.equals(tmp.getLocation())) {
                result = tmp;
            }
            ++i;
        }
        return result;
    }

    public int size() {
        return this.infos.size();
    }

    public ModelInfo<M> remove(int index) {
        return this.infos.remove(index);
    }

    public void clear() {
        this.infos.clear();
    }

    public boolean remove(ModelInfo<M> info) {
        return this.infos.remove(info);
    }

    public Version getVersion() {
        return this.version;
    }

    public List<ModelInfo<M>> getByEqualUri(URI uri) {
        ArrayList<ModelInfo<M>> result = null;
        if (uri != null) {
            uri = uri.normalize();
            int size = this.infos.size();
            int i = 0;
            while (i < size) {
                ModelInfo<M> info = this.infos.get(i);
                if (info.getLocation() != null && uri.equals(info.getLocation())) {
                    if (result == null) {
                        result = new ArrayList<ModelInfo<M>>();
                    }
                    result.add(info);
                }
                ++i;
            }
        }
        return result;
    }

    public ModelInfo<M> getByClosestUri(URI uri, List<String> modelPath) {
        return VersionedModelInfos.getByClosestUri(this.infos, uri, modelPath);
    }

    public static <M extends IModel> ModelInfo<M> getByClosestUri(List<ModelInfo<M>> infos, URI uri, List<String> modelPath) {
        ModelInfo<M> result = null;
        int size = infos.size();
        if (size > 0) {
            if (uri == null) {
                result = infos.get(0);
            } else {
                int i = 0;
                while (result == null && i < size) {
                    ModelInfo<M> info = infos.get(i);
                    if (VersionedModelInfos.isSame(uri, info.getLocation())) {
                        result = info;
                    }
                    ++i;
                }
                String searchUriText = VersionedModelInfos.pathWithoutLastFragment(uri.normalize());
                if (result == null) {
                    result = VersionedModelInfos.search(infos, searchUriText, modelPath);
                    if (result == null) {
                        result = VersionedModelInfos.searchOnParentLevel(infos, uri, modelPath);
                    }
                    if (result == null) {
                        result = VersionedModelInfos.searchOnSameFolderLevel(infos, uri, modelPath);
                    }
                }
                if (modelPath != null) {
                    int i2 = 0;
                    while (result == null && i2 < size) {
                        ModelInfo<M> info = infos.get(i2);
                        int m = 0;
                        while (result == null && m < modelPath.size()) {
                            if (VersionedModelInfos.isMatching(info.getLocation().toString(), modelPath.get(m), false)) {
                                result = info;
                            }
                            ++m;
                        }
                        ++i2;
                    }
                }
            }
        }
        return result;
    }

    private static <M extends IModel> ModelInfo<M> search(List<ModelInfo<M>> infos, String searchUriText, List<String> modelPath) {
        ModelInfo<M> result = null;
        int matchLength = 0;
        int b = 0;
        while (result == null && matchLength == 0 && b < 2) {
            int size = infos.size();
            int i = 0;
            while (i < size) {
                ModelInfo<M> info = infos.get(i);
                URI infoUri = info.getLocation();
                if (infoUri != null) {
                    String infoUriText = VersionedModelInfos.pathWithoutLastFragment(infoUri);
                    if (VersionedModelInfos.isMatching(searchUriText, modelPath, infoUriText, b == 0)) {
                        boolean isBestMatch = matchLength == 0;
                        isBestMatch |= b == 0 && infoUriText.length() < matchLength;
                        if (isBestMatch |= 1 == b && infoUriText.length() > matchLength) {
                            result = infos.get(i);
                            matchLength = infoUriText.length();
                        }
                    }
                }
                ++i;
            }
            ++b;
        }
        return result;
    }

    private static <M extends IModel> ModelInfo<M> searchOnParentLevel(List<ModelInfo<M>> infos, URI uri, List<String> modelPath) {
        ModelInfo<M> result = null;
        if (VersionedModelInfos.isFileScheme(uri)) {
            File[] siblings;
            File uriFile = new File(uri);
            File uriParent = uriFile.getParentFile();
            File parent = uriParent;
            if (parent != null) {
                parent = parent.getName().startsWith(".") ? parent.getParentFile() : null;
            }
            if (parent != null && (siblings = parent.listFiles()) != null) {
                int s = 0;
                while (result == null && s < siblings.length) {
                    File sibling = siblings[s];
                    if (sibling.isDirectory() && !sibling.equals(uriParent)) {
                        URI siblingUri = sibling.toURI().normalize();
                        result = VersionedModelInfos.search(infos, siblingUri.toString(), modelPath);
                    }
                    ++s;
                }
            }
        }
        return result;
    }

    private static <M extends IModel> ModelInfo<M> searchOnSameFolderLevel(List<ModelInfo<M>> infos, URI uri, List<String> modelPath) {
        ModelInfo result = null;
        if (VersionedModelInfos.isFileScheme(uri)) {
            ArrayList<ModelInfo<M>> tmp = new ArrayList<ModelInfo<M>>();
            File uriFile = new File(uri).getParentFile();
            File searchFolder = uriFile.getParentFile();
            if (searchFolder != null) {
                File[] files = searchFolder.listFiles();
                int f = 0;
                while (files != null && f < files.length) {
                    String searchUriText;
                    ModelInfo<M> searchResult;
                    File file = files[f];
                    if (file.isDirectory() && !file.equals(uriFile) && (searchResult = VersionedModelInfos.search(infos, searchUriText = file.toURI().normalize().toString(), modelPath)) != null) {
                        tmp.add(searchResult);
                    }
                    ++f;
                }
            }
            if (1 == tmp.size()) {
                result = (ModelInfo)tmp.get(0);
            }
        }
        return result;
    }

    public static boolean isFileScheme(URI uri) {
        return "file".equals(uri.getScheme());
    }

    private static boolean isMatching(String searchUriText, List<String> modelPath, String importUriText, boolean contained) {
        boolean matches = VersionedModelInfos.isMatching(searchUriText, importUriText, contained);
        if (!matches && modelPath != null) {
            int size = modelPath.size();
            int p = 0;
            while (!matches && p < size) {
                matches = VersionedModelInfos.isMatching(searchUriText, modelPath.get(p), contained);
                ++p;
            }
        }
        return matches;
    }

    private static boolean isMatching(String searchUriText, String importUriText, boolean contained) {
        return contained ? importUriText.startsWith(searchUriText) : searchUriText.startsWith(importUriText);
    }

    public static String pathWithoutLastFragment(URI uri) {
        String uriText = uri.toString();
        int pos = uriText.lastIndexOf(47);
        if (pos > 0) {
            uriText = uriText.substring(0, pos + 1);
        }
        return uriText;
    }

    public List<ModelInfo<M>> toList(List<ModelInfo<M>> list) {
        if (list == null) {
            list = new ArrayList<ModelInfo<M>>();
        }
        int i = 0;
        while (i < this.infos.size()) {
            list.add(this.infos.get(i));
            ++i;
        }
        return list;
    }

    public String toString() {
        return String.valueOf(this.version) + " " + String.valueOf(this.infos);
    }

    public ModelInfo<M> find(URI uri) {
        ModelInfo<M> result = null;
        if (uri != null) {
            int size = this.infos.size();
            int i = 0;
            while (result == null && i < size) {
                ModelInfo<M> info = this.infos.get(i);
                if (uri.equals(info.getLocation())) {
                    result = info;
                }
                ++i;
            }
        }
        return result;
    }

    public static <M extends IModel> VersionedModelInfos<M> find(List<VersionedModelInfos<M>> infos, Version version) {
        VersionedModelInfos<M> result = null;
        if (infos != null) {
            int i = 0;
            while (result == null && i < infos.size()) {
                VersionedModelInfos<M> info = infos.get(i);
                if (Version.equals(info.getVersion(), version)) {
                    result = info;
                }
                ++i;
            }
        }
        return result;
    }

    public static <M extends IModel> ModelInfo<M> maxVersion(List<ModelInfo<M>> list) {
        ModelInfo<M> result = null;
        if (list != null) {
            Version highest = null;
            int i = 0;
            int n = list.size();
            while (i < n) {
                ModelInfo<M> tmp = list.get(i);
                Version tmpVersion = tmp.getVersion();
                if (result == null || Version.compare(tmpVersion, highest) > 0) {
                    result = tmp;
                    highest = tmpVersion;
                }
                ++i;
            }
        }
        return result;
    }
}

