/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.model;

import au.com.jcloud.lxd.model.extra.NetworkInterface;
import au.com.jcloud.lxd.util.FormatUtils;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;

public class State {
    public static final String MEM_USAGE = "usage";
    public static final String MEM_USAGE_PEAK = "usage_peak";
    public static final String MEM_SWAP_USAGE = "swap_usage";
    public static final String MEM_SWAP_USAGE_PEAK = "swap_usage_peak";
    public static final int STATUS_CODE_RUNNING = 103;
    public static final int STATUS_CODE_STOPPED = 102;
    public static final int STATUS_CODE_FROZEN = 110;
    private String status;
    @SerializedName(value="status_code")
    private int statusCode;
    private Map<String, Map<String, String>> disk;
    private Map<String, Long> memory;
    private Map<MemoryEnum, Long> memoryData = new HashMap<MemoryEnum, Long>();
    private Map<String, NetworkInterface> network;
    int pid;
    int processes;

    public String toString() {
        return "pid=" + this.pid + " status=" + this.status + "(" + this.statusCode + ") processes=" + this.processes + " memory=" + this.getMemoryUsageInMB() + "MB/" + this.getMemoryPeakUsageInMB() + "MB swap=" + this.getSwapMemoryUsageInMB() + "MB/" + this.getSwapMemoryPeakUsageInMB() + "MB network=" + this.network;
    }

    public boolean isRunning() {
        return this.statusCode == 103;
    }

    public boolean isStopped() {
        return this.statusCode == 102;
    }

    public boolean isFrozen() {
        return this.statusCode == 110;
    }

    public String getMemoryUsageInMB() {
        return this.getMemoryInMB(MemoryEnum.USAGE);
    }

    public String getMemoryPeakUsageInMB() {
        return this.getMemoryInMB(MemoryEnum.USAGE_PEAK);
    }

    public String getSwapMemoryUsageInMB() {
        return this.getMemoryInMB(MemoryEnum.SWAP_USAGE);
    }

    public String getSwapMemoryPeakUsageInMB() {
        return this.getMemoryInMB(MemoryEnum.SWAP_USAGE_PEAK);
    }

    public String getMemoryInMB(MemoryEnum type) {
        this.getMemoryData();
        Long memoryValue = this.memoryData.get((Object)type);
        return memoryValue != null ? FormatUtils.convertIntegerToMB(memoryValue) : "0";
    }

    public Map<MemoryEnum, Long> getMemoryData() {
        if (!this.memoryData.isEmpty()) {
            return this.memoryData;
        }
        if (this.memory != null) {
            for (String key : this.memory.keySet()) {
                if (key.equals(MEM_USAGE)) {
                    this.memoryData.put(MemoryEnum.USAGE, this.memory.get(key));
                    continue;
                }
                if (key.equals(MEM_USAGE_PEAK)) {
                    this.memoryData.put(MemoryEnum.USAGE_PEAK, this.memory.get(key));
                    continue;
                }
                if (key.equals(MEM_SWAP_USAGE)) {
                    this.memoryData.put(MemoryEnum.SWAP_USAGE, this.memory.get(key));
                    continue;
                }
                if (!key.equals(MEM_SWAP_USAGE_PEAK)) continue;
                this.memoryData.put(MemoryEnum.SWAP_USAGE_PEAK, this.memory.get(key));
            }
        }
        return this.memoryData;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Map<String, Map<String, String>> getDisk() {
        return this.disk;
    }

    public void setDisk(Map<String, Map<String, String>> disk) {
        this.disk = disk;
    }

    public Map<String, Long> getMemory() {
        return this.memory;
    }

    public void setMemory(Map<String, Long> memory) {
        this.memory = memory;
    }

    public Map<String, NetworkInterface> getNetwork() {
        return this.network;
    }

    public void setNetwork(Map<String, NetworkInterface> network) {
        this.network = network;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getProcesses() {
        return this.processes;
    }

    public void setProcesses(int processes) {
        this.processes = processes;
    }

    static enum MemoryEnum {
        USAGE,
        USAGE_PEAK,
        SWAP_USAGE,
        SWAP_USAGE_PEAK;

    }
}

