/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.service;

import au.com.jcloud.lxd.bean.ImageConfig;
import au.com.jcloud.lxd.bean.LxdServerCredential;
import au.com.jcloud.lxd.enums.ContainerStateAction;
import au.com.jcloud.lxd.model.Certificate;
import au.com.jcloud.lxd.model.Container;
import au.com.jcloud.lxd.model.Image;
import au.com.jcloud.lxd.model.ImageAlias;
import au.com.jcloud.lxd.model.Network;
import au.com.jcloud.lxd.model.Operation;
import au.com.jcloud.lxd.model.Profile;
import au.com.jcloud.lxd.model.ServerInfo;
import au.com.jcloud.lxd.model.Snapshot;
import au.com.jcloud.lxd.model.State;
import au.com.jcloud.lxd.service.ILxdApiService;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public interface ILxdService {
    public ILxdService clone() throws CloneNotSupportedException;

    public void setLxdApiService(ILxdApiService var1);

    public LxdServerCredential getLxdServerCredential();

    public void setLxdServerCredential(LxdServerCredential var1);

    public ServerInfo loadServerInfo() throws IOException, InterruptedException;

    public Map<String, Container> loadContainerMap() throws IOException, InterruptedException;

    public Container loadContainer(String var1) throws IOException, InterruptedException;

    public State loadContainerState(String var1) throws IOException, InterruptedException;

    public Map<String, Image> loadImageMap() throws IOException, InterruptedException;

    public Image loadImage(String var1) throws IOException, InterruptedException;

    public void deleteImage(String var1) throws IOException, InterruptedException;

    public void changeContainerState(String var1, ContainerStateAction var2, boolean var3, boolean var4, String var5) throws IOException, InterruptedException;

    public void startContainer(String var1) throws IOException, InterruptedException;

    public void stopContainer(String var1) throws IOException, InterruptedException;

    public void deleteContainer(String var1) throws IOException, InterruptedException;

    public void createContainer(String var1, String var2) throws IOException, InterruptedException;

    public void createContainer(String var1, String var2, ImageConfig var3) throws IOException, InterruptedException;

    public void renameContainer(String var1, String var2) throws IOException, InterruptedException;

    public void copyContainer(String var1, String var2, Boolean var3) throws IOException, InterruptedException;

    public void execOnContainer(String var1, String[] var2, String var3, Boolean var4) throws IOException, InterruptedException;

    public Map<String, Operation> loadOperationMap() throws IOException, InterruptedException;

    public Operation loadOperation(String var1) throws IOException, InterruptedException;

    public Map<String, Network> loadNetworkMap() throws IOException, InterruptedException;

    public Network loadNetwork(String var1) throws IOException, InterruptedException;

    public Collection<Container> loadContainersUsedByNetwork(Network var1) throws IOException, InterruptedException;

    public void deleteNetwork(String var1) throws IOException, InterruptedException;

    public Map<String, Profile> loadProfileMap() throws IOException, InterruptedException;

    public Profile loadProfile(String var1) throws IOException, InterruptedException;

    public void deleteProfile(String var1) throws IOException, InterruptedException;

    public Map<String, Certificate> loadCertificateMap() throws IOException, InterruptedException;

    public Certificate loadCertificate(String var1) throws IOException, InterruptedException;

    public Map<String, Snapshot> loadSnapshotMap(Container var1) throws IOException, InterruptedException;

    public Snapshot loadSnapshot(String var1, String var2) throws IOException, InterruptedException;

    public void renameSnapshot(String var1, String var2, String var3) throws IOException, InterruptedException;

    public void createSnapshot(String var1, String var2) throws IOException, InterruptedException;

    public void deleteSnapshot(String var1, String var2) throws IOException, InterruptedException;

    public Map<String, ImageAlias> loadImageAliasMap() throws IOException, InterruptedException;

    public ImageAlias loadImageAlias(String var1) throws IOException, InterruptedException;

    public void createImageAlias(String var1, String var2) throws IOException, InterruptedException;

    public void deleteImageAlias(String var1) throws IOException, InterruptedException;

    public void renameImageAlias(String var1, String var2) throws IOException, InterruptedException;

    public String loadFile(String var1, String var2) throws IOException, InterruptedException;
}

