/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse;

import com.google.inject.Guice;
import com.google.inject.Module;
import de.uni_hildesheim.sse.ConstraintSyntaxException;
import de.uni_hildesheim.sse.IvmlRuntimeModule;
import de.uni_hildesheim.sse.IvmlStandaloneSetup;
import de.uni_hildesheim.sse.ivml.ConflictStmt;
import de.uni_hildesheim.sse.ivml.DerivedType;
import de.uni_hildesheim.sse.ivml.Expression;
import de.uni_hildesheim.sse.ivml.ExpressionStatement;
import de.uni_hildesheim.sse.ivml.Project;
import de.uni_hildesheim.sse.ivml.Type;
import de.uni_hildesheim.sse.ivml.VariabilityUnit;
import de.uni_hildesheim.sse.ivml.VersionStmt;
import de.uni_hildesheim.sse.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.translation.ImportTranslator;
import de.uni_hildesheim.sse.translation.ModelTranslator;
import de.uni_hildesheim.sse.translation.TypeContext;
import de.uni_hildesheim.sse.translation.Utils;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IDeferredModelLoader;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.LogMessageReceiver;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.persistency.ConfigurableIVMLWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

public class ModelUtility
extends net.ssehub.easy.dslCore.ModelUtility<VariabilityUnit, net.ssehub.easy.varModel.model.Project>
implements IModelLoader<net.ssehub.easy.varModel.model.Project> {
    public static final ModelUtility INSTANCE = new ModelUtility();
    private final LogMessageReceiver logReceiver = new LogMessageReceiver(((Object)((Object)this)).getClass(), "de.uni_hildesheim.sse.ivml");

    private ModelUtility() {
    }

    protected void initializeAfterResourceInitializer() {
        if (ModelUtility.getResourceInitializer().forEclipse()) {
            this.setInjector(Guice.createInjector((Module[])new Module[]{new IvmlRuntimeModule()}));
        } else {
            this.setInjector(new IvmlStandaloneSetup().createInjectorAndDoEMFRegistration());
        }
    }

    protected String getLanguageName() {
        return "de.uni_hildesheim.sse.Ivml";
    }

    protected ClassLoader getLanguageClassLoader() {
        return ModelUtility.class.getClassLoader();
    }

    public TranslationResult<net.ssehub.easy.varModel.model.Project> createVarModel(VariabilityUnit root, java.net.URI uri, boolean registerSuccessful) {
        ModelTranslator translator = new ModelTranslator();
        ImportResolver impResolver = VarModel.INSTANCE.getResolverFromPool();
        ModelTranslator.Result mRes = translator.createModel(root, uri, registerSuccessful, (ImportResolver<net.ssehub.easy.varModel.model.Project>)impResolver);
        impResolver.addDeferredLoader((IDeferredModelLoader)mRes);
        VarModel.INSTANCE.releaseResolver(impResolver);
        return mRes.createTranslationResult();
    }

    public void print(TranslationResult<net.ssehub.easy.varModel.model.Project> result, Writer out, boolean emitComments, boolean emitImports) {
        try {
            ConfigurableIVMLWriter writer = new ConfigurableIVMLWriter(out, emitComments, emitImports);
            int p = 0;
            while (p < result.getResultCount()) {
                ((net.ssehub.easy.varModel.model.Project)result.getResult(p)).accept((IModelVisitor)writer);
                ++p;
            }
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TranslationResult<net.ssehub.easy.varModel.model.Project> parse(URI uri, ImportResolver<net.ssehub.easy.varModel.model.Project> resolver) throws IOException {
        ImportResolver impResolver = resolver == null ? VarModel.INSTANCE.getResolverFromPool() : resolver;
        ModelTranslator translator = new ModelTranslator();
        VariabilityUnit root = (VariabilityUnit)this.parse(uri, false, (MessageReceiver)translator, VariabilityUnit.class);
        ModelTranslator.Result mRes = null;
        try {
            mRes = root != null ? translator.createModel(root, ModelUtility.toNetUri((URI)uri), true, (ImportResolver<net.ssehub.easy.varModel.model.Project>)impResolver) : translator.createEmptyResult(ModelUtility.toNetUri((URI)uri));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        impResolver.addDeferredLoader((IDeferredModelLoader)mRes);
        if (resolver == null) {
            VarModel.INSTANCE.releaseResolver(impResolver);
        }
        return mRes.createTranslationResult();
    }

    public List<ModelInfo<net.ssehub.easy.varModel.model.Project>> obtainInfo(URI uri) throws IOException {
        this.logReceiver.setLocationHint(uri);
        VariabilityUnit root = (VariabilityUnit)this.parse(uri, true, (MessageReceiver)this.logReceiver, VariabilityUnit.class);
        ArrayList<ModelInfo<net.ssehub.easy.varModel.model.Project>> result = new ArrayList<ModelInfo<net.ssehub.easy.varModel.model.Project>>();
        if (root != null) {
            for (Project project : root.getProjects()) {
                Version version = null;
                VersionStmt versionStatement = project.getVersion();
                String vString = versionStatement == null ? null : versionStatement.getVersion();
                if (vString == null) {
                    version = null;
                } else {
                    try {
                        version = new Version(vString);
                    }
                    catch (VersionFormatException versionFormatException) {
                        // empty catch block
                    }
                }
                ArrayList<ProjectImport> imp = new ArrayList<ProjectImport>();
                for (Object importStmt : project.getImports()) {
                    try {
                        imp.add(ImportTranslator.processImport(importStmt));
                    }
                    catch (TranslatorException e) {
                        throw new IOException(e);
                    }
                }
                for (Object importStmt : project.getConflicts()) {
                    try {
                        imp.add(ImportTranslator.processConflict((ConflictStmt)importStmt));
                    }
                    catch (TranslatorException translatorException) {
                        // empty catch block
                    }
                }
                try {
                    result.add((ModelInfo<net.ssehub.easy.varModel.model.Project>)new ModelInfo(project.getName(), version, (IModelLoader)this, ModelUtility.toNetUri((URI)uri), imp));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        }
        return result;
    }

    public static final String stringValue(Type type) {
        return ModelUtility.stringValue(type, false);
    }

    public static final String stringValue(Type type, boolean forSearch) {
        String result;
        if (type != null) {
            if (type.getDerived() != null) {
                String op = type.getDerived().getOp();
                if (forSearch) {
                    if (op.equals("setOf")) {
                        op = "s";
                    } else if (op.equals("sequenceOf")) {
                        op = "q";
                    } else if (op.equals("refTo")) {
                        op = "r";
                    }
                }
                result = ModelUtility.stringValue(type.getDerived(), forSearch);
            } else {
                result = type.getType() != null ? type.getType().getType() : (type.getId() != null ? Utils.getQualifiedNameString(type.getId()) : "<unknown type>");
            }
        } else {
            result = "";
        }
        return result;
    }

    public static final String stringValue(DerivedType type, boolean forSearch) {
        String op = type.getOp();
        if (forSearch) {
            if (op.equals("setOf")) {
                op = "s";
            } else if (op.equals("sequenceOf")) {
                op = "q";
            } else if (op.equals("refTo")) {
                op = "r";
            }
        }
        return op + "(" + ModelUtility.stringValue(type.getType(), forSearch) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constraint createConstraint(String text, net.ssehub.easy.varModel.model.Project project, boolean asStatement) throws CSTSemanticException, ConstraintSyntaxException {
        ExpressionStatement stm;
        ExpressionTranslator translator;
        Constraint constraint = null;
        String ruleName = asStatement ? "ExpressionStatement" : "Expression";
        IParseResult result = this.parseFragment(ruleName, text);
        if (result == null) throw new ConstraintSyntaxException("internal: IVML grammar not available");
        StringBuilder errors = new StringBuilder();
        for (INode error : result.getSyntaxErrors()) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)error.getText());
        }
        if (errors.length() == 0 && result.getRootASTElement() == null) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)"empty constraint");
        }
        if (errors.length() != 0) throw new ConstraintSyntaxException(errors.toString());
        ExpressionTranslator messageReceiver = translator = new ExpressionTranslator();
        Expression expr = asStatement ? ((stm = (ExpressionStatement)result.getRootASTElement()) != null ? stm.getExpr() : null) : (Expression)result.getRootASTElement();
        TypeContext context = new TypeContext(project, (MessageReceiver)messageReceiver);
        constraint = new Constraint((IModelElement)project);
        try {
            constraint.setConsSyntax(translator.processExpression(expr, context, (IModelElement)constraint));
            if (translator.getErrorCount() > 0) {
                int i = 0;
                while (i < translator.getMessageCount()) {
                    Message msg = translator.getMessage(i);
                    if (Status.ERROR == msg.getStatus()) {
                        ModelUtility.appendWithNewLine((StringBuilder)errors, (String)msg.getDescription());
                    }
                    ++i;
                }
                throw new CSTSemanticException(errors.toString(), 10103);
            }
            constraint.getConsSyntax().inferDatatype();
            return constraint;
        }
        catch (TranslatorException e) {
            throw new CSTSemanticException(e.getMessage(), 10103);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConstraintSyntaxTree createExpression(IDatatype type, String text, net.ssehub.easy.varModel.model.Project parent) throws CSTSemanticException, ConstraintSyntaxException {
        ConstraintSyntaxTree cst = null;
        if (type == null) {
            return this.createExpression(text, (IModelElement)parent);
        }
        Object expression = text;
        if (TypeQueries.isContainer((IDatatype)type)) {
            expression = "let " + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)type) + " tmp = " + (String)expression + " in tmp <> null;";
            cst = this.createConstraint((String)expression, parent, true).getConsSyntax();
            if (!(cst instanceof Let)) throw new CSTSemanticException("Cannot construct temporary let expression", 10103);
            return ((Let)cst).getInitExpression();
        }
        if (!TypeQueries.isCompound((IDatatype)type)) return this.createExpression((String)expression, (IModelElement)parent);
        if (!((String)expression).trim().startsWith("{")) return this.createExpression((String)expression, (IModelElement)parent);
        expression = IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)type) + (String)expression;
        return this.createExpression((String)expression, (IModelElement)parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConstraintSyntaxTree createExpression(String text, IModelElement parent) throws CSTSemanticException, ConstraintSyntaxException {
        IDatatype type;
        ExpressionTranslator translator;
        ConstraintSyntaxTree expression = null;
        IParseResult result = this.parseFragment("Expression", text);
        if (result == null) throw new ConstraintSyntaxException("internal: IVML grammar not available");
        StringBuilder errors = new StringBuilder();
        for (INode error : result.getSyntaxErrors()) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)error.getText());
        }
        if (errors.length() == 0 && result.getRootASTElement() == null) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)"empty constraint");
        }
        if (errors.length() != 0) throw new ConstraintSyntaxException(errors.toString());
        ExpressionTranslator messageReceiver = translator = new ExpressionTranslator();
        Expression expr = (Expression)result.getRootASTElement();
        IModelElement expressionParent = null;
        if (parent instanceof AbstractVariable && (type = ((AbstractVariable)parent).getType()) instanceof IModelElement) {
            parent = (IModelElement)type;
        }
        IModelElement iter = parent;
        while (iter != null && !(iter instanceof net.ssehub.easy.varModel.model.Project)) {
            if (iter instanceof Compound) {
                expressionParent = iter;
            }
            iter = iter.getParent();
        }
        net.ssehub.easy.varModel.model.Project project = null;
        if (iter instanceof net.ssehub.easy.varModel.model.Project) {
            project = (net.ssehub.easy.varModel.model.Project)iter;
        }
        if (expressionParent == null) {
            expressionParent = project == null ? parent : project;
        }
        TypeContext context = new TypeContext(project, (MessageReceiver)messageReceiver);
        if (expressionParent instanceof Compound) {
            context.pushLayer(expressionParent);
            context.addToContext((Compound)expressionParent);
        }
        try {
            expression = translator.processExpression(expr, context, expressionParent);
            if (translator.getErrorCount() > 0) {
                int i = 0;
                while (i < translator.getMessageCount()) {
                    Message msg = translator.getMessage(i);
                    if (Status.ERROR == msg.getStatus()) {
                        ModelUtility.appendWithNewLine((StringBuilder)errors, (String)msg.getDescription());
                    }
                    ++i;
                }
                throw new CSTSemanticException(errors.toString(), 10103);
            }
            expression.inferDatatype();
            return expression;
        }
        catch (TranslatorException e) {
            throw new CSTSemanticException(e.getMessage(), 10103);
        }
    }

    public String getExtension() {
        return "ivml";
    }

    public ModelInfo<net.ssehub.easy.varModel.model.Project> getInfo(java.net.URI uri) {
        return VarModel.INSTANCE.availableModels().getInfo(uri);
    }
}

