/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTUtils;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;

public class AssignmentDetector
implements IConstraintTreeVisitor {
    public static final int LEVEL_UNLIMITED = -1;
    public static final int NO_DEEP_TRAVERSAL = 0;
    private boolean isAssignment;
    private int maxLevel;
    private int level;

    public void setMaxLevel(int level) {
        this.maxLevel = Math.max(-1, level);
    }

    public boolean isAssignment() {
        return this.isAssignment;
    }

    public void clear() {
        this.isAssignment = false;
        this.maxLevel = -1;
        this.level = 0;
    }

    public void visitConstantValue(ConstantValue value) {
    }

    public void visitVariable(Variable variable) {
    }

    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable((Variable)variable);
    }

    private boolean continueTraversal() {
        return !this.isAssignment && (this.maxLevel < 0 || this.level <= this.maxLevel);
    }

    public void visitParenthesis(Parenthesis parenthesis) {
        if (this.continueTraversal()) {
            ++this.level;
            parenthesis.getExpr().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitComment(Comment comment) {
    }

    public void visitOclFeatureCall(OCLFeatureCall call) {
        this.isAssignment = CSTUtils.isAssignment((ConstraintSyntaxTree)call);
        if (this.continueTraversal()) {
            ++this.level;
            if (call.getOperand() != null) {
                call.getOperand().accept((IConstraintTreeVisitor)this);
                int p = 0;
                while (!this.isAssignment && p < call.getParameterCount()) {
                    call.getParameter(p).accept((IConstraintTreeVisitor)this);
                    ++p;
                }
            }
            --this.level;
        }
    }

    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitMultiAndExpression(MultiAndExpression expression) {
        ++this.level;
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept((IConstraintTreeVisitor)this);
            ++e;
        }
        --this.level;
    }

    public void visitLet(Let let) {
        if (this.continueTraversal()) {
            ++this.level;
            let.getInExpression().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitIfThen(IfThen ifThen) {
        if (this.continueTraversal()) {
            ++this.level;
            ifThen.getIfExpr().accept((IConstraintTreeVisitor)this);
            if (!this.isAssignment) {
                ifThen.getThenExpr().accept((IConstraintTreeVisitor)this);
            }
            if (!this.isAssignment && ifThen.getElseExpr() != null) {
                ifThen.getElseExpr().accept((IConstraintTreeVisitor)this);
            }
            --this.level;
        }
    }

    public void visitContainerOperationCall(ContainerOperationCall call) {
        if (this.continueTraversal()) {
            ++this.level;
            call.getContainer().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitCompoundAccess(CompoundAccess access) {
        if (this.continueTraversal()) {
            ++this.level;
            access.getCompoundExpression().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    public void visitCompoundInitializer(CompoundInitializer initializer) {
        if (this.continueTraversal()) {
            ++this.level;
            int e = 0;
            while (!this.isAssignment && e < initializer.getExpressionCount()) {
                initializer.getExpression(e).accept((IConstraintTreeVisitor)this);
                ++e;
            }
            --this.level;
        }
    }

    public void visitContainerInitializer(ContainerInitializer initializer) {
        if (this.continueTraversal()) {
            ++this.level;
            int e = 0;
            while (!this.isAssignment && e < initializer.getExpressionCount()) {
                initializer.getExpression(e).accept((IConstraintTreeVisitor)this);
                ++e;
            }
            --this.level;
        }
    }

    public void visitSelf(Self self) {
    }

    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept((IConstraintTreeVisitor)this);
            ++e;
        }
    }
}

