/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.util.List;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.IReasonerInstance;
import net.ssehub.easy.reasoning.core.reasoner.EvaluationResult;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerMessage;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerDescriptor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.core.reasoner.ValueCreationResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class DelegatingReasonerInstance
implements IReasonerInstance {
    private IReasoner delegate;
    private Configuration config;
    private ReasonerConfiguration rConfig;
    private boolean isRunning;

    public DelegatingReasonerInstance(Configuration config, ReasonerConfiguration rConfig, IReasoner delegate) {
        this.config = config;
        this.rConfig = rConfig;
        this.delegate = delegate;
    }

    @Override
    public ReasonerDescriptor getDescriptor() {
        return this.delegate.getDescriptor();
    }

    @Override
    public ReasoningResult isConsistent(ProgressObserver observer) {
        this.isRunning = true;
        ReasoningResult result = this.delegate.isConsistent(this.config.getProject(), this.rConfig, observer);
        this.isRunning = false;
        return result;
    }

    @Override
    public ReasoningResult check(ProgressObserver observer) {
        this.isRunning = true;
        ReasoningResult result = this.delegate.check(this.config, this.rConfig, observer);
        this.isRunning = false;
        return result;
    }

    @Override
    public ReasoningResult propagate(ProgressObserver observer) {
        this.isRunning = true;
        ReasoningResult result = this.delegate.propagate(this.config, this.rConfig, observer);
        this.isRunning = false;
        return result;
    }

    @Override
    public EvaluationResult evaluate(List<Constraint> constraints, ProgressObserver observer) {
        this.isRunning = true;
        EvaluationResult result = this.delegate.evaluate(this.config, constraints, this.rConfig, observer);
        this.isRunning = false;
        return result;
    }

    @Override
    public ValueCreationResult createValue(AbstractVariable var, IDatatype type, ProgressObserver observer) {
        this.isRunning = true;
        ValueCreationResult result = this.delegate.createValue(this.config, var, type, this.rConfig, observer);
        this.isRunning = false;
        return result;
    }

    @Override
    public void notify(IReasonerMessage message) {
        this.delegate.notify(message);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public boolean stop() {
        return false;
    }

    @Override
    public Project getProject() {
        return this.config.getProject();
    }

    @Override
    public ReasonerConfiguration getReasonerConfiguration() {
        return this.rConfig;
    }
}

