/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.reasoning.core.reasoner.CommentResourceVisitor;
import net.ssehub.easy.varModel.confModel.DisplayNameProvider;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.management.CommentResource;
import net.ssehub.easy.varModel.management.ModelCommentsPersistencer;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class Message
extends net.ssehub.easy.basics.messages.Message {
    private List<ModelElement> conflictingElements;
    private List<Set<AbstractVariable>> variablesInConstraints;
    private List<Set<IDecisionVariable>> problemVariables;
    private List<ConstraintSyntaxTree> problemConstraintParts = new ArrayList<ConstraintSyntaxTree>();
    private List<Constraint> problemConstraints;
    private List<Project> conflictingElementProjects;
    private List<SuggestionType> conflictingElementSuggestions;
    private List<IDecisionVariable> constraintVariables;
    private List<Integer> errorClassification;

    public Message(String explanation, List<ModelElement> conflictingElements, Status status) {
        super(explanation, status);
        this.conflictingElements = new ArrayList<ModelElement>();
        if (conflictingElements != null) {
            this.conflictingElements.addAll(conflictingElements);
        }
    }

    public static final List<ModelElement> createList(ModelElement element) {
        ArrayList<ModelElement> result;
        if (element != null) {
            result = new ArrayList<ModelElement>();
            result.add(element);
        } else {
            result = null;
        }
        return result;
    }

    public List<ModelElement> getConflicts() {
        return this.conflictingElements;
    }

    public int getConflictsCount() {
        return this.conflictingElements.size();
    }

    private static int min(int v1, int v2, int v3) {
        return Math.min(Math.min(v1, v2), v3);
    }

    private static int min(int v1, int v2, int v3, int v4) {
        return Math.min(Math.min(v1, v2), Math.min(v3, v4));
    }

    public List<String> getConflictLabels() {
        ArrayList<String> result;
        if (this.conflictingElementSuggestions == null) {
            result = null;
        } else {
            result = new ArrayList<String>();
            int i = 0;
            int n = Message.min(this.conflictingElementSuggestions.size(), this.conflictingElements.size(), this.constraintVariables.size(), this.variablesInConstraints.size());
            while (i < n) {
                result.add((String)(switch (this.conflictingElementSuggestions.get(i)) {
                    case SuggestionType.PROBLEM_POINTS -> this.toString(this.conflictingElements.get(i), this.constraintVariables.get(i)) + " Please check: " + this.problemPointsToString(this.variablesInConstraints.get(i));
                    case SuggestionType.REASSIGNMENT -> this.toString(this.conflictingElements.get(i), null);
                    default -> "none";
                }));
                ++i;
            }
        }
        return result;
    }

    public List<String> getConflictComments() {
        ArrayList<String> result;
        if (this.conflictingElementSuggestions == null) {
            result = null;
        } else {
            result = new ArrayList<String>();
            int i = 0;
            int n = Message.min(this.conflictingElementSuggestions.size(), this.conflictingElements.size(), this.constraintVariables.size());
            while (i < n) {
                result.add(switch (this.conflictingElementSuggestions.get(i)) {
                    case SuggestionType.PROBLEM_POINTS -> this.toString(this.conflictingElements.get(i), this.constraintVariables.get(i));
                    case SuggestionType.REASSIGNMENT -> this.toString(this.conflictingElements.get(i), null);
                    default -> "none";
                });
                ++i;
            }
        }
        return result;
    }

    private String toString(Constraint constraint, IDecisionVariable namedVariable) {
        AbstractVariable decl;
        String result = "";
        if (namedVariable != null && TypeQueries.isConstraint((IDatatype)(decl = namedVariable.getDeclaration()).getType())) {
            String comment = decl.getComment();
            result = comment == null ? decl.getName() : decl.getComment();
        }
        if (Message.noResult(result) && Message.noResult(result = constraint.getComment())) {
            CommentResource cr = null;
            try {
                cr = ModelCommentsPersistencer.getComments((Project)constraint.getProject());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result = CommentResourceVisitor.visit((IModelElement)constraint, cr);
        }
        return result;
    }

    private static boolean noResult(String result) {
        return result == null || result.length() == 0;
    }

    private String toString(ModelElement elt, IDecisionVariable namedVariable) {
        String result = elt instanceof AbstractVariable ? DisplayNameProvider.getInstance().getDisplayName((AbstractVariable)elt) : (elt instanceof IDecisionVariable ? DisplayNameProvider.getInstance().getDisplayName((IDecisionVariable)elt) : (elt instanceof Constraint ? this.toString((Constraint)elt, namedVariable) : elt.getName()));
        return result + " (" + this.traceToTop(elt) + " )";
    }

    private String traceToTop(ModelElement element) {
        Object text = "";
        if (element.getParent() != null) {
            text = " -> " + element.getParent().getName();
            ModelElement mElement = (ModelElement)element.getParent();
            text = (String)text + this.traceToTop(mElement);
        }
        return text;
    }

    public void addConflictingElementSuggestions(List<SuggestionType> conflictingElementSuggestions) {
        this.conflictingElementSuggestions = new ArrayList<SuggestionType>();
        if (conflictingElementSuggestions != null) {
            this.conflictingElementSuggestions.addAll(conflictingElementSuggestions);
        }
    }

    public List<SuggestionType> getConflictSuggestionTypes() {
        return this.conflictingElementSuggestions;
    }

    public List<String> getConflictSuggestions() {
        ArrayList<String> result;
        if (this.conflictingElementSuggestions == null) {
            result = null;
        } else {
            result = new ArrayList<String>();
            int i = 0;
            int n = Math.min(this.conflictingElementSuggestions.size(), this.variablesInConstraints.size());
            while (i < n) {
                result.add((String)(switch (this.conflictingElementSuggestions.get(i)) {
                    case SuggestionType.PROBLEM_POINTS -> "Please check: " + this.problemPointsToString(this.variablesInConstraints.get(i));
                    case SuggestionType.REASSIGNMENT -> "Check for variable reassignments in the same Project scope";
                    default -> "none";
                }));
                ++i;
            }
        }
        return result;
    }

    private String problemPointsToString(Set<AbstractVariable> vars) {
        Object problemPoints = "";
        int count = 0;
        for (AbstractVariable variable : vars) {
            if (count > 0) {
                problemPoints = count == vars.size() - 1 ? (String)problemPoints + " or " : (String)problemPoints + ", ";
            }
            String displayVarName = DisplayNameProvider.getInstance().getDisplayName(variable);
            String displayParentName = DisplayNameProvider.getInstance().getParentNames(variable);
            problemPoints = displayParentName != null ? (String)problemPoints + "\"" + displayVarName + "\" in " + displayParentName : (String)problemPoints + "\"" + displayVarName + "\"";
            ++count;
        }
        return problemPoints;
    }

    public void addConflictingElementProjects(List<Project> conflictingElementProjects) {
        this.conflictingElementProjects = new ArrayList<Project>();
        if (conflictingElementProjects != null) {
            this.conflictingElementProjects.addAll(conflictingElementProjects);
        }
    }

    public List<Project> getConflictProjects() {
        return this.conflictingElementProjects;
    }

    public void addConstraintVariables(List<Set<AbstractVariable>> variables) {
        this.variablesInConstraints = new ArrayList<Set<AbstractVariable>>();
        if (this.variablesInConstraints != null) {
            this.variablesInConstraints.addAll(variables);
        }
    }

    public List<Set<AbstractVariable>> getConstraintVariables() {
        return this.variablesInConstraints;
    }

    public void addProblemVariables(List<Set<IDecisionVariable>> variables) {
        this.problemVariables = new ArrayList<Set<IDecisionVariable>>();
        if (this.problemVariables != null) {
            this.problemVariables.addAll(variables);
        }
    }

    public List<Set<IDecisionVariable>> getProblemVariables() {
        return this.problemVariables;
    }

    public void addProblemConstraintParts(List<ConstraintSyntaxTree> constraints) {
        if (constraints != null) {
            this.problemConstraintParts.addAll(constraints);
        }
    }

    public void addProblemConstraints(List<Constraint> constraints) {
        this.problemConstraints = new ArrayList<Constraint>();
        if (this.problemConstraints != null) {
            this.problemConstraints.addAll(constraints);
        }
    }

    public List<ConstraintSyntaxTree> getProblemConstraintParts() {
        return this.problemConstraintParts;
    }

    public List<Constraint> getProblemConstraints() {
        return this.problemConstraints;
    }

    public void addNamedConstraintVariables(List<IDecisionVariable> constraintVariables) {
        this.constraintVariables = new ArrayList<IDecisionVariable>();
        if (constraintVariables != null) {
            this.constraintVariables.addAll(constraintVariables);
        }
    }

    public List<IDecisionVariable> getNamedConstraintVariables() {
        return this.constraintVariables;
    }

    public void addErrorClassification(List<Integer> errorClassification) {
        this.errorClassification = new ArrayList<Integer>();
        if (errorClassification != null) {
            this.errorClassification.addAll(errorClassification);
        }
    }

    public List<Integer> getErrorClassification() {
        return this.errorClassification;
    }

    public String toString() {
        Object res = "";
        List<String> labels = this.getConflictLabels();
        List<String> comments = this.getConflictComments();
        List<Project> projects = this.getConflictProjects();
        List<String> suggestions = this.getConflictSuggestions();
        List<Set<IDecisionVariable>> vars = this.getProblemVariables();
        List<ConstraintSyntaxTree> parts = this.getProblemConstraintParts();
        List<IDecisionVariable> namedVars = this.getNamedConstraintVariables();
        List<Integer> codes = this.getErrorClassification();
        int i = 0;
        while (i < this.getConflictsCount()) {
            ModelElement conflict = this.getConflicts().get(i);
            if (i > 0) {
                res = (String)res + "\n";
            }
            if (conflict instanceof Constraint) {
                Constraint constraint = (Constraint)conflict;
                res = this.append((String)res, "Failed element (EP): " + StringProvider.toIvmlString((ConstraintSyntaxTree)constraint.getConsSyntax()));
            } else {
                res = this.append((String)res, "Failed element (EP): " + StringProvider.toIvmlString((ModelElement)conflict));
            }
            res = this.append((String)res, "Failed elements label (CT): " + labels.get(i));
            res = this.append((String)res, "Failed elements comment: " + comments.get(i));
            res = this.append((String)res, "Failed elements project: " + projects.get(i).getName());
            res = this.append((String)res, "Failed elements suggestion: " + suggestions.get(i));
            res = this.append((String)res, "Failed elements variables: " + String.valueOf(vars.get(i)));
            if (parts.get(i) != null) {
                res = this.append((String)res, "Failed elements problem constraint parts: " + StringProvider.toIvmlString((ConstraintSyntaxTree)parts.get(i)));
            }
            res = this.append((String)res, "Failed elements constraint variable: " + String.valueOf(namedVars.get(i)));
            res = this.append((String)res, "Reasoning error code: " + String.valueOf(codes.get(i)));
            ++i;
        }
        return res;
    }

    private String append(String res, String text) {
        return res + text + "\n";
    }

    public static enum SuggestionType {
        PROBLEM_POINTS,
        REASSIGNMENT,
        OTHER;

    }
}

