/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.cfg.PlatformInstantiation;
import de.iip_ecosphere.platform.configuration.easyProducer.PlatformInstantiator;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.JavaUtils;
import de.iip_ecosphere.platform.support.plugins.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class PlatformInstantiatorExecutor
implements PlatformInstantiation {
    public static final Consumer<String> SYSOUT_CONSUMER = t -> System.out.println((String)t);
    private File localRepo;
    private Consumer<String> warn;
    private Consumer<String> info;
    private Consumer<Long> executionTimeConsumer;
    private String mainCls = PlatformInstantiator.class.getName();
    private boolean inTesting = false;
    private Map<String, String> properties = new HashMap<String, String>();

    public PlatformInstantiatorExecutor(File localRepo, Consumer<String> warn, Consumer<String> info, Consumer<Long> executionTimeConsumer) {
        this.localRepo = localRepo;
        this.warn = warn;
        this.info = info;
        this.executionTimeConsumer = executionTimeConsumer;
    }

    public static void instantiate(PlatformInstantiator.InstantiationConfigurer configurer) throws ExecutionException {
        PlatformInstantiatorExecutor executor = new PlatformInstantiatorExecutor(null, SYSOUT_CONSUMER, SYSOUT_CONSUMER, null);
        executor.inTesting = configurer.inTesting();
        executor.mainCls = configurer.getMainClass();
        executor.properties = configurer.getProperties();
        executor.executeAsProcess(PlatformInstantiatorExecutor.class.getClassLoader(), null, null, null, configurer.toArgs(false));
    }

    public static String createJvmArg(String key, String value) {
        String result = "-D" + key;
        if (null != value) {
            result = result + "=" + value;
        }
        return result;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void executeAsProcess(ClassLoader loader, String resourcesDir, String tracingLevel, String mvnArgs, String ... args) throws ExecutionException {
        ArrayList<String> pArgs = new ArrayList<String>();
        pArgs.add(JavaUtils.getJavaBinaryPath((String)"java"));
        for (String key : this.properties.keySet()) {
            pArgs.add(PlatformInstantiatorExecutor.createJvmArg(key, this.properties.get(key)));
        }
        File cpFile = null;
        List<String> cp = this.createEasyClasspath(loader);
        if (null != cp) {
            String cpString = String.join((CharSequence)File.pathSeparator, cp);
            cpFile = new File(FileUtils.getTempDirectory(), "config.cp-" + Thread.currentThread().getId());
            try {
                FileUtils.write((File)cpFile, (CharSequence)("-cp " + cpString), (Charset)Charset.defaultCharset());
                pArgs.add("@" + cpFile.getAbsolutePath());
            }
            catch (IOException e) {
                pArgs.add("-cp");
                pArgs.add(cpString);
                this.info.accept("Cannot write args file. Falling back to classpath as argument. " + e.getMessage());
            }
        }
        if (null != tracingLevel) {
            pArgs.add(PlatformInstantiatorExecutor.createJvmArg("iip.easy.tracing", tracingLevel));
        }
        if (null != mvnArgs) {
            pArgs.add(PlatformInstantiatorExecutor.createJvmArg("iip.easy.mvnArgs", mvnArgs));
        }
        if (null != resourcesDir) {
            pArgs.add(PlatformInstantiatorExecutor.createJvmArg("iip.resources", resourcesDir));
        }
        try {
            this.info.accept("Calling platform instantiator as process with " + Arrays.toString(args) + ", tracing " + tracingLevel + (String)(null == resourcesDir ? "" : ", resources dir " + resourcesDir));
            long start = System.currentTimeMillis();
            pArgs.add(this.mainCls);
            Collections.addAll(pArgs, args);
            Process process = new ProcessBuilder(pArgs).start();
            StreamGobbler.attach((Process)process);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new ExecutionException("Instantiation failed with exit code: " + exitCode, null);
            }
            if (null != this.executionTimeConsumer) {
                this.executionTimeConsumer.accept(System.currentTimeMillis() - start);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
        FileUtils.deleteQuietly((File)cpFile);
    }

    public void execute(ClassLoader loader, String resourcesDir, String tracingLevel, String mvnArgs, String ... args) throws ExecutionException {
        if (null != tracingLevel) {
            System.setProperty("iip.easy.tracing", tracingLevel);
        }
        if (null != mvnArgs) {
            System.setProperty("iip.easy.mvnArgs", mvnArgs);
        }
        if (null != resourcesDir) {
            System.setProperty("iip.resources", resourcesDir);
        }
        this.info.accept("Calling platform instantiator with " + Arrays.toString(args) + ", tracing " + tracingLevel + (String)(null == resourcesDir ? "" : " and resources dir " + resourcesDir) + " and properties " + String.valueOf(this.properties));
        long start = System.currentTimeMillis();
        for (String key : this.properties.keySet()) {
            System.setProperty(key, this.properties.get(key));
        }
        PlatformInstantiator.setClassLoader(this.createEasyClassLoader(loader));
        int exitCode = PlatformInstantiator.mainImpl(args);
        if (exitCode != 0) {
            throw new ExecutionException("Instantiation failed with exit code: " + exitCode, null);
        }
        if (null != this.executionTimeConsumer) {
            this.executionTimeConsumer.accept(System.currentTimeMillis() - start);
        }
    }

    public List<String> createEasyClasspath(ClassLoader loader) {
        ArrayList<String> result = null;
        String cpFile = this.inTesting ? "config-test.classpath" : "config.classpath";
        System.out.println("Loading classpath from " + cpFile);
        if (this.inTesting) {
            System.out.println("Hint: to update the classpath, see README.MD");
        }
        boolean debug = Boolean.valueOf(System.getProperty("okto.instantiator.debug", "false"));
        InputStream cpIn = loader.getResourceAsStream(cpFile);
        if (null != cpIn) {
            if (null == this.localRepo) {
                Object tmp = System.getenv("M2_HOME");
                if (null == tmp) {
                    tmp = System.getProperty("user.home") + "/.m2/repository";
                }
                this.localRepo = new File((String)tmp);
            }
            if (debug) {
                System.out.println("Local repo: " + String.valueOf(this.localRepo));
            }
            try {
                String cpElementString = IOUtils.toString((InputStream)cpIn, (Charset)StandardCharsets.UTF_8);
                StringTokenizer cpElements = new StringTokenizer(cpElementString, ":");
                result = new ArrayList<String>();
                while (cpElements.hasMoreTokens()) {
                    Object cpElement = cpElements.nextToken();
                    int pos = ((String)cpElement).indexOf("/");
                    if (pos > 0) {
                        cpElement = String.valueOf(this.localRepo) + ((String)cpElement).substring(pos);
                    }
                    result.add((String)cpElement);
                }
                cpIn.close();
                if (debug) {
                    System.out.println("Classpath: " + String.valueOf(result));
                }
            }
            catch (IOException e) {
                this.warn.accept("Cannot load EASy-Producer classpath file from resources: " + e.getMessage());
            }
        } else {
            this.warn.accept("Cannot load classpath file from resources");
        }
        return result;
    }

    public ClassLoader createEasyClassLoader(ClassLoader parent) {
        URLClassLoader result = null;
        List<String> cp = this.createEasyClasspath(parent);
        if (null != cp) {
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String c : cp) {
                    urls.add(new File(c).toURI().toURL());
                }
                result = new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
            }
            catch (MalformedURLException e) {
                this.warn.accept("Cannot create EASy-Producer classpath: " + e.getMessage());
            }
        }
        return result;
    }
}

