/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasEnum;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasEnumLiteral;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasField;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasImports;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSmeType;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSpecSummary;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasType;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AbstractAasElement;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.ParsingUtils;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class IvmlWriter {
    private static final Pattern BASIC_IVML_NAME = Pattern.compile("^[\\w \\[\\]\\-\\Q$_\\E]+$");
    private PrintStream out = System.out;
    private String indent = "";
    private Consumer<PrintStream> closer;
    private Set<AasImports.Import> selfImports;
    private int idCounter;
    private String fileName;
    private String namePrefix;

    public IvmlWriter() {
        this.closer = p -> {};
        this.selfImports = new HashSet<AasImports.Import>();
        this.idCounter = 0;
        this.namePrefix = null;
    }

    public IvmlWriter(String fileName) throws IOException {
        this.closer = p -> {};
        this.selfImports = new HashSet<AasImports.Import>();
        this.idCounter = 0;
        this.namePrefix = null;
        this.fileName = fileName;
        if (fileName != null) {
            System.setProperty("file.encoding", "Cp1252");
            this.out = new PrintStream(new FileOutputStream(fileName));
            this.closer = p -> FileUtils.closeQuietly((Closeable)p);
        }
    }

    public IvmlWriter setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    private void increaseIndent() {
        this.indent = this.indent + "  ";
    }

    private void decreaseIndent() {
        if (this.indent.length() >= 2) {
            this.indent = this.indent.substring(2);
        }
    }

    private void println() {
        this.out.println();
    }

    private void println(String text) {
        this.out.println(this.indent + text);
    }

    private void printlnField(String fieldName, Object value, boolean comma) {
        this.printlnField(fieldName, value, comma, null);
    }

    private void printlnField(String fieldName, Object value, boolean comma, Object dflt) {
        if (null == dflt || value != dflt) {
            this.println(fieldName + " = " + String.valueOf(value) + (comma ? "," : ""));
        }
    }

    private void printlnCardinalityField(String fieldName, int value, boolean comma) {
        if (value != Integer.MIN_VALUE && value != -1) {
            this.printlnField(fieldName, value, comma);
        }
    }

    private void printlnStringField(String fieldName, String value, boolean comma) {
        if (null != value && value.length() > 0) {
            this.println(fieldName + " = \"" + this.quoteIvmlString(value) + "\"" + (comma ? "," : ""));
        }
    }

    private String quoteIvmlString(String value) {
        return value.replace("\"", "'").replace("\\", "\\\\");
    }

    private void printEnums(AasSpecSummary aasResult) {
        for (AasEnum e : aasResult.enums()) {
            if (!this.emit(e)) continue;
            this.println();
            this.println("AasEnumType " + this.validateVariableName(e.getIdShort()) + " = {");
            this.increaseIndent();
            Object name = this.validateName(e.getIdShort());
            if (this.namePrefix != null) {
                name = this.namePrefix + (String)name;
            }
            this.printlnStringField("name", (String)name, true);
            this.printlnStringField("description", e.getDescription(), true);
            this.printlnField("isOpen", e.isOpen(), true, false);
            this.printlnStringField("versionIdentifier", aasResult.getVersionIdentifier(), true);
            this.printlnStringField("semanticId", e.getSemanticId(), true);
            this.println("literals = {");
            this.increaseIndent();
            boolean hasValues = false;
            boolean requiresValues = false;
            for (AasEnumLiteral l : e.literals()) {
                hasValues |= ParsingUtils.isValue(l.getValue());
                requiresValues |= !BASIC_IVML_NAME.matcher(l.getIdShort()).matches();
            }
            for (AasEnumLiteral l : e.literals()) {
                boolean last = e.isLast(l);
                this.println("AasEnumLiteral {");
                this.increaseIndent();
                String lName = l.getIdShort().replace(",", "").replace("/", " ").replace("(", "").replace(")", "").trim();
                this.printlnStringField("name", lName, ParsingUtils.isValue(l.getIdentifier()) || ParsingUtils.isValue(l.getDescription()) || ParsingUtils.isValue(l.getValue()) || ParsingUtils.isValue(l.getValueId()));
                this.printlnStringField("identifier", l.getIdentifier(), true);
                this.printlnStringField("description", l.getDescription(), true);
                String value = l.getValue();
                if (!hasValues && requiresValues) {
                    value = l.getIdShort();
                }
                this.printlnStringField("value", value, ParsingUtils.isValue(l.getValueId()));
                this.printlnStringField("semanticId", l.getValueId(), false);
                this.decreaseIndent();
                this.println("}" + (last ? "" : ","));
            }
            this.decreaseIndent();
            this.println("}");
            this.decreaseIndent();
            this.println("};");
        }
    }

    private boolean emit(AbstractAasElement elem) {
        boolean emit = true;
        AasImports.Import imp = AasImports.getImport(elem.getSemanticId());
        emit = null != imp ? this.selfImports.contains(imp) : !AasImports.isKnownType(elem.getIdShort(), this.selfImports);
        return emit;
    }

    private void printTypes(AasSpecSummary aasResult) {
        for (AasType t : aasResult.types()) {
            String ivmlType;
            if (null == t.getSmeType()) {
                IvmlWriter.getLogger().error("Type {} has no SME type assigned. Cannot print IVML. ", (Object)t.getIdShort());
                continue;
            }
            if (!this.emit(t) || null == (ivmlType = this.getIvmlType(t))) continue;
            this.println();
            Object varName = t.getIdShort();
            if (null != this.namePrefix && AasSmeType.SUBMODEL == t.getSmeType()) {
                varName = this.namePrefix + (String)varName;
            }
            this.println(ivmlType + " " + this.validateVariableName((String)varName) + " = {");
            this.increaseIndent();
            String name = this.validateName(t.getDisplayName());
            if (null != this.namePrefix) {
                this.printlnStringField("name", this.namePrefix + name, true);
                this.printlnStringField("idShort", name, true);
            } else {
                this.printlnStringField("name", name, true);
            }
            this.printlnStringField("semanticId", t.getSemanticId(), ParsingUtils.isValue(t.getDescription()) || ParsingUtils.isValue(aasResult.getVersionIdentifier()) || t.hasFields());
            this.printlnField("multiSemanticIds", t.hasMultiSemanticIds(), ParsingUtils.isValue(t.getDescription()) || ParsingUtils.isValue(aasResult.getVersionIdentifier()) || t.hasFields(), false);
            this.printlnStringField("description", t.getDescription(), ParsingUtils.isValue(aasResult.getVersionIdentifier()) || t.hasFields());
            this.printlnStringField("versionIdentifier", aasResult.getVersionIdentifier(), t.hasFields());
            this.printlnField("isGeneric", t.isGeneric(), true, false);
            this.printlnField("allowDuplicates", t.isAllowDuplicates(), true, false);
            this.printlnField("ordered", t.isOrdered(), true, false);
            this.printlnField("fixedName", t.isFixedIdShort(), t.hasFields(), false);
            if (t.hasFields()) {
                this.println("fields = {");
                this.increaseIndent();
                for (AasField f : t.fields()) {
                    this.printField(f, t);
                }
                this.decreaseIndent();
                this.println("}");
            }
            this.decreaseIndent();
            this.println("};");
        }
    }

    private String getIvmlType(AasType type) {
        return switch (type.getSmeType()) {
            case AasSmeType.SUBMODEL -> "AasSubmodelType";
            case AasSmeType.SUBMODEL_LIST -> "AasSubmodelListType";
            case AasSmeType.SUBMODEL_ELEMENT_LIST -> "AasSubmodelElementListType";
            case AasSmeType.SUBMODEL_ELEMENT_COLLECTION -> "AasSubmodelElementCollectionType";
            case AasSmeType.ENTITY -> "AasEntityType";
            case AasSmeType.FILE -> "AasFileResourceType";
            default -> null;
        };
    }

    private String getIvmlType(AasField field) {
        Object result = field.getIvmlValueType(false);
        if (field.isMultiValued() || field.getUpperCardinality() > 1 || field.getLowerCardinality() >= 0 && field.getUpperCardinality() < 0) {
            String tmp = null;
            switch (ParsingUtils.stripRefBy((String)result)) {
                case "IntegerType": {
                    tmp = "IntegerListType";
                    break;
                }
                case "BooleanType": {
                    tmp = "BooleanListType";
                    break;
                }
                case "DoubleType": {
                    tmp = "DoubleListType";
                    break;
                }
                case "FloatType": {
                    tmp = "FloatListType";
                    break;
                }
                case "StringType": {
                    tmp = "StringListType";
                    break;
                }
                default: {
                    tmp = null;
                }
            }
            if (null != tmp) {
                result = "refBy(" + tmp + ")";
            }
        }
        return result;
    }

    private void printField(AasField field, AasType type) {
        boolean last = type.isLast(field);
        this.println("AasField {");
        this.increaseIndent();
        this.printlnStringField("name", this.validateName(field.getIdShort()), true);
        if (field.getDisplayName() != null && !field.getIdShort().equals(field.getDisplayName())) {
            this.printlnStringField("displayName", field.getDisplayName(), true);
        }
        this.printlnStringField("semanticId", field.getSemanticId(), true);
        this.printlnField("multiSemanticIds", field.hasMultiSemanticIds(), true, false);
        this.printlnField("isGeneric", field.isGeneric(), true, false);
        this.printlnField("counting", field.isMultiValued(), true, false);
        boolean afterMaxInstances = ParsingUtils.isValue(field.getDescription()) || ParsingUtils.isValue(field.getExampleValues());
        boolean afterMinInstances = field.getUpperCardinality() >= 0 || afterMaxInstances;
        this.printlnField("type", this.getIvmlType(field), ParsingUtils.isValue(field.getAspect()) || field.getLowerCardinality() >= 0 || afterMinInstances, null);
        this.printlnStringField("aspect", field.getAspect(), true);
        this.printlnCardinalityField("minimumInstances", field.getLowerCardinality(), afterMinInstances);
        String[] examples = field.getExampleValues();
        this.printlnCardinalityField("maximumInstances", field.getUpperCardinality(), afterMaxInstances);
        if (null != examples) {
            Object tmp = "{";
            for (int e = 0; e < examples.length; ++e) {
                if (e > 0) {
                    tmp = (String)tmp + ",";
                }
                tmp = (String)tmp + "\"" + this.quoteIvmlString(examples[e]) + "\"";
            }
            tmp = (String)tmp + "}";
            this.printlnField("examples", tmp, ParsingUtils.isValue(field.getDescription()));
        }
        this.printlnStringField("description", field.getDescription(), false);
        this.decreaseIndent();
        this.println("}" + (last ? "" : ","));
    }

    private void printImports(AasSpecSummary aasResult, String projectName) {
        HashSet<AasImports.Import> imports = new HashSet<AasImports.Import>();
        for (AasType type : aasResult.types()) {
            this.addImport(AasImports.getImport(type.getSemanticId()), imports, projectName);
            for (AasField field : type.fields()) {
                this.addImport(AasImports.getImport(field.getSemanticId()), imports, projectName);
            }
        }
        for (AasImports.Import imp : AasImports.sort(new ArrayList<AasImports.Import>(imports))) {
            Version ver = imp.getVersion();
            Object verPart = "";
            if (null != ver) {
                verPart = " with (" + imp.getProjectName() + ".version == v" + ver.toString() + ")";
            }
            this.println("import " + imp.getProjectName() + (String)verPart + ";");
        }
    }

    private void addImport(AasImports.Import imp, Set<AasImports.Import> imports, String projectName) {
        if (null != imp) {
            if (imp.getProjectName().equals(projectName)) {
                this.selfImports.add(imp);
            } else {
                imports.add(imp);
            }
        }
    }

    public void toIvml(AasSpecSummary aasResult) {
        String projectName = this.getProjectName(aasResult);
        this.println("project " + projectName + " {");
        this.increaseIndent();
        if (aasResult.getVersion() != null) {
            this.println();
            this.println("version v" + aasResult.getVersion().toString() + ";");
        }
        this.println();
        this.println("import AASDataTypes;");
        this.printImports(aasResult, projectName);
        this.println();
        this.println("annotate BindingTime bindingTime = BindingTime::compile to .;");
        this.printEnums(aasResult);
        this.printTypes(aasResult);
        this.println();
        this.println("freeze {");
        this.increaseIndent();
        this.println(".;");
        this.decreaseIndent();
        this.println("} but (f|f.bindingTime >= BindingTime.runtimeMon);");
        this.decreaseIndent();
        this.println("}");
        this.closer.accept(this.out);
    }

    public String getProjectName(AasSpecSummary aasResult) {
        Object projectName = aasResult.getProjectName();
        if (null == projectName) {
            Optional<AasType> main = aasResult.getMainSubmodel();
            if (main.isPresent()) {
                Object specNumber = aasResult.getSpecNumber();
                if (!((String)specNumber).startsWith("0")) {
                    specNumber = "0" + (String)specNumber;
                }
                projectName = "IDTA_" + (String)specNumber + "_" + main.get().getIdShort();
            } else {
                projectName = "Unknown";
            }
        }
        return projectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toIvmlText(AasSpecSummary aasResult) throws IOException {
        if (this.fileName != null) {
            Object textFilename = this.fileName;
            int pos = this.fileName.lastIndexOf(".");
            if (pos > 0) {
                textFilename = this.fileName.substring(0, pos) + ".text";
            }
            PrintStream outTmp = this.out;
            String projectName = this.getProjectName(aasResult);
            try (FileOutputStream fos = new FileOutputStream((String)textFilename);){
                this.out = new PrintStream(fos);
                for (AasType t : aasResult.types()) {
                    String ivmlType;
                    if (t.getSmeType() == null || !this.emit(t) || null == (ivmlType = this.getIvmlType(t))) continue;
                    Object desc = t.getDescription();
                    if (!ParsingUtils.isValue((String)desc)) {
                        desc = "Declaration for AAS type " + t.getIdShort();
                    }
                    this.println(projectName + "::" + this.validateVariableName(t.getIdShort()) + " = " + (String)desc);
                }
            }
            finally {
                this.out = outTmp;
            }
        }
    }

    private String validateName(String idShort) {
        String result = idShort;
        if (this.isNoIdShort(idShort)) {
            result = "<NoIdShort>";
        }
        return result;
    }

    private String validateVariableName(String idShort) {
        Object result = idShort;
        if (this.isNoIdShort(idShort)) {
            result = "NoIdShort_" + this.idCounter++;
        }
        result = ((String)result).replace(" ", "_");
        return result;
    }

    private boolean isNoIdShort(String idShort) {
        boolean result = false;
        if (null != idShort) {
            String tmp = ParsingUtils.removeWhitespace(idShort).toLowerCase();
            result = tmp.equals("<noidshort>") || tmp.equals("<no_idshort>");
        }
        return result;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IvmlWriter.class);
    }
}

