/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

enum ParsingEnumKind {
    ENUM("enumeration: "),
    ENUM_ENTRIES("enumeration entries: "),
    VALUE_LIST2("Value List:", "ValueList:"),
    VALUE_LIST("Value List", "Value List\\s+\\Q(\\E[^\\Q)\\E]+\\Q)\\E:"),
    IRDIS("\\Q[\\EIRDIs for values\\Q]\\E:");

    private Pattern[] marker;

    private ParsingEnumKind(String ... marker) {
        this.marker = new Pattern[marker.length];
        for (int i = 0; i < marker.length; ++i) {
            this.marker[i] = Pattern.compile("^(?<before>.*)(?<pattern>" + marker[i] + ")(?<after>.*)$", 40);
        }
    }

    public String[] getMatch(String text, boolean atBeginning) {
        String[] result = null;
        for (Pattern m : this.marker) {
            Matcher matcher = m.matcher(text);
            if (!matcher.matches()) continue;
            int patternStart = matcher.start("pattern");
            if ((!atBeginning || patternStart < 0) && (atBeginning || patternStart <= 0)) continue;
            result = new String[]{matcher.group("before").trim(), matcher.group("after")};
            break;
        }
        return result;
    }
}

