/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasEnum;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasEnumLiteral;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasField;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasOperation;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSmeType;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSpecSummary;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasType;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.ParsingEnumKind;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.ParsingUtils;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.SemanticIdRecognizer;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RowProcessor {
    private static final boolean CFG_REMOVE_NOTES = true;
    private static Pattern titlePattern = Pattern.compile("(IDTA\\W+\\d+-\\d+-\\d+)\\W+(.*)");
    private static Pattern langStringEnd = Pattern.compile(".*@[a-z]+$");
    private static Pattern seeSection = Pattern.compile("See [Ss]ection \\d+(\\.\\d+)*(.*)");
    private static Pattern extensionDesc = Pattern.compile(".* SMC (.*) in .* with (.*) elements.*");
    private List<AasType> aasTypes = new ArrayList<AasType>();
    private List<AasEnum> aasEnums = new ArrayList<AasEnum>();
    private ParsingUtils.AasEnumResultHandler enumsHandler = new ParsingUtils.AasEnumResultHandler(this.aasEnums, e -> this.enumAdded((AasEnum)e));
    private List<AasType> current = new ArrayList<AasType>();
    private String[] rawData = new String[4];
    private String[] lastRawData = new String[4];
    private int maxRawIndex = -1;
    private int column = 0;
    private int lastHeader1Row = -1;
    private int lastHeader2Row = -1;
    private int row = 0;
    private Version version;
    private String versionIdentifier;
    private String versionedName;
    private String projectName;
    private String specNumber = "0000";
    private AasField lastField;
    private List<AasEnum> lastEnum = new ArrayList<AasEnum>();
    private String lastSemanticIdRaw;
    private Map<String, String> deferredTypes = new HashMap<String, String>();
    private List<AasField> genericFields = new ArrayList<AasField>();
    private int genericTypeCount = 0;
    private boolean currentTypeIsAspect;
    private boolean currentMultiSemIdProcessed;
    private int lastEnum1Row = -1;
    private int lastEnum2Row = -1;

    RowProcessor() {
    }

    void startRow() {
        this.column = 0;
        for (int i = 0; i < this.rawData.length; ++i) {
            this.rawData[i] = null;
        }
    }

    void addDataToRow(String data) {
        String idtaMarker = "IDTA";
        if (null == this.versionedName && null != data && data.startsWith("IDTA")) {
            String dta;
            this.versionedName = dta = ParsingUtils.removeLinebreaks(data);
            Matcher matcher = titlePattern.matcher(dta);
            if (matcher.matches()) {
                this.versionIdentifier = matcher.group(1);
                String tmp = matcher.group(2).trim();
                String marker = "Submodel for ";
                if (tmp.startsWith("Submodel for ")) {
                    tmp = tmp.substring("Submodel for ".length()).trim();
                }
                tmp = RowProcessor.stripTitleDate(tmp);
                String vTmp = this.versionIdentifier.substring("IDTA".length()).trim().replace("-", ".");
                int firstDotPos = vTmp.indexOf(".");
                if (firstDotPos > 3 && firstDotPos + 1 < vTmp.length()) {
                    this.specNumber = vTmp.substring(0, firstDotPos);
                    vTmp = vTmp.substring(firstDotPos + 1);
                }
                try {
                    this.version = new Version(vTmp);
                    this.projectName = ParsingUtils.toIdentifier("IDTA " + tmp);
                }
                catch (IllegalArgumentException e) {
                    this.projectName = ParsingUtils.toIdentifier(this.versionIdentifier + " " + tmp);
                    RowProcessor.getLogger().warn("Cannot turn potential version string into version: {}", (Object)vTmp);
                }
            }
        }
        if (data != null && this.column < this.rawData.length) {
            this.rawData[this.column] = data;
            this.maxRawIndex = this.column;
        }
        ++this.column;
    }

    private void enumAdded(AasEnum en) {
        if (ParsingEnumKind.VALUE_LIST == en.getParsingEnumKind()) {
            this.lastEnum.add(en);
        }
    }

    private static String stripTitleDate(String value) {
        String result = value;
        int pos = value.lastIndexOf(32);
        if (pos > 0) {
            try {
                int monthPos;
                int year = Integer.parseInt(value.substring(pos).trim());
                if (year > 2000 && (monthPos = value.lastIndexOf(32, pos - 1)) > 0) {
                    pos = monthPos;
                }
                result = value.substring(0, pos).trim();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private void setOnCurrent(Consumer<AasType> setter, String field) {
        if (this.current != null) {
            for (AasType t : this.current) {
                setter.accept(t);
            }
        } else {
            RowProcessor.getLogger().warn("No current AasData for: {}", (Object)field);
        }
    }

    private boolean hasRawData(int untilIndex) {
        boolean hasRawData = this.maxRawIndex >= 0;
        for (int i = 0; i < Math.min(untilIndex, this.rawData.length); ++i) {
            hasRawData &= this.rawData[i] != null;
        }
        return hasRawData;
    }

    void endRow() {
        if (this.maxRawIndex == 0 && this.hasRawData(0)) {
            if (this.rawData[0].startsWith("<<")) {
                this.endSection();
            }
            if (this.rawData[0].startsWith("Table") || this.rawData[0].startsWith("Figure") || this.rawData[0].startsWith("2.8 Display names") || this.rawData[0].startsWith("2.4 Example")) {
                this.endSection();
                if (this.rawData[0].contains(" ValueList ")) {
                    this.lastEnum1Row = 0;
                }
            }
        } else if (this.maxRawIndex == 1) {
            if (!this.lastEnum.isEmpty() && this.hasRawData(1)) {
                if (this.lastEnum1Row < 0) {
                    String idShort = this.rawData[0];
                    String identifier = RowProcessor.getEnumLiteralIdentifier(idShort);
                    this.addLastEnumLiteral(new AasEnumLiteral(idShort, this.rawData[1], null, identifier));
                }
            } else if (this.hasRawData(1)) {
                this.lastEnum.clear();
                this.processTwoColumns();
            } else if (this.hasRawData(0)) {
                this.postProcessFourColumns();
            }
        } else if (this.maxRawIndex == 2 || this.maxRawIndex == 3) {
            if (this.maxRawIndex == 2 && this.hasRawData(3)) {
                if (this.lastEnum1Row > 0 && this.lastEnum2Row > 0 && this.current.size() > 0) {
                    for (AasType t : this.current) {
                        this.enumsHandler.add(new AasEnum(t, ParsingEnumKind.VALUE_LIST, id -> id + "ValueList"));
                    }
                    this.current.clear();
                }
                if (this.lastEnum1Row == 0 && this.rawData[0].equals("-") && this.rawData[1].equals("-") && this.rawData[2].startsWith("semanticId =")) {
                    this.lastEnum1Row = this.row;
                }
                if (this.rawData[0].equals("Preferred Name") && this.rawData[1].startsWith("Description") && this.rawData[2].startsWith("Dictionary")) {
                    this.lastEnum2Row = this.row;
                }
            }
            if (!this.lastEnum.isEmpty() && this.maxRawIndex == 2 && this.rawData[0] != null && this.hasRawData(3)) {
                String valueId = this.rawData[0];
                String idShort = this.rawData[1].replace("\u2013", "-");
                String semanticId = this.rawData[2];
                String description = null;
                if (this.lastEnum2Row > 0) {
                    if (null != semanticId) {
                        semanticId = SemanticIdRecognizer.trySafeSemanticIdWithDictionaryFrom((String)semanticId, null, (boolean)true, (boolean)false);
                    }
                    idShort = this.rawData[0];
                    description = this.rawData[1];
                    if (semanticId.contains("n/a")) {
                        semanticId = null;
                    }
                }
                String identifier = RowProcessor.getEnumLiteralIdentifier(idShort);
                AasEnumLiteral lit = new AasEnumLiteral(idShort, semanticId, description, identifier);
                lit.setValue(valueId);
                this.addLastEnumLiteral(lit);
            } else if (this.maxRawIndex == 2 && null == this.rawData[0] && this.lastField != null) {
                this.postProcessFourColumns();
            } else if (this.hasRawData(2) || this.hasRawData(3)) {
                this.lastEnum.clear();
                this.processFourColumns();
            }
        }
        this.maxRawIndex = -1;
        ++this.row;
        System.arraycopy(this.rawData, 0, this.lastRawData, 0, this.rawData.length);
    }

    private void addLastEnumLiteral(AasEnumLiteral literal) {
        for (AasEnum e : this.lastEnum) {
            e.addLiteral(literal);
        }
    }

    private static String getEnumLiteralIdentifier(String idShort) {
        String identifier = null;
        int pos = idShort.indexOf("-");
        if (pos > 0) {
            int splitPos = idShort.indexOf(" - ");
            identifier = splitPos > 0 ? idShort.substring(0, splitPos).trim() : idShort;
            identifier = identifier.replace("-", "_");
        }
        return identifier;
    }

    void endSection() {
        this.lastHeader1Row = -1;
        this.lastHeader2Row = -1;
        this.lastField = null;
        this.lastEnum.clear();
        this.lastSemanticIdRaw = null;
        this.currentTypeIsAspect = false;
        this.currentMultiSemIdProcessed = false;
        this.lastEnum1Row = -1;
        this.lastEnum2Row = -1;
    }

    private void processTwoColumns() {
        String header = this.rawData[0];
        String headerNoWhitespace = ParsingUtils.removeWhitespace(header);
        String value = this.rawData[1];
        if (header.endsWith(":")) {
            header = header.substring(0, header.length() - 1);
        }
        if (header.equals("idShort")) {
            String idShort = null;
            boolean stateIdShort = false;
            boolean isMultiValued = false;
            String[] tmp = ParsingUtils.toLines(value);
            if (tmp.length == 1) {
                idShort = tmp[0];
            } else if (tmp.length == 2) {
                idShort = tmp[0];
                stateIdShort = ParsingUtils.hasFixedIdShort(tmp[1]);
            } else {
                RowProcessor.getLogger().warn("idShort field has more than two lines: {}", (Object)value);
            }
            if (null != idShort) {
                if (idShort.endsWith("{00}")) {
                    idShort = idShort.substring(0, idShort.length() - 4);
                    isMultiValued = true;
                } else if (idShort.startsWith("{") && idShort.endsWith("#00}")) {
                    idShort = idShort.substring(1, idShort.length() - 4).trim();
                    isMultiValued = true;
                }
                RowProcessor.getLogger().info("Processing type {}", (Object)idShort);
                ArrayList<AasType> types = new ArrayList<AasType>();
                String[] ids = null;
                this.currentTypeIsAspect = false;
                if (idShort.startsWith("{") && idShort.contains(" = ")) {
                    int eqPos = idShort.indexOf(" = ");
                    ids = this.pruneIds(idShort.substring(eqPos + 3).split(" | "));
                    this.currentTypeIsAspect = this.containsPlainType(this.aasTypes, ids) || this.containsPlainType(this.current, ids);
                } else {
                    ids = RowProcessor.toIdsBySeparator(idShort);
                }
                this.currentMultiSemIdProcessed = ids.length > 1;
                for (String id : ids) {
                    AasType t = new AasType(id, stateIdShort, isMultiValued);
                    t.setAspect(this.currentTypeIsAspect);
                    types.add(t);
                    if (!ParsingUtils.isGenericIdShort(id)) continue;
                    t.setGeneric(true);
                    Object dispName = t.getIdShort();
                    ++this.genericTypeCount;
                    dispName = ((String)dispName).startsWith("{") && ((String)dispName).endsWith("}") ? ((String)dispName).substring(1, ((String)dispName).length() - 1) + "_" + this.genericTypeCount : (String)dispName + "_" + this.genericTypeCount;
                    t.setDisplayName((String)dispName);
                    t.setIdShort("Generic_" + ParsingUtils.toIdentifier(id) + "_" + this.genericTypeCount);
                    if (this.genericFields.size() <= 0) continue;
                    AasField field = this.genericFields.remove(0);
                    field.setValueType(t.getIdShort());
                    RowProcessor.getLogger().warn("Replaced generic field/type name with '{}'. Please review.", (Object)t.getIdShort());
                }
                this.storeAsCurrent(types);
            }
        } else if (header.equals("Class")) {
            AasSmeType smeType = AasSmeType.toType(value);
            this.setOnCurrent(a -> a.setSmeType(smeType), "Class");
        } else if (header.equals("semanticId")) {
            Map<String, String> semIds;
            if (this.current.size() > 1) {
                String[] ids = value.split(" or ");
                int idPos = 0;
                for (int curPos = 0; curPos < this.current.size(); ++curPos) {
                    AasType cur = this.current.get(curPos);
                    RowProcessor.setSemanticId(s -> cur.setSemanticId((String)s), ids[idPos], false);
                    if (idPos >= ids.length - 1) continue;
                    ++idPos;
                }
            } else {
                RowProcessor.setSemanticId(s -> this.setOnCurrent(a -> a.setSemanticId((String)s), "semanticId"), value, true);
            }
            this.lastSemanticIdRaw = value;
            if (this.currentTypeIsAspect && null != (semIds = this.parseMappedSemanticIds(value))) {
                this.setOnCurrent(a -> a.setMappedSemanticIds(semIds), "mappedSemanticIds");
            }
        } else if (header.equals("isCaseOf")) {
            RowProcessor.setSemanticId(s -> this.setOnCurrent(a -> a.setIsCaseOf((String)s), "isCaseOf"), value, false);
        } else if (header.equals("AllowDuplicates") || headerNoWhitespace.equals("AllowDuplicates")) {
            this.setOnCurrent(a -> a.setAllowDuplicates(Boolean.valueOf(value)), "AllowDuplicates");
        } else if (header.equals("Parent")) {
            String parent = value;
            if (null != parent) {
                if (parent.startsWith("Submodel") || parent.startsWith("SMC")) {
                    int pos = parent.indexOf("\"");
                    int lastPos = -1;
                    if (pos > 0) {
                        lastPos = parent.lastIndexOf("\"");
                    } else {
                        pos = parent.indexOf("\u00e2\u20ac\u0153");
                        lastPos = parent.lastIndexOf("\u00e2\u20ac?");
                    }
                    if (pos > 0 && pos < lastPos) {
                        parent = parent.substring(pos + 1, lastPos);
                    }
                } else if (value.startsWith("Asset Admin") || value.equals("AAS")) {
                    parent = "*AAS*";
                }
            }
            String parentValue = parent;
            RowProcessor.getLogger().info("Parent: {}", (Object)parentValue);
            this.setOnCurrent(a -> a.setParent(parentValue), "Parent");
        } else if (header.equals("Explanation")) {
            this.setOnCurrent(a -> a.setEntityType(AasType.EntityType.fromText(value)), "EntityType");
            String desc = ParsingUtils.filterLanguage(ParsingUtils.removeLinebreaks(value));
            this.setOnCurrent(a -> a.setDescription(desc), "Description");
            Object tmp = desc;
            if (null != this.lastSemanticIdRaw) {
                tmp = (String)tmp + " " + this.lastSemanticIdRaw;
            }
            String multiSemanticIdValue = tmp;
            this.setOnCurrent(a -> a.setMultiSemanticIds(!this.currentMultiSemIdProcessed && ParsingUtils.countSemanticIdMarker(multiSemanticIdValue) > 1), "MultiSemanticIds");
        } else if (header.equals("Kind")) {
            RowProcessor.getLogger().info("Kind: {}", (Object)value);
        } else if (header.equals("Version")) {
            RowProcessor.getLogger().info("Version: {}", (Object)value);
        } else if (header.equals("Revision")) {
            RowProcessor.getLogger().info("Revision: {}", (Object)value);
        } else {
            RowProcessor.getLogger().warn("Unknown 2 column header: {}", (Object)header);
        }
    }

    private static String[] toIdsBySeparator(String idShort) {
        int pos2;
        String[] ids = null;
        int pos = idShort.indexOf("(");
        if (pos > 0 && (pos2 = idShort.indexOf(")")) > pos) {
            Object tmpIdShort = idShort.substring(0, pos) + "/ " + idShort.substring(pos + 1, pos2);
            tmpIdShort = ((String)tmpIdShort).replaceAll("\\s*/\\s*", "/");
            ids = ((String)tmpIdShort).split("/");
        }
        if (null == ids) {
            ids = idShort.split(" or ");
        }
        return ids;
    }

    private Map<String, String> parseMappedSemanticIds(String value) {
        int endPos;
        HashMap<String, String> result = null;
        do {
            if ((endPos = value.indexOf(")")) <= 0) continue;
            String sub = value.substring(0, endPos + 1);
            value = value.substring(endPos + 1);
            int startPos = sub.lastIndexOf("(");
            String condition = sub.substring(startPos);
            sub = sub.substring(0, startPos);
            AtomicReference<Object> semanticId = new AtomicReference<Object>(null);
            RowProcessor.setSemanticId(s -> semanticId.set(s), sub, false);
            String onlyForMarker = "(only for ";
            if (condition.startsWith("(only for ")) {
                condition = condition.substring("(only for ".length(), condition.length() - 1).trim();
            } else {
                RowProcessor.getLogger().warn("Unconsidered condition for aspect type semantic Id: {}. Ignoring.", (Object)condition);
                condition = null;
            }
            if (null == semanticId.get() || null == condition) continue;
            if (null == result) {
                result = new HashMap<String, String>();
            }
            result.put(condition, semanticId.get());
        } while (endPos > 0);
        return result;
    }

    private String[] pruneIds(String[] ids) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].trim().equals("|")) continue;
            tmp.add(ids[i]);
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    private boolean containsPlainType(List<AasType> types, String[] ids) {
        return types.stream().anyMatch(t -> ParsingUtils.contains(ids, t.getIdShort()) && !t.isAspect());
    }

    private static String preprocessSemanticIdSpec(String value) {
        int pos;
        if (((String)value).startsWith("[[")) {
            value = ((String)value).substring(1);
        }
        if (((String)value).toUpperCase().startsWith("[IRDI PATH") && (pos = ((String)value).indexOf("/")) > 0) {
            value = "[IRDI]" + ((String)value).substring(pos + 1);
        }
        return value;
    }

    private static boolean isSemanticIdSpec(String value, boolean followedBySpace) {
        boolean isSemanticId;
        boolean bl = isSemanticId = (value = RowProcessor.preprocessSemanticIdSpec(value)).startsWith("[IRI]") || value.startsWith("[IRDI]");
        if (isSemanticId && followedBySpace) {
            int pos = value.indexOf("]");
            isSemanticId = pos + 1 < value.length() && Character.isWhitespace(value.charAt(pos + 1));
        }
        return isSemanticId;
    }

    private static void setSemanticId(Consumer<String> setter, String value, boolean considerFallback) {
        int endPos;
        int startPos = (value = RowProcessor.preprocessSemanticIdSpec(value)).indexOf("[");
        if (startPos < (endPos = value.indexOf("]"))) {
            String semanticId;
            String type = value.substring(startPos + 1, endPos);
            Object tmp = value.substring(endPos + 1).trim();
            if ("IRDI".equals(type) && ((String)tmp).startsWith("173")) {
                tmp = "0" + (String)tmp;
            }
            if (null != (semanticId = SemanticIdRecognizer.getSemanticIdFrom((String)tmp, (boolean)false))) {
                if ("IRI".equals(type) && semanticId.length() > 0) {
                    setter.accept(IdentifierType.compose((String)"iri:", (String)semanticId));
                } else if ("IRDI".equals(type) && semanticId.length() > 0) {
                    setter.accept(IdentifierType.compose((String)"irdi:", (String)semanticId));
                } else {
                    RowProcessor.getLogger().warn("semanticId field has unexpected structure: {}", (Object)value);
                }
            }
        } else {
            String semanticId = null;
            if (considerFallback && null != (semanticId = SemanticIdRecognizer.getSemanticIdFrom((String)value, (boolean)true))) {
                setter.accept(semanticId);
            }
            if (null == semanticId) {
                RowProcessor.getLogger().warn("semanticId field has unexpected structure: {}", (Object)value);
            }
        }
    }

    private void processFourColumns() {
        boolean process = true;
        if ("[SME type]".equals(this.rawData[0])) {
            boolean ok = "semanticId = [idType]value".equals(this.rawData[1]);
            ok &= "[valueType]".equals(this.rawData[2]);
            if (ok &= "card.".equals(this.rawData[3])) {
                process = false;
                this.lastHeader1Row = this.row;
            } else {
                RowProcessor.getLogger().warn("Unknown line 1 header format: {}", (Object)Arrays.toString(this.rawData));
            }
        } else if (this.rawData[0].equals("idShort")) {
            boolean ok = "Description@en".equals(this.rawData[1]);
            if (ok &= "example".equalsIgnoreCase(this.rawData[2]) || "example".equalsIgnoreCase(this.rawData[3])) {
                this.lastHeader2Row = this.row;
                process = false;
            } else {
                RowProcessor.getLogger().warn("Unknown line 2 header format: {}", (Object)Arrays.toString(this.rawData));
            }
        }
        if (process) {
            if (this.lastHeader1Row >= 0 && this.lastHeader2Row >= 0) {
                if (!"class name of contained elements".equalsIgnoreCase(this.rawData[0])) {
                    this.processFourColumnsAsField();
                }
            } else if (this.lastHeader1Row >= 0 || this.lastHeader2Row >= 0) {
                RowProcessor.getLogger().warn("Missing headers: {}, {}", (Object)this.lastHeader1Row, (Object)this.lastHeader2Row);
            }
        }
    }

    private void postProcessFourColumns() {
        if (this.lastField != null) {
            String type;
            if (this.lastRawData[2] != null && (this.lastField.getValueType() == null || "".equals(this.lastField.getValueType())) && null != AasField.mapPropertyType(type = ParsingUtils.fixTypeName(this.lastRawData[2]), null)) {
                this.lastField.setValueType(type);
            }
            RowProcessor.setSemanticId(s -> this.lastField.setSemanticId((String)s), ParsingUtils.removeLinebreaks(this.lastRawData[1]), false);
            if (this.rawData[1] != null && this.rawData[2] != null) {
                this.setFieldDescription(this.rawData[1], this.lastField);
                this.setExampleValues(this.rawData[2], null, this.lastField);
            } else if (this.rawData[1] != null) {
                this.setFieldDescription(this.rawData[1], this.lastField);
            } else {
                RowProcessor.getLogger().warn("Post processing 4 columns, unconsidered format: {}", (Object)Arrays.toString(this.rawData));
            }
        }
    }

    private void processFourColumnsAsField() {
        AasField field = new AasField();
        String[] furtherIdShort = this.processSmeTypeIdShort(this.rawData[0], field);
        if (ParsingUtils.isGenericIdShort(field.getIdShort())) {
            field.setGeneric(true);
            this.genericFields.add(field);
        }
        this.processValueTypeExample(this.rawData[2], field);
        this.processSemanticIdDescription(this.rawData[1], field);
        this.processFieldCardinality(this.rawData[3], field);
        this.setOnCurrent(a -> a.addField(field), "fields");
        this.lastField = field;
        if (furtherIdShort != null) {
            for (String id : furtherIdShort) {
                this.deferredTypes.put(id, field.getIdShort());
                AasField furtherField = new AasField(field);
                furtherField.setIdShort(id);
                if (AasSmeType.SUBMODEL_ELEMENT_COLLECTION == furtherField.getSmeType() || AasSmeType.SUBMODEL_ELEMENT_LIST == furtherField.getSmeType()) {
                    furtherField.setValueType(id);
                }
                this.setOnCurrent(a -> a.addField(furtherField), "fields");
            }
        }
    }

    private String[] processSmeTypeIdShort(String data, AasField field) {
        String[] result = null;
        String[] ids = data.replace("\nor ", " or ").split(" or ");
        if (ids.length > 1) {
            result = Arrays.copyOfRange(ids, 1, ids.length);
            for (int r = 0; r < result.length; ++r) {
                result[r] = ParsingUtils.removeWhitespace(result[r]).trim();
            }
            data = ids[0];
        }
        String[] tmp = ParsingUtils.toLines(data);
        String rawType = null;
        String rawId = null;
        if (tmp.length == 2 && tmp[1].endsWith("}")) {
            tmp = new String[]{tmp[0] + tmp[1]};
        }
        if (tmp.length == 1) {
            int pos = tmp[0].indexOf("]");
            if (pos > 0) {
                rawType = tmp[0].substring(0, pos + 1);
                rawId = tmp[0].substring(pos + 1);
            } else {
                rawType = "property";
                rawId = tmp[0];
            }
        } else if (tmp.length == 2) {
            rawType = tmp[0];
            rawId = tmp[1];
        } else if (tmp.length > 2) {
            rawType = tmp[0];
            int nextNonEmptyPos = 2;
            while (tmp[nextNonEmptyPos].trim().length() == 0) {
                ++nextNonEmptyPos;
            }
            rawId = !tmp[nextNonEmptyPos].trim().startsWith("Example") ? String.join((CharSequence)" ", Arrays.copyOfRange(tmp, 1, tmp.length)) : tmp[1];
        }
        if (rawType != null && rawId != null) {
            AasSmeType smeType = AasSmeType.toType(ParsingUtils.removeBrackets(rawType));
            field.setSmeType(smeType);
            String idShort = ParsingUtils.removeWhitespace(rawId);
            boolean isMultiValued = false;
            if (idShort.endsWith("{00}")) {
                idShort = idShort.substring(0, idShort.length() - 4);
                isMultiValued = true;
            }
            RowProcessor.getLogger().info("Processing field {}/{}", (Object)idShort, (Object)smeType);
            field.setIdShort(idShort, isMultiValued);
            if (AasSmeType.SUBMODEL_ELEMENT_COLLECTION == field.getSmeType() || AasSmeType.SUBMODEL_ELEMENT_LIST == field.getSmeType() || AasSmeType.ENTITY == field.getSmeType()) {
                field.setValueType(field.getIdShort());
            }
        } else {
            RowProcessor.getLogger().warn("Unknown SMEtype/idShort format: {}", (Object)data);
        }
        return result;
    }

    private void processSemanticIdDescription(String data, AasField field) {
        if (data != null) {
            String[] tmp = ParsingUtils.toLines(data);
            if (tmp.length == 1) {
                int pos = tmp[0].indexOf(" ");
                if (RowProcessor.isSemanticIdSpec(tmp[0], true)) {
                    pos = tmp[0].indexOf(" ", pos + 1);
                }
                if (pos > 0) {
                    RowProcessor.setSemanticId(s -> field.setSemanticId((String)s), tmp[0].substring(0, pos), false);
                    this.setFieldDescription(tmp[0].substring(pos + 1), field);
                } else {
                    RowProcessor.setSemanticId(s -> field.setSemanticId((String)s), tmp[0], false);
                }
            } else if (tmp.length >= 2) {
                RowProcessor.setSemanticId(s -> field.setSemanticId((String)s), tmp[0], false);
                Object description = String.join((CharSequence)" ", Arrays.copyOfRange(tmp, 1, tmp.length));
                String semId = field.getSemanticId();
                if (null != semId && semId.length() > 0) {
                    String pattern;
                    int pos = semId.indexOf(":");
                    if (pos > 0) {
                        semId = semId.substring(pos + 1);
                    }
                    if ((pos = tmp[0].indexOf(pattern = (pos = semId.lastIndexOf(" ")) < 0 ? semId : semId.substring(pos + 1))) > 0) {
                        description = tmp[0].substring(pos + pattern.length()).trim() + " " + (String)description;
                    }
                }
                String rest = RowProcessor.removeNote((String)description);
                description = ParsingUtils.inferEnum(rest, (String)description, field, this.enumsHandler, false);
                this.setFieldDescription((String)description, field);
            } else {
                RowProcessor.getLogger().warn("Unknown semanticId/description format: {}", (Object)data);
            }
        }
    }

    private static String removeNote(String data) {
        int pos = data.indexOf("Note: ");
        if (pos > 0) {
            data = data.substring(0, pos);
        }
        return data;
    }

    private void setFieldDescription(String description, AasField field) {
        int pos;
        String marker = "isCaseOf:";
        if (description.startsWith("isCaseOf:") && (pos = description.indexOf("]", "isCaseOf:".length())) > 0) {
            pos = ParsingUtils.consumeWhitespaces(description, pos + 1);
            if ((pos = ParsingUtils.consumeNonWhitespaces(description, pos)) < description.length()) {
                String isCaseOf = description.substring(0, pos);
                isCaseOf = isCaseOf.substring("isCaseOf:".length());
                RowProcessor.setSemanticId(s -> field.setIsCaseOf((String)s), isCaseOf, false);
                pos = ParsingUtils.consumeWhitespaces(description, pos);
                description = description.substring(pos);
            }
        }
        field.setMultiSemanticIds(ParsingUtils.countSemanticIdMarker(description) > 1);
        field.setDescription(ParsingUtils.filterLanguage(ParsingUtils.removeLinebreaks(RowProcessor.removeNote(description).trim())));
    }

    private boolean isValueExampleIgnore(String data) {
        return data.equals("n/a") || data.equals("[-]") || data.equalsIgnoreCase("see below");
    }

    private void processValueTypeExample(String data, AasField field) {
        if (data != null && data.length() > 0 && !this.isValueExampleIgnore(data)) {
            String[] tmp = ParsingUtils.toLines(data);
            if (tmp.length == 1) {
                this.processValueTypeExampleOneLine(tmp[0], field);
            } else if (tmp.length >= 2) {
                String type = tmp[0];
                Object exampleValue = tmp[1];
                int restLinePos = 2;
                while (restLinePos < tmp.length && (((String)exampleValue).endsWith("or:") || tmp[restLinePos].startsWith("or:"))) {
                    exampleValue = (String)exampleValue + tmp[restLinePos++];
                }
                int pos = type.indexOf("]");
                if (pos + 2 < type.length()) {
                    String pre = type.substring(pos + 1);
                    String sep = " ";
                    if (pre.trim().equals("Z")) {
                        sep = "";
                    }
                    exampleValue = pre + sep + (String)exampleValue;
                    type = type.substring(0, pos + 1);
                }
                while (restLinePos < tmp.length && (((String)exampleValue).trim().endsWith("=") || tmp[restLinePos].trim().startsWith("="))) {
                    exampleValue = (String)exampleValue + " " + tmp[restLinePos];
                    ++restLinePos;
                }
                ArrayList<String> moreExampleValues = null;
                if (field.getSmeType() == AasSmeType.MULTI_LANGUAGE_PROPERTY) {
                    moreExampleValues = new ArrayList<String>();
                    while (restLinePos < tmp.length && langStringEnd.matcher(tmp[restLinePos]).matches()) {
                        moreExampleValues.add(tmp[restLinePos]);
                        ++restLinePos;
                    }
                } else {
                    moreExampleValues = new ArrayList();
                    for (int i = restLinePos; i < tmp.length; ++i) {
                        String ex = tmp[i];
                        if (ex.startsWith("|_")) {
                            ex = ex.substring(2);
                        }
                        moreExampleValues.add(ex);
                    }
                }
                if (!"[-]".equals(type)) {
                    String tpy = ParsingUtils.fixTypeName(type);
                    if (tpy.trim().length() > 0) {
                        field.setValueType(ParsingUtils.fixTypeName(type));
                    }
                    this.setExampleValues(((String)exampleValue).trim(), moreExampleValues, field);
                }
                if (tmp.length > 0 && restLinePos < tmp.length) {
                    field.setExampleExplanation(String.join((CharSequence)"\n", Arrays.copyOfRange(tmp, restLinePos, tmp.length)));
                }
            } else {
                RowProcessor.getLogger().warn("Unknown example format: {}", (Object)data);
            }
        }
    }

    private void processValueTypeExampleOneLine(String line, AasField field) {
        int pos;
        String type = line;
        String exampleValue = null;
        boolean done = false;
        if (!type.startsWith("[")) {
            String tmpType;
            String tmpExampleValue;
            pos = type.indexOf(" ");
            if (pos > 0) {
                tmpExampleValue = ParsingUtils.removeQuotes(type.substring(pos + 1).trim());
                tmpType = type.substring(0, pos + 1).trim();
            } else {
                tmpType = type;
                tmpExampleValue = null;
            }
            if (AasField.mapPropertyType(tmpType, null) != null) {
                exampleValue = tmpExampleValue;
                if (null != exampleValue && exampleValue.startsWith("[") && exampleValue.endsWith("]")) {
                    exampleValue = null;
                }
                type = tmpType;
                done = true;
            }
        }
        if (!done && (pos = type.indexOf("]")) + 2 < type.length()) {
            exampleValue = type.substring(pos + 1).trim();
            type = type.substring(0, pos + 1);
        }
        String vType = ParsingUtils.fixTypeName(type);
        if (null == field.getValueType() && null != vType && vType.length() > 0) {
            field.setValueType(vType);
        }
        this.setExampleValues(exampleValue, null, field);
    }

    private void setExampleValues(String data, List<String> more, AasField field) {
        if ((data = ParsingUtils.toNullIfEmpty(data)) != null) {
            int pos;
            ArrayList<String> tokens = new ArrayList<String>();
            int lastPos = 0;
            do {
                if ((pos = data.indexOf("or:", lastPos)) <= 0) continue;
                tokens.add(data.substring(lastPos, pos).trim());
                lastPos = pos + 3;
            } while (pos > 0);
            tokens.add(data.substring(lastPos, data.length()).trim());
            boolean containsAt = tokens.stream().anyMatch(t -> t.contains("@"));
            if (AasSmeType.MULTI_LANGUAGE_PROPERTY == field.getSmeType() && containsAt) {
                this.splitMultiLanguageExample(tokens);
            } else {
                this.retokenize("[" + field.getValueType() + "]", tokens, null);
                this.retokenize(", ", tokens, s -> s.startsWith("\"") || s.startsWith("\u201c"));
            }
            String[] tmp = tokens.size() == 1 ? ParsingUtils.toLines(data) : tokens.toArray(new String[tokens.size()]);
            if (more != null) {
                ArrayList<String> moreTmp = new ArrayList<String>();
                for (String t2 : tmp) {
                    moreTmp.add(t2);
                }
                moreTmp.addAll(more);
                tmp = moreTmp.toArray(new String[moreTmp.size()]);
            }
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = ParsingUtils.removeQuotes(tmp[i]);
            }
            field.setExampleValues(RowProcessor.pruneExamples(tmp));
        }
    }

    private static String[] pruneExamples(String[] data) {
        Object result = data;
        if (data != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String d : data) {
                Matcher matcher = seeSection.matcher(d = d.trim());
                if (matcher.matches()) {
                    d = matcher.group(2).trim();
                }
                if (d == null || d.length() <= 0) continue;
                tmp.add(d);
            }
            result = tmp.size() == 0 ? null : tmp.toArray(new String[tmp.size()]);
        }
        return result;
    }

    private void retokenize(String sep, List<String> tokens, Predicate<String> condition) {
        if (tokens.size() == 1) {
            int pos;
            String token = tokens.get(0);
            if (token.startsWith("e.g. ")) {
                token = token.substring(5);
            }
            if ((pos = token.indexOf(sep)) > 0) {
                tokens.remove(0);
                int lastPos = 0;
                do {
                    if (null != condition && !condition.test(token.substring(pos + sep.length()))) continue;
                    tokens.add(token.substring(lastPos, pos).trim());
                    lastPos = pos + sep.length();
                } while ((pos = token.indexOf(sep, pos + sep.length())) > 0);
                tokens.add(token.substring(lastPos).trim());
            }
        }
    }

    private void splitMultiLanguageExample(List<String> tokens) {
        ArrayList<String> tmpToken = new ArrayList<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            String t = tokens.get(i);
            String[] tmp = t.split(" ");
            if (tmp.length > 1) {
                int lastJ = 0;
                for (int j = 0; j < tmp.length; ++j) {
                    int langPos = tmp[j].lastIndexOf("@");
                    if (langPos <= 0 || langPos < tmp[j].length() - 3) continue;
                    tmpToken.add(String.join((CharSequence)" ", Arrays.copyOfRange(tmp, lastJ, j + 1)));
                    lastJ = j + 1;
                }
                if (lastJ >= tmp.length) continue;
                tmpToken.add(String.join((CharSequence)" ", Arrays.copyOfRange(tmp, lastJ, tmp.length)));
                continue;
            }
            tmpToken.add(t);
        }
        tokens.clear();
        tokens.addAll(tmpToken);
    }

    private void processFieldCardinality(String data, AasField field) {
        if ((data = ParsingUtils.removeBrackets(data)) != null) {
            int pos;
            if ("*".equals(data = data.replace("\u2026", ".."))) {
                data = "0..*";
            }
            if ((pos = data.indexOf("..")) < 0) {
                field.setCardinality(this.toCardinality(data));
            } else {
                field.setCardinality(this.toCardinality(data.substring(0, pos)), this.toCardinality(data.substring(pos + 1 + 1)));
            }
        }
    }

    private int toCardinality(String data) {
        int result = Integer.MIN_VALUE;
        if (!(data = data.trim()).equals("n/a")) {
            if (data.startsWith("1 or ")) {
                data = data.substring(5);
            }
            if (data.equals("*") || data.equals("n")) {
                result = -1;
            } else {
                try {
                    result = Integer.parseInt(data);
                }
                catch (NumberFormatException e) {
                    RowProcessor.getLogger().warn("Reading cardinality '{}': {}", (Object)data, (Object)e.getMessage());
                }
            }
        }
        return result;
    }

    private void storeAsCurrent(List<AasType> newCurrent) {
        this.current.removeIf(t -> null != t.getSmeType() && !t.getSmeType().isType());
        this.aasTypes.addAll(this.current);
        this.current.clear();
        if (null != newCurrent) {
            this.current.addAll(newCurrent);
        }
    }

    private Map<String, AasType> mapPlainTypes(List<AasType> aasTypes) {
        HashMap<String, AasType> typeMap = new HashMap<String, AasType>();
        for (AasType t : aasTypes) {
            if (t.getIdShort() == null || t.isAspect()) continue;
            typeMap.put(t.getIdShort(), t);
        }
        return typeMap;
    }

    void readingCompleted() {
        this.storeAsCurrent(null);
        HashSet<AasType> delete = new HashSet<AasType>();
        Map<String, AasType> typeMap = this.mapPlainTypes(this.aasTypes);
        for (AasType aasType : this.aasTypes) {
            AasType transferTo = null;
            String aspect = null;
            if (aasType.isAspect()) {
                transferTo = typeMap.get(aasType.getIdShort());
                if (null != transferTo) {
                    RowProcessor.getLogger().info("Applying extension for {}.", (Object)aasType.getIdShort());
                    if (transferTo.getSemanticId() == null) {
                        String semId = aasType.getMappedSemanticId(aasType.getIdShort());
                        if (null == semId) {
                            semId = aasType.getSemanticId();
                        }
                        transferTo.setSemanticId(semId);
                    }
                    if (aasType.getDescription() != null) {
                        transferTo.setDescription(aasType.getDescription());
                    }
                } else {
                    RowProcessor.getLogger().info("Cannot apply extension for {}. Not found. Skipping.", (Object)aasType.getIdShort());
                }
                delete.add(aasType);
            } else if (aasType.getSmeType() == null && aasType.getIdShort().equals("-")) {
                String desc = aasType.getDescription();
                Matcher matcher = extensionDesc.matcher(desc);
                if (matcher.matches()) {
                    String targetIdShort = matcher.group(1);
                    transferTo = typeMap.get(targetIdShort);
                    if (null != transferTo) {
                        aspect = ParsingUtils.removeSuffix(matcher.group(2), "-specific");
                        RowProcessor.getLogger().info("Applying extension {} to {}.", (Object)aspect, (Object)targetIdShort);
                    } else {
                        RowProcessor.getLogger().error("Cannot apply extension {} for {} as no such type found. Skipping.", aspect, (Object)targetIdShort);
                    }
                } else {
                    RowProcessor.getLogger().error("Cannot identify extension conditions for {}. Skipping.", (Object)aasType.getIdShort());
                }
                delete.add(aasType);
            }
            if (transferTo == null) continue;
            for (AasField f : aasType.fields()) {
                AasField fn = new AasField(f);
                fn.setAspect(aspect);
                transferTo.addField(fn);
            }
            for (AasOperation o : aasType.operations()) {
                AasOperation on = new AasOperation(o);
                on.setAspect(aspect);
                transferTo.addOperation(on);
            }
        }
        this.aasTypes.removeAll(delete);
        typeMap.clear();
        for (AasType aasType : this.aasTypes) {
            typeMap.put(aasType.getIdShort(), aasType);
        }
        for (Map.Entry entry : this.deferredTypes.entrySet()) {
            if (typeMap.containsKey(entry.getKey())) continue;
            AasType prototype = typeMap.get(entry.getValue());
            int pos = this.aasTypes.indexOf(prototype);
            if (null != prototype) {
                AasType t = new AasType(prototype);
                t.setIdShort((String)entry.getKey());
                this.aasTypes.add(pos + 1, t);
                continue;
            }
            RowProcessor.getLogger().error("Unresolved type '{}' points to type '{}' which does not exist", entry.getKey(), entry.getValue());
        }
    }

    AasSpecSummary getSummary() {
        AasSpecSummary result = new AasSpecSummary(this.aasTypes, this.aasEnums);
        result.setIdentifier(null, this.versionIdentifier, this.version, this.versionedName, this.specNumber);
        return result;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ParsingUtils.class);
    }
}

