/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.ivml;

import de.iip_ecosphere.platform.configuration.easyProducer.ModelInfo;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.AasIvmlMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlTypeKind;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlUtils;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.ValueVisitor;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.aas.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;

class TypeMapper {
    public static final int UIGROUP_SPACING = 100;
    public static final int UIGROUP_POS_FRONT = 99;
    private net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration cfg;
    private Set<Project> doneProjects = new HashSet<Project>();
    private Set<String> doneTypes = new HashSet<String>();
    private SubmodelElementContainerBuilder builder;
    private Predicate<AbstractVariable> variableFilter;
    private Stack<Map<String, Object>> assignments = new Stack();
    private Function<String, String> metaShortId;
    private Map<String, Integer> uiGroups = new HashMap<String, Integer>();

    TypeMapper(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration cfg, Predicate<AbstractVariable> variableFilter, SubmodelElementContainerBuilder builder, Function<String, String> metaShortId) {
        this.cfg = cfg;
        this.builder = builder;
        this.variableFilter = variableFilter;
        this.metaShortId = metaShortId;
    }

    void mapTypes() {
        this.mapPrimitiveType("String");
        this.mapPrimitiveType("Boolean");
        this.mapPrimitiveType("Real");
        this.mapPrimitiveType("Integer");
        this.mapTypes(this.cfg.getConfiguration().getProject());
    }

    private void mapTypes(Project project) {
        if (null != project && !this.doneProjects.contains(project)) {
            this.doneProjects.add(project);
            for (int e = 0; e < project.getElementCount(); ++e) {
                ContainableModelElement elt = project.getElement(e);
                if (!(elt instanceof CustomDatatype)) continue;
                this.mapType((IDatatype)((CustomDatatype)elt));
            }
            for (int i = 0; i < project.getImportsCount(); ++i) {
                this.mapTypes((Project)project.getImport(i).getResolved());
            }
        }
    }

    private void mapPrimitiveType(String name) {
        String typeId = AasUtils.fixId((String)name);
        if (!this.isDoneType(typeId)) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder typeB = this.builder.createSubmodelElementCollectionBuilder(typeId);
            TypeMapper.addTypeKind((SubmodelElementContainerBuilder)typeB, IvmlTypeKind.PRIMITIVE, this.metaShortId);
            typeB.build();
        }
    }

    public static void addTypeKind(SubmodelElementContainerBuilder typeB, IDatatype type, Function<String, String> metaShortId) {
        TypeMapper.addTypeKind(typeB, IvmlTypeKind.asTypeKind(type), metaShortId);
    }

    public static void addTypeKind(SubmodelElementContainerBuilder typeB, IvmlTypeKind kind, Function<String, String> metaShortId) {
        typeB.createPropertyBuilder(AasUtils.fixId((String)metaShortId.apply("typeKind"))).setValue(Type.INTEGER, (Object)kind.getId()).build();
    }

    private void mapCompoundType(Compound type) {
        String typeId = AasUtils.fixId((String)type.getName());
        if (!this.isDoneType(typeId)) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder typeB = this.builder.createSubmodelElementCollectionBuilder(typeId);
            HashMap<String, SubmodelElementList.SubmodelElementListBuilder> doneSlots = new HashMap<String, SubmodelElementList.SubmodelElementListBuilder>();
            this.mapCompoundSlots((IDecisionVariableContainer)type, type, type, typeB, doneSlots);
            this.mapRefines(type, type, typeB, doneSlots);
            for (SubmodelElementList.SubmodelElementListBuilder builder : this.sortMembers(type, doneSlots)) {
                builder.build();
            }
            typeB.createPropertyBuilder(this.metaShortId.apply("abstract")).setValue(Type.BOOLEAN, (Object)type.isAbstract()).build();
            typeB.createPropertyBuilder(this.metaShortId.apply("refines")).setValue(Type.STRING, (Object)TypeMapper.getRefines(type)).build();
            TypeMapper.addTypeKind((SubmodelElementContainerBuilder)typeB, IvmlTypeKind.COMPOUND, this.metaShortId);
            typeB.build();
        }
    }

    private List<SubmodelElementList.SubmodelElementListBuilder> sortMembers(Compound type, Map<String, SubmodelElementList.SubmodelElementListBuilder> slots) {
        ArrayList<SubmodelElementList.SubmodelElementListBuilder> result = new ArrayList<SubmodelElementList.SubmodelElementListBuilder>();
        HashSet<String> done = null;
        if (type instanceof Compound) {
            ArrayList<String> names = new ArrayList<String>();
            done = new HashSet<String>();
            this.collectMemberNames(type, names, done);
            HashMap<Integer, List<SubmodelElementList.SubmodelElementListBuilder>> namesByUiGroups = new HashMap<Integer, List<SubmodelElementList.SubmodelElementListBuilder>>();
            for (String name : names) {
                SubmodelElementList.SubmodelElementListBuilder elt = slots.get(name);
                if (null == elt) continue;
                int uiGroup = this.getUiGroup(type.getName(), name);
                int uiPos = uiGroup % 100;
                ArrayList<SubmodelElementList.SubmodelElementListBuilder> tmp = (ArrayList<SubmodelElementList.SubmodelElementListBuilder>)namesByUiGroups.get(uiGroup /= 100);
                if (null == tmp) {
                    tmp = new ArrayList<SubmodelElementList.SubmodelElementListBuilder>();
                    namesByUiGroups.put(uiGroup, tmp);
                }
                if (uiPos == 99) {
                    uiPos = 0;
                }
                if (0 <= uiPos && uiPos < tmp.size()) {
                    tmp.add(uiPos, elt);
                } else {
                    tmp.add(elt);
                }
                done.remove(name);
            }
            this.add(namesByUiGroups, result, 1, 1);
            this.add(namesByUiGroups, result, 0, 0);
            this.add(namesByUiGroups, result, -1, -1);
        }
        return result;
    }

    private void add(Map<Integer, List<SubmodelElementList.SubmodelElementListBuilder>> src, List<SubmodelElementList.SubmodelElementListBuilder> tgt, int start, int inc) {
        int u = start;
        while (src.get(u) != null) {
            tgt.addAll((Collection<SubmodelElementList.SubmodelElementListBuilder>)src.get(u));
            if (inc == 0) break;
            u += inc;
        }
    }

    private void collectMemberNames(Compound type, List<String> result, Set<String> done) {
        if (!type.getProject().getName().equals("MetaConcepts")) {
            for (int r = 0; r < type.getRefinesCount(); ++r) {
                this.collectMemberNames(type.getRefines(r), result, done);
            }
            this.collectMemberNamesContainer((IDecisionVariableContainer)type, result, done);
        }
    }

    private void collectMemberNamesContainer(IDecisionVariableContainer cnt, List<String> result, Set<String> done) {
        for (int e = 0; e < cnt.getModelElementCount(); ++e) {
            ContainableModelElement element = cnt.getModelElement(e);
            if (element instanceof AbstractVariable) {
                String name = element.getName();
                if (done.contains(name)) continue;
                done.add(name);
                result.add(name);
                continue;
            }
            if (!(element instanceof AttributeAssignment)) continue;
            this.collectMemberNamesContainer((IDecisionVariableContainer)((AttributeAssignment)element), result, done);
        }
    }

    void mapType(IDatatype type) {
        if ((type = Reference.dereference((IDatatype)type)) instanceof DerivedDatatype) {
            this.mapDerivedType((DerivedDatatype)type);
        } else if (type instanceof Enum) {
            this.mapEnumType((Enum)type);
        } else if (type instanceof Container) {
            type = ((Container)type).getContainedType();
        } else if (type instanceof Compound) {
            this.mapCompoundType((Compound)type);
        }
    }

    private void mapEnumType(Enum type) {
        String typeId = AasUtils.fixId((String)type.getName());
        if (!this.isDoneType(typeId)) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder typeB = this.builder.createSubmodelElementCollectionBuilder(typeId);
            for (int l = 0; l < type.getLiteralCount(); ++l) {
                EnumLiteral lit = type.getLiteral(l);
                SubmodelElementCollection.SubmodelElementCollectionBuilder litB = typeB.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)lit.getName()));
                litB.createPropertyBuilder("varValue").setValue(Type.STRING, (Object)lit.getName()).build();
                litB.createPropertyBuilder("ordinal").setValue(Type.INTEGER, (Object)lit.getOrdinal()).build();
                litB.build();
            }
            TypeMapper.addTypeKind((SubmodelElementContainerBuilder)typeB, IvmlTypeKind.ENUM, this.metaShortId);
            typeB.build();
        }
    }

    private boolean isDoneType(String typeId) {
        boolean known = this.doneTypes.contains(typeId);
        if (!known) {
            this.doneTypes.add(typeId);
        }
        return known;
    }

    private void mapDerivedType(DerivedDatatype type) {
        String typeId = AasUtils.fixId((String)type.getName());
        IDatatype baseType = type.getBasisType();
        if (!this.isDoneType(typeId)) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder typeB = this.builder.createSubmodelElementCollectionBuilder(typeId);
            typeB.createPropertyBuilder(this.metaShortId.apply("refines")).setValue(Type.STRING, (Object)IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)baseType)).build();
            TypeMapper.addTypeKind((SubmodelElementContainerBuilder)typeB, (IDatatype)type, this.metaShortId);
            typeB.build();
        }
        this.mapType(baseType);
    }

    private static String getRefines(Compound type) {
        Object result = "";
        for (int i = 0; i < type.getRefinesCount(); ++i) {
            if (((String)result).length() > 0) {
                result = (String)result + ", ";
            }
            result = (String)result + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)type.getRefines(i));
        }
        return result;
    }

    private void mapRefines(Compound type, Compound topType, SubmodelElementCollection.SubmodelElementCollectionBuilder typeB, Map<String, SubmodelElementList.SubmodelElementListBuilder> doneSlots) {
        for (int r = 0; r < type.getRefinesCount(); ++r) {
            Compound refines = type.getRefines(r);
            this.mapCompoundSlots((IDecisionVariableContainer)refines, refines, topType, typeB, doneSlots);
            this.mapRefines(refines, topType, typeB, doneSlots);
        }
    }

    private void mapCompoundSlots(IDecisionVariableContainer cnt, Compound type, Compound topType, SubmodelElementCollection.SubmodelElementCollectionBuilder typeB, Map<String, SubmodelElementList.SubmodelElementListBuilder> doneSlots) {
        for (int i = 0; i < cnt.getElementCount(); ++i) {
            this.mapCompoundSlot(cnt.getElement(i), type, topType, typeB, doneSlots);
        }
        for (int a = 0; a < cnt.getAssignmentCount(); ++a) {
            AttributeAssignment assng = cnt.getAssignment(a);
            HashMap<String, Object> thisLevelAssignments = new HashMap<String, Object>();
            for (int d = 0; d < assng.getAssignmentDataCount(); ++d) {
                AttributeAssignment.Assignment data = assng.getAssignmentData(d);
                ConstraintSyntaxTree expr = data.getExpression();
                Value val = null;
                if (expr instanceof Variable) {
                    IDecisionVariable var = this.cfg.getConfiguration().getDecision(((Variable)expr).getVariable());
                    if (null != var) {
                        val = var.getValue();
                    }
                } else if (expr instanceof ConstantValue) {
                    val = IvmlUtils.getConstValue(expr);
                }
                if (val == null) continue;
                thisLevelAssignments.put(data.getName(), val.getValue());
            }
            this.assignments.push(thisLevelAssignments);
            this.mapCompoundSlots((IDecisionVariableContainer)assng, type, topType, typeB, doneSlots);
            this.assignments.pop();
        }
    }

    static void addMetaDefault(IDecisionVariable var, SubmodelElementContainerBuilder varBuilder, Function<String, String> metaShortId) {
        TypeMapper.addMetaDefault(var.getConfiguration(), var.getDeclaration(), varBuilder, metaShortId);
    }

    static void addMetaDefault(Configuration cfg, AbstractVariable decl, SubmodelElementContainerBuilder varBuilder, Function<String, String> metaShortId) {
        ConstraintSyntaxTree dflt = decl.getDefaultValue();
        if (null != dflt) {
            EvaluationVisitor eval = new EvaluationVisitor((IConfiguration)cfg, null, false, null);
            try {
                dflt.accept((IConstraintTreeVisitor)eval);
                Value dfltValue = eval.getResult();
                eval.clear();
                if (dfltValue != null) {
                    ValueVisitor valueVisitor = new ValueVisitor();
                    dfltValue.accept((IValueVisitor)valueVisitor);
                    Object aasValue = valueVisitor.getAasValue();
                    if (null != aasValue) {
                        varBuilder.createPropertyBuilder(AasUtils.fixId((String)metaShortId.apply("default"))).setValue(Type.STRING, (Object)aasValue.toString()).build();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void mapCompoundSlot(DecisionVariableDeclaration slot, Compound type, Compound topType, SubmodelElementCollection.SubmodelElementCollectionBuilder typeB, Map<String, SubmodelElementList.SubmodelElementListBuilder> doneSlots) {
        String slotName = AasUtils.fixId((String)slot.getName());
        if (!doneSlots.containsKey(slotName) && this.variableFilter.test((AbstractVariable)slot)) {
            String lang = AasIvmlMapper.getLang();
            IDatatype slotType = slot.getType();
            SubmodelElementList.SubmodelElementListBuilder propB = typeB.createSubmodelElementListBuilder(slotName);
            doneSlots.put(slotName, propB);
            propB.createPropertyBuilder("name").setValue(Type.STRING, (Object)slotName).setDescription(new LangString[]{new LangString(lang, ModelInfo.getCommentSafe((ModelElement)slot))}).build();
            propB.createPropertyBuilder("type").setValue(Type.STRING, (Object)IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)slotType)).build();
            int uiGroup = 100;
            Object tmp = this.getAssignmentValue("uiGroup");
            if (tmp instanceof Integer) {
                uiGroup = (Integer)tmp;
            } else {
                for (int a = 0; a < slot.getAttributesCount(); ++a) {
                    Attribute attribute = slot.getAttribute(a);
                    if (!"uiGroup".equals(attribute.getName())) continue;
                    uiGroup = IvmlUtils.getIntValue(attribute.getDefaultValue(), uiGroup);
                }
            }
            this.uiGroups.put(topType.getName() + "." + slotName, uiGroup);
            if (uiGroup >= 100 || uiGroup <= 100) {
                uiGroup /= 100;
            }
            propB.createPropertyBuilder("uiGroup").setValue(Type.INTEGER, (Object)uiGroup).build();
            TypeMapper.addMetaDefault(this.cfg.getConfiguration(), (AbstractVariable)slot, (SubmodelElementContainerBuilder)propB, this.metaShortId);
            if (slotType != type) {
                this.mapType(slotType);
            }
        }
    }

    public int getUiGroup(String type, String slot) {
        Integer tmp = this.uiGroups.get(type + "." + slot);
        return null == tmp ? 100 : tmp;
    }

    private Object getAssignmentValue(String name) {
        Object result = null;
        for (int i = this.assignments.size() - 1; null == result && i >= 0; --i) {
            result = ((Map)this.assignments.get(i)).get(name);
        }
        return result;
    }
}

