/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.ivml;

import de.iip_ecosphere.platform.support.aas.Type;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.VersionType;

class TypeVisitor
implements IDatatypeVisitor {
    private Type aasType;

    TypeVisitor() {
    }

    Type getAasType() {
        Type result = this.aasType;
        this.aasType = null;
        return result;
    }

    public void visitDatatype(IDatatype datatype) {
        this.aasType = Type.NONE;
    }

    public void visitAnyType(AnyType datatype) {
        this.aasType = Type.NONE;
    }

    public void visitMetaType(MetaType datatype) {
        this.aasType = Type.NONE;
    }

    public void visitDerivedType(DerivedDatatype datatype) {
        DerivedDatatype.resolveToBasis((IDatatype)datatype).accept((IDatatypeVisitor)this);
    }

    public void visitSet(Set set) {
        this.aasType = Type.NONE;
    }

    public void visitSequence(Sequence sequence) {
        this.aasType = Type.NONE;
    }

    public void visitReference(Reference reference) {
        this.aasType = Type.STRING;
    }

    public void visitBooleanType(BooleanType type) {
        this.aasType = Type.BOOLEAN;
    }

    public void visitStringType(StringType type) {
        this.aasType = Type.STRING;
    }

    public void visitConstraintType(ConstraintType type) {
        this.aasType = Type.STRING;
    }

    public void visitIntegerType(IntegerType type) {
        this.aasType = Type.INTEGER;
    }

    public void visitVersionType(VersionType type) {
        this.aasType = Type.STRING;
    }

    public void visitRealType(RealType type) {
        this.aasType = Type.DOUBLE;
    }

    public void visitCompoundType(Compound compound) {
        this.aasType = Type.NONE;
    }

    public void visitEnumType(Enum enumType) {
        this.aasType = Type.STRING;
    }

    public void visitOrderedEnumType(OrderedEnum enumType) {
        this.aasType = Type.STRING;
    }
}

