/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.io.FileUtils;
import net.ssehub.easy.basics.io.JarUtils;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.dslCore.DefaultLib;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.varModel.management.VarModel;

public class DefaultLibUtils {
    public static final LocationRegistrar DEFAULT_REGISTRAR = new LocationRegistrar(){

        @Override
        public void register(File location, ProgressObserver observer) throws ModelManagementException {
            ModelManagementException returnExc = null;
            try {
                VarModel.INSTANCE.locations().addLocation(location, observer).toDefaultLibLocation();
            }
            catch (ModelManagementException exc) {
                returnExc = exc;
            }
            try {
                BuildModel.INSTANCE.locations().addLocation(location, observer).toDefaultLibLocation();
            }
            catch (ModelManagementException exc) {
                returnExc = exc;
            }
            try {
                TemplateModel.INSTANCE.locations().addLocation(location, observer).toDefaultLibLocation();
            }
            catch (ModelManagementException exc) {
                returnExc = exc;
            }
            if (returnExc != null) {
                throw returnExc;
            }
        }
    };

    public static void loadDefaultModels(ProgressObserver observer, String pluginId) {
        DefaultLibUtils.loadDefaultModels(DefaultLibUtils.class.getClassLoader(), observer, null, pluginId);
    }

    public static void loadDefaultModels(ClassLoader loader, ProgressObserver observer, String pluginId) {
        DefaultLibUtils.loadDefaultModels(loader, observer, null, pluginId);
    }

    public static void loadDefaultModels(ClassLoader loader, ProgressObserver observer, List<URL> additionalLibs, String pluginId) {
        DefaultLibUtils.loadDefaultModels(loader, observer, DEFAULT_REGISTRAR, additionalLibs, pluginId);
    }

    public static void loadDefaultModels(ClassLoader loader, ProgressObserver observer, LocationRegistrar registrar, List<URL> additionalLibs, String pluginId) {
        ArrayList<URL> libs = new ArrayList<URL>();
        if (additionalLibs != null) {
            libs.addAll(additionalLibs);
        }
        DefaultLib.appendAll(libs);
        int count = 0;
        for (URL url : libs) {
            EASyLoggerFactory.INSTANCE.getLogger(DefaultLibUtils.class, pluginId).info("Trying to load default IVML/VIL library from '" + String.valueOf(url));
            try {
                File defltLibFolder;
                ModelLocations.Location defltLibLocation;
                String urlString = url.toString().replace(" ", "%20");
                URI uri = new URI(urlString);
                if (JarUtils.isJarURL((URL)url)) {
                    File file = FileUtils.createTmpDir((String)("easyDefaultLib_" + count));
                    JarUtils.unpackJar((URL)url, (File)file);
                    uri = file.toURI();
                }
                if ((defltLibLocation = VarModel.INSTANCE.locations().getLocationFor(uri)) == null && FileUtils.isFileURI((URI)uri) && (defltLibFolder = new File(uri)).exists()) {
                    registrar.register(defltLibFolder, observer);
                    EASyLoggerFactory.INSTANCE.getLogger(DefaultLibUtils.class, pluginId).info("Loaded default IVML/VIL library from '" + String.valueOf(url));
                }
                ++count;
            }
            catch (IOException | URISyntaxException | ModelManagementException e) {
                EASyLoggerFactory.INSTANCE.getLogger(DefaultLibUtils.class, pluginId).error("While loading default library in '" + String.valueOf(url) + "': " + e.getMessage());
            }
        }
    }

    public static interface LocationRegistrar {
        public void register(File var1, ProgressObserver var2) throws ModelManagementException;
    }
}

