/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactCreator;

class ArtifactCreatorNode {
    private IArtifactCreator creator;
    private List<ArtifactCreatorNode> children;

    public ArtifactCreatorNode(IArtifactCreator creator) {
        this.creator = creator;
    }

    public boolean isMoreGeneralThan(Class<? extends IArtifactCreator> cls) {
        return this.creator == null || this.creator.getClass().isAssignableFrom(cls);
    }

    public int getChildrenCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public ArtifactCreatorNode getChild(int index) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.children.get(index);
    }

    void addChild(IArtifactCreator creator) {
        if (this.children == null) {
            this.children = new ArrayList<ArtifactCreatorNode>();
        }
        this.children.add(new ArtifactCreatorNode(creator));
    }

    void setCreator(IArtifactCreator creator) {
        if (creator != null) {
            this.creator = creator;
        }
    }

    public IArtifactCreator getCreator() {
        return this.creator;
    }

    public boolean handlesArtifact(Class<? extends IArtifact> kind, Object real) {
        return this.creator == null || this.creator.handlesArtifact(kind, real);
    }

    String getCreatorClassName() {
        return this.creator == null ? "<root>" : this.creator.getClass().getName();
    }

    void configure(Properties properties, List<Message> messages) {
        if (this.creator != null) {
            this.creator.configure(properties, messages);
        }
    }

    String getArtifactName() {
        return this.creator.getArtifactClass().getSimpleName();
    }

    public boolean subtreeMayHandle(Class<? extends IArtifact> kind) {
        return kind != null && this.creator.getArtifactClass().isAssignableFrom(kind);
    }
}

