/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactChangedListenerQueue;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListener;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListenerQueue;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

public abstract class CompositeArtifact
implements IArtifact,
IArtifactChangedListener {
    private Text textRepresentation;
    private Binary binaryRepresentation;
    private IArtifactChangedListenerQueue listeners = new ArtifactChangedListenerQueue();
    private boolean representationChanged;

    @ReturnGenerics(value={FragmentArtifact.class})
    public abstract Set<? extends FragmentArtifact> selectAll();

    @Override
    public final Text getText() throws VilException {
        if (this.textRepresentation == null) {
            this.textRepresentation = this.createText();
            this.listeners.registerListener(this.textRepresentation);
            this.textRepresentation.getListeners().registerListener(this);
        }
        return this.textRepresentation;
    }

    @Override
    public final Binary getBinary() throws VilException {
        if (this.binaryRepresentation == null) {
            this.binaryRepresentation = this.createBinary();
            this.listeners.registerListener(this.binaryRepresentation);
            this.binaryRepresentation.getListeners().registerListener(this);
        }
        return this.binaryRepresentation;
    }

    @Override
    public void artifactChanged(Object cause) throws VilException {
        this.representationChanged = true;
    }

    protected boolean getRepresentationChanged(boolean reset) {
        boolean result = this.representationChanged;
        if (reset) {
            this.representationChanged = false;
        }
        return result;
    }

    protected Text getTextInstance() {
        return this.textRepresentation;
    }

    protected Binary getBinaryInstance() {
        return this.binaryRepresentation;
    }

    protected abstract Text createText() throws VilException;

    protected abstract Binary createBinary() throws VilException;

    @Override
    public void update() throws VilException {
        if (this.binaryRepresentation != null) {
            this.binaryRepresentation.updateContents();
        }
        if (this.textRepresentation != null) {
            this.textRepresentation.updateContents();
        }
    }
}

