/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.xml;

import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class XmlAttribute
extends FragmentArtifact
implements IStringValueProvider {
    private XmlElement parent;
    private String name;
    private String value;

    XmlAttribute(XmlElement parent, String name, String value) {
        this.parent = parent;
        this.name = name;
        this.value = value;
    }

    public static XmlAttribute create(XmlElement parent, String name, String value) throws VilException {
        return XmlAttribute.create(parent, name, value, true);
    }

    public static XmlAttribute create(XmlElement parent, String name, String value, boolean forceOverwrite) throws VilException {
        XmlAttribute newAttribute = null;
        if (parent == null) {
            throw new VilException("Can not add attribute to NULL element!", 30005);
        }
        Element parentElem = (Element)parent.getNode();
        if (forceOverwrite || !parentElem.hasAttribute(name)) {
            try {
                parentElem.setAttribute(name, value);
                newAttribute = parent.addAttribute(name, value);
                parent.synchronizeAttributeSequence();
            }
            catch (DOMException exc) {
                throw new VilException("Invalid character, name or ID!", 30007);
            }
        } else {
            newAttribute = parent.getAttribute(name);
        }
        return newAttribute;
    }

    @Override
    public void delete() throws VilException {
        this.checkValidity();
        this.parent.deleteAttribute(this);
        this.parent = null;
    }

    @Override
    public String getName() throws VilException {
        this.checkValidity();
        return this.name;
    }

    String getNameSafe() {
        return this.name;
    }

    public String getValue() throws VilException {
        this.checkValidity();
        return this.value;
    }

    public void setValue(String value) throws VilException {
        this.checkValidity();
        this.value = value;
        this.parent.getNode().getAttributes().getNamedItem(this.name).setNodeValue(value);
        this.parent.notifyChange(this);
    }

    @Override
    public void rename(String name) throws VilException {
        this.checkValidity();
        this.parent.renameAttribute(this, name);
    }

    @Override
    public Text getText() throws VilException {
        this.checkValidity();
        return Text.CONSTANT_EMPTY;
    }

    @Override
    public Binary getBinary() throws VilException {
        this.checkValidity();
        return Binary.CONSTANT_EMPTY;
    }

    @Override
    public void accept(IArtifactVisitor visitor) {
        visitor.visitFragmentArtifact(this);
    }

    public XmlElement getParent() {
        return this.parent;
    }

    void setParent(XmlElement parent) {
        this.parent = parent;
    }

    private void checkValidity() throws VilException {
        if (this.parent == null) {
            throw new VilException("attribute already deleted", 30003);
        }
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public void update() throws VilException {
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "xmlAttribute: \"" + this.name + "\"";
    }
}

