/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.xml;

import net.ssehub.easy.instantiation.core.model.artifactModel.CompositeFragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListener;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlElement;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlFileArtifact;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public abstract class XmlNode
extends CompositeFragmentArtifact
implements IStringValueProvider,
IArtifactChangedListener {
    private XmlElement parent;
    private Text cdata;
    private Text text;
    private Node node;

    protected XmlNode(XmlElement parent, Node node) {
        this.parent = parent;
        this.node = node;
    }

    public XmlElement getParent() {
        return this.parent;
    }

    protected Node getNode() {
        return this.node;
    }

    protected void setNode(Node node) {
        this.node = node;
    }

    protected void checkValidity() throws VilException {
        if (this.node == null) {
            throw new VilException("element already deleted", 30003);
        }
    }

    protected void checkRoot() throws VilException {
        if (this.node != null && this.node.getOwnerDocument().getDocumentElement() == this.node) {
            throw new VilException("root element can not be changed", 30001);
        }
    }

    abstract void deleteChild(XmlNode var1);

    @Override
    public void delete() throws VilException {
        this.checkValidity();
        this.checkRoot();
        this.parent.deleteChild(this);
        this.node.getParentNode().removeChild(this.node);
        this.node = null;
        this.parent = null;
    }

    public void setCdata(String cdata) throws VilException {
        if (this.cdata == null) {
            this.cdata = new Text(cdata, true);
            this.cdata.getListeners().registerListener(this);
        } else {
            this.cdata.setText(cdata);
        }
        this.node.setTextContent(cdata);
    }

    @Override
    public Binary getBinary() throws VilException {
        return new Binary("", true);
    }

    @Override
    public Text getText() throws VilException {
        if (this.text == null) {
            this.text = new Text(true);
        }
        return this.text;
    }

    protected Text getTextDirect() {
        return this.text;
    }

    public Text getCdata() throws VilException {
        if (this.cdata == null) {
            this.setCdata("");
        }
        return this.cdata;
    }

    protected Text getCdataDirect() {
        return this.cdata;
    }

    @Invisible
    XmlFileArtifact getFile() {
        return this.parent != null ? this.parent.getFile() : null;
    }

    protected void notifyChange() {
        this.notifyChange(this);
    }

    void notifyChange(Object cause) {
        XmlFileArtifact file = this.getFile();
        if (file != null) {
            try {
                file.artifactChanged(cause);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
    }

    @Override
    @Invisible
    public void artifactChanged(Object cause) throws VilException {
        this.node.setTextContent(this.cdata.getText());
        this.notifyChange(this);
    }

    @Override
    public void accept(IArtifactVisitor visitor) {
        visitor.visitCompositeFragmentArtifact(this);
    }

    @Override
    public void update() throws VilException {
    }

    int getChildCount() {
        return 0;
    }

    XmlNode getChild(int index) {
        throw new IndexOutOfBoundsException();
    }

    String getNameSafe() {
        return "";
    }

    void synchronizeAttributeSequence() {
    }

    void sortAttributes(Attributes att) {
    }
}

