/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.ModelRepository;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildLangImportResolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.varModel.management.VarModel;

public class BuildModel
extends ModelManagement<Script> {
    public static final BuildModel INSTANCE = new BuildModel();

    private BuildModel() {
    }

    protected ModelRepository<Script> createRepository() {
        return new VilModelRepository(this);
    }

    protected ImportResolver<Script> createResolver() {
        return new BuildLangImportResolver();
    }

    private static class VilModelRepository
    extends ModelRepository<Script> {
        protected VilModelRepository(ModelManagement<Script> modelMgmt) {
            super(modelMgmt);
        }

        public Script createModel(String modelName, List<Script> imports) {
            Script result = new Script(modelName);
            for (Script p : imports) {
                try {
                    ModelImport imp = new ModelImport(p.getName(), false, null, false);
                    imp.setResolved((IModel)p);
                    result.addImport(imp);
                }
                catch (ModelManagementException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(VarModel.class, "net.ssehub.easy.instantiation.core").error("While creating ad-hoc model " + modelName + ": " + e.getMessage());
                }
            }
            return result;
        }
    }
}

