/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleExecutionResult;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuntimeEnvironment;

public class RuleExecutionContext {
    private RuntimeEnvironment environment;
    private Rule rule;
    private Set<IArtifact> result;
    private Set<IArtifact> allResults;
    private RuleExecutionResult.Status status;
    private Object[] rhsValues;
    private String failReason;
    private Integer failCode;

    public RuleExecutionContext(Rule rule, RuntimeEnvironment environment) {
        this.rule = rule;
        this.result = new HashSet<IArtifact>();
        this.allResults = new HashSet<IArtifact>();
        this.environment = environment;
    }

    public Rule getRule() {
        return this.rule;
    }

    void add(Object value) {
        if (value instanceof IArtifact) {
            IArtifact artifact = (IArtifact)value;
            this.result.add(artifact);
            this.environment.getOtherProjects().add(artifact);
        } else if (value instanceof net.ssehub.easy.instantiation.core.model.vilTypes.Collection) {
            for (Object val : (net.ssehub.easy.instantiation.core.model.vilTypes.Collection)value) {
                this.add(val);
            }
        }
    }

    void add(IArtifact artifact) {
        if (artifact != null) {
            this.result.add(artifact);
        }
    }

    void add(RuleExecutionResult executionResult) {
        if (executionResult != null) {
            this.allResults.addAll(executionResult.allResultsAsCollection());
            this.allResults.addAll(executionResult.resultAsCollection());
        }
    }

    void addAllResults() {
        this.allResults.addAll(this.result);
    }

    Collection<IArtifact> allResultsAsCollection() {
        return this.allResults;
    }

    Collection<IArtifact> resultAsCollection() {
        return this.result;
    }

    public void setStatus(RuleExecutionResult.Status status) {
        this.status = status;
    }

    public void setStatus(Object object) {
        this.setStatus(RuleExecutionResult.Status.toStatus(object));
    }

    public RuleExecutionResult.Status getStatus() {
        return this.status;
    }

    public Object[] getRhsValues() {
        return this.rhsValues;
    }

    void setRhsValues(Object[] rhsValues) {
        this.rhsValues = rhsValues;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public void setFailCode(Integer failCode) {
        this.failCode = failCode;
    }

    public Integer getFailCode() {
        return this.failCode;
    }

    public static enum FailState {
        NO_FAIL,
        FAIL,
        REFAIL;

    }
}

