/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.execOperand.ExecutableOperand;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class StrategyCallExpression
extends CallExpression {
    private Type type;
    private boolean execResolved;
    private VariableDeclaration nameVar;
    private transient TypeRegistry typeRegistry = TypeRegistry.DEFAULT;

    StrategyCallExpression() throws VilException {
    }

    public StrategyCallExpression(Object parent, String name, Expression ... arguments) throws VilException {
        this(parent, name, CallArgument.createUnnamedArguments(arguments));
    }

    public StrategyCallExpression(Object parent, String name, CallArgument ... arguments) throws VilException {
        super(parent, name, arguments);
        this.type = Type.INSTANTIATOR;
    }

    public StrategyCallExpression(VariableDeclaration nameVar, Expression ... arguments) throws VilException {
        this(nameVar, CallArgument.createUnnamedArguments(arguments));
    }

    public StrategyCallExpression(VariableDeclaration nameVar, CallArgument ... arguments) throws VilException {
        super(null, nameVar.getName(), arguments);
        this.type = Type.EXECUTE;
        this.nameVar = nameVar;
    }

    public void setTypeRegistry(TypeRegistry registry) {
        if (registry != null) {
            this.typeRegistry = registry;
        }
    }

    public VariableDeclaration getNameVariable() {
        return this.nameVar;
    }

    @Override
    protected boolean doZeroArgumentTest() {
        return false;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return switch (this.type) {
            case Type.EXECUTE -> this.inferTypeExecute();
            case Type.INSTANTIATOR -> super.inferType();
            default -> throw new VilException("illegal strategy type " + String.valueOf((Object)this.type), 70000);
        };
    }

    private TypeDescriptor<?> inferTypeExecute() throws VilException {
        if (!this.execResolved) {
            TypeDescriptor<?> arg0Type;
            int a = 0;
            while (a < this.getArgumentsCount()) {
                this.getArgument(a).inferType();
                ++a;
            }
            if (this.getArgumentsCount() > 0 && ExecutableOperand.getExecutableType(arg0Type = this.getArgument(0).inferType()) == null) {
                throw new VilException("cannot execute system call on " + arg0Type.getName(), 70002);
            }
            this.execResolved = true;
        }
        return TypeRegistry.voidType();
    }

    @Override
    protected TypeDescriptor<?> determineOperand() throws VilException {
        TypeDescriptor<? extends IVilType> instantiator = this.typeRegistry.getInstantiator(this.getName());
        if (instantiator == null) {
            throw new VilException("unknown instantiator " + this.getName(), 70002);
        }
        return instantiator;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitStrategyCallExpression(this) : visitor.visitExpression(this);
        return result;
    }

    @Override
    public boolean isPlaceholder() {
        boolean isPlaceholder = Type.EXECUTE == this.type ? false : super.isPlaceholder();
        return isPlaceholder;
    }

    public static enum Type {
        INSTANTIATOR,
        EXECUTE;

    }
}

