/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch;

import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactTypes;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.ArtifactMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.BooleanMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.CollectionMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.CompoundMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.PathMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.StringMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;

public class MatchFactory {
    public static final MatchFactory INSTANCE = new MatchFactory();
    private static final TypeDescriptor<?> STRING = TypeRegistry.stringType();
    private static final TypeDescriptor<?> PATH = ArtifactTypes.pathType();
    private static final TypeDescriptor<?> ARTIFACT = ArtifactTypes.artifactType();
    private static final TypeDescriptor<?> BOOLEAN = TypeRegistry.booleanType();

    private MatchFactory() {
    }

    public AbstractRuleMatchExpression create(Expression expr) throws VilException {
        AbstractRuleMatchExpression result = null;
        TypeDescriptor<?> type = expr.inferType();
        if (IvmlTypes.decisionVariableType().isAssignableFrom(type)) {
            IMetaOperation convOp = TypeHelper.findConversion(type, TypeRegistry.booleanType());
            expr = new CallExpression((OperationDescriptor)convOp, new CallArgument(expr));
            type = expr.inferType();
        }
        if (STRING == type && expr instanceof ConstantExpression) {
            ConstantExpression cExpr = (ConstantExpression)expr;
            result = new StringMatchExpression(cExpr.getValue().toString());
        } else if (PATH.isAssignableFrom(type)) {
            result = new PathMatchExpression(expr);
        } else if (type.isCollection()) {
            result = new CollectionMatchExpression(expr);
        } else if (ARTIFACT.isAssignableFrom(type)) {
            result = new ArtifactMatchExpression(expr);
        } else if (expr instanceof AbstractRuleMatchExpression) {
            result = (AbstractRuleMatchExpression)expr;
        } else if (STRING == type && expr instanceof CompositeExpression) {
            result = new CompoundMatchExpression((CompositeExpression)expr);
        } else if (BOOLEAN == type) {
            result = new BooleanMatchExpression(expr);
        }
        return result;
    }
}

