/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.ICommandLineProgram;

public class CommandLineProgramRegistry {
    private static Map<String, ICommandLineProgram> programs = new HashMap<String, ICommandLineProgram>();

    public static void registerProgram(String name, ICommandLineProgram instance) {
        if (name != null && instance != null) {
            programs.put(name, instance);
        }
    }

    public static ICommandLineProgram getRegisteredProgram(String name) {
        return name != null ? programs.get(name) : null;
    }

    public static void unregisterProgram(String name) {
        if (name != null) {
            programs.remove(name);
        }
    }

    public static ICommandLineProgram obainCommandLineProgram(String className) {
        ICommandLineProgram result = null;
        try {
            Class<ICommandLineProgram> cls = Class.forName(className);
            if (cls.isAssignableFrom(ICommandLineProgram.class)) {
                Object inst = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (inst instanceof ICommandLineProgram) {
                    result = (ICommandLineProgram)inst;
                }
            } else {
                CommandLineProgramRegistry.getLogger().error(className + " is not instance of " + ICommandLineProgram.class.getName() + ". Cannot create command line program instance.");
            }
        }
        catch (ClassNotFoundException e) {
            CommandLineProgramRegistry.getLogger().warn(className + " cannot be found on classpath.");
        }
        catch (InstantiationException e) {
            CommandLineProgramRegistry.getLogger().exception((Exception)e);
        }
        catch (IllegalAccessException e) {
            CommandLineProgramRegistry.getLogger().exception((Exception)e);
        }
        catch (IllegalArgumentException e) {
            CommandLineProgramRegistry.getLogger().exception((Exception)e);
        }
        catch (InvocationTargetException e) {
            CommandLineProgramRegistry.getLogger().exception((Exception)e);
        }
        catch (NoSuchMethodException e) {
            CommandLineProgramRegistry.getLogger().warn(className + " does not have a public non-arg constructor.");
        }
        catch (SecurityException e) {
            CommandLineProgramRegistry.getLogger().exception((Exception)e);
        }
        return result;
    }

    private static EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(CommandLineProgramRegistry.class, "net.ssehub.easy.instantiation.core");
    }
}

