/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public abstract class ModelCallExpression<V extends IMetaParameterDeclaration, M extends IResolvableModel<V, M>, O extends IResolvableOperation<V>>
extends AbstractCallExpression
implements IArgumentProvider {
    protected O resolved;
    private M model;
    private CallArgument[] arguments;
    private boolean isSuper;

    protected ModelCallExpression() {
    }

    public ModelCallExpression(M model, boolean isSuper, String name, CallArgument ... arguments) throws VilException {
        super(name, true);
        this.model = model;
        this.isSuper = isSuper;
        this.arguments = arguments;
    }

    protected ModelCallExpression(M model, O resolved, CallArgument ... arguments) throws VilException {
        this(model, false, resolved.getName(), arguments);
        this.resolved = resolved;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    @Override
    public int getArgumentsCount() {
        return this.arguments == null ? 0 : this.arguments.length;
    }

    @Override
    public CallArgument getArgument(int index) {
        if (this.arguments == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.arguments[index];
    }

    public M getModel() {
        return this.model;
    }

    void setModel(M model) {
        if (model != null) {
            this.model = model;
        }
    }

    public O getResolved() {
        return this.resolved;
    }

    protected abstract Class<? extends O> getOperationClass();

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (this.resolved == null) {
            IMetaOperation op = ModelCallExpression.resolveOperation(this.model, true, this.getName(), this.arguments);
            Class<O> opClass = this.getOperationClass();
            if (opClass.isInstance(op)) {
                this.resolved = (IResolvableOperation)opClass.cast(op);
            } else {
                throw new VilException(this.getInvalidOperationMessage(op), 70002);
            }
        }
        return this.resolved.getReturnType();
    }

    protected String getInvalidOperationMessage(IMetaOperation op) {
        return op.getJavaSignature() + " is not a valid operation";
    }

    @Override
    public boolean isPlaceholder() {
        return ModelCallExpression.isPlaceholder(this.resolved);
    }

    @Override
    public String getVilSignature() {
        return this.getVilSignature((IMetaOperation)this.resolved);
    }

    public abstract boolean isVisible(M var1);
}

