/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ICallExpressionTester;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;

public abstract class Resolver<M extends IResolvableModel<V, M>, O extends IResolvableOperation<V>, E extends ModelCallExpression<V, M, O>, V extends IMetaParameterDeclaration>
extends net.ssehub.easy.instantiation.core.model.expressions.Resolver<V> {
    private Stack<M> models = new Stack();

    public Resolver(TypeRegistry registry) {
        super(registry);
    }

    public Resolver(IRuntimeEnvironment environment) {
        super(environment);
        RuntimeEnvironment rEnv;
        IResolvableModel model;
        if (environment instanceof RuntimeEnvironment && (model = (rEnv = (RuntimeEnvironment)environment).getContextModel()) != null) {
            this.models.push(model);
        }
    }

    public void pushModel(M model) {
        this.models.push(model);
        this.pushLevel();
        int p = 0;
        while (p < model.getParameterCount()) {
            this.add(model.getParameter(p));
            ++p;
        }
        int v = 0;
        while (v < model.getVariableDeclarationCount()) {
            Object varDecl = model.getVariableDeclaration(v);
            if (model.isImplicit(varDecl)) {
                this.add(varDecl, "");
            }
            ++v;
        }
    }

    public M getCurrentModel() {
        return (M)(this.models.isEmpty() ? null : (IResolvableModel)this.models.peek());
    }

    public void enumerateImports(M model) {
        String qualifier = model.getName() + "::";
        int v = 0;
        while (v < model.getVariableDeclarationCount()) {
            Object varDecl = model.getVariableDeclaration(v);
            if (!model.isImplicit(varDecl)) {
                this.add(varDecl, qualifier);
            }
            ++v;
        }
        this.addImportedVariables(model, "", new HashSet());
    }

    private void addImportedVariables(M model, String path, Set<M> done) {
        if (!done.contains(model)) {
            done.add(model);
            int i = 0;
            while (i < model.getImportsCount()) {
                ModelImport imp = model.getImport(i);
                if (imp.getResolved() != null) {
                    IResolvableModel m = (IResolvableModel)imp.getResolved();
                    String tmp = path + imp.getName() + "::";
                    int v = 0;
                    while (v < m.getVariableDeclarationCount()) {
                        Object varDecl = m.getVariableDeclaration(v);
                        if (!model.isImplicit(varDecl)) {
                            this.add(varDecl, tmp);
                        }
                        ++v;
                    }
                    this.addImportedVariables(m, tmp, done);
                }
                ++i;
            }
        }
    }

    public void popModel() {
        this.models.pop();
        this.popLevel();
    }

    protected abstract E createCallExpression(M var1, boolean var2, String var3, CallArgument ... var4) throws VilException;

    private M determineQualifiedModel(M model, String name) throws VilException {
        String remainderName;
        String modelName;
        IResolvableModel result = null;
        int pos = name.indexOf("::");
        if (pos > 0) {
            modelName = name.substring(0, pos);
            remainderName = name.substring(pos + "::".length(), name.length());
        } else {
            modelName = name;
            remainderName = "";
        }
        if (model.getName().equals(modelName)) {
            result = (IResolvableModel)this.determineQualifiedModel(model, remainderName);
        } else {
            int i = 0;
            while (result == null && i < model.getImportsCount()) {
                ModelImport imp = model.getImport(i);
                if (imp.getResolved() != null && imp.getName().equals(modelName)) {
                    IResolvableModel importedModel = (IResolvableModel)imp.getResolved();
                    result = remainderName.length() > 0 ? this.determineQualifiedModel(importedModel, remainderName) : importedModel;
                }
                ++i;
            }
        }
        return (M)result;
    }

    private M determineQualifiedModel(M model, boolean isSuper, String name) throws VilException {
        M result = null;
        int pos = name.lastIndexOf("::");
        if (pos > 0) {
            if (isSuper) {
                throw new VilException("qualified names cannot be used in super calls", 70002);
            }
            result = this.determineQualifiedModel(model, name.substring(0, pos));
            if (result == null) {
                throw new VilException("cannot resolve qualification in " + name, 70002);
            }
        }
        return result;
    }

    public E createCallExpression(boolean isSuper, String name, CallArgument ... arguments) throws VilException {
        return this.createCallExpression(isSuper, name, new CallExpressionTester(name, arguments), arguments);
    }

    public E createCallExpression(boolean isSuper, String name, ICallExpressionTester<M, O, E, V> tester, CallArgument ... arguments) throws VilException {
        E result = null;
        if (!this.models.isEmpty()) {
            IResolvableModel model = (IResolvableModel)this.models.peek();
            IResolvableModel qModel = this.determineQualifiedModel(model, isSuper, name);
            if (qModel != null) {
                result = tester.createAndCheckCall(qModel, false, model);
            }
            if (result == null) {
                if (!isSuper) {
                    result = tester.createAndCheckCall(model, isSuper, model);
                } else if (model.getParent() == null) {
                    throw new VilException("model is not extended, no super possible", 70002);
                }
                if (result == null) {
                    do {
                        if ((model = model.getParent()) == null) continue;
                        result = tester.createAndCheckCall(model, isSuper, model);
                    } while (model != null && result == null);
                }
            }
            int s = this.models.size() - 1;
            while (result == null && s >= 0) {
                IResolvableModel importedModel = (IResolvableModel)this.models.get(s);
                result = tester.createAndCheckCall(importedModel, false, model);
                int i = 0;
                while (result == null && i < importedModel.getImportsCount()) {
                    IResolvableModel imported = (IResolvableModel)importedModel.getImport(i).getResolved();
                    if (imported != null) {
                        result = tester.createAndCheckCall(imported, false, importedModel);
                    }
                    ++i;
                }
                --s;
            }
            if (result == null) {
                if (tester.getLastException() == null) {
                    throw new VilException("cannot resolve rule " + AbstractCallExpression.getSignature(name, arguments), 70002);
                }
                throw tester.getLastException();
            }
        } else {
            throw new VilException("model stack is empty", 70000);
        }
        return result;
    }

    public CallExpression createExtensionCallExpression(String name, CallArgument ... arguments) throws VilException {
        CallExpression result = null;
        if (!this.models.isEmpty()) {
            VilException lastException = null;
            IResolvableModel model = (IResolvableModel)this.models.peek();
            int t = 0;
            while (result == null && t < model.getExtensionTypesCount()) {
                IMetaType type = model.getExtensionType(t);
                try {
                    IMetaOperation op = AbstractCallExpression.resolveOperation(type, name, arguments);
                    if (op != null) {
                        result = new CallExpression(op, arguments);
                        result.inferType();
                    }
                }
                catch (VilException e) {
                    lastException = e;
                }
                ++t;
            }
            if (result == null && lastException != null) {
                throw lastException;
            }
        }
        return result;
    }

    @Override
    public Object getIvmlElement(String name) {
        Object result = null;
        int s = this.models.size() - 1;
        while (result == null && s >= 0) {
            result = ((IResolvableModel)this.models.get(s)).getIvmlElement(name);
            --s;
        }
        if (result == null && this.getRuntimeEnvironment() != null) {
            try {
                Object tmp = this.getRuntimeEnvironment().getIvmlValue(name);
                if (tmp instanceof IvmlElement) {
                    result = tmp;
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public TypeDescriptor<?> resolveType(String name) {
        TypeDescriptor<?> result = null;
        int s = this.models.size() - 1;
        while (result == null && s >= 0) {
            result = this.resolveType((IResolvableModel)this.models.get(s), name);
            --s;
        }
        return result;
    }

    private TypeDescriptor<?> resolveType(M model, String name) {
        Compound cmp;
        TypeDescriptor<?> result = null;
        Typedef td = model.getTypedef(name);
        if (td != null) {
            result = td.getType();
        }
        if ((cmp = model.getCompound(name)) != null) {
            result = cmp.getType();
        }
        int i = 0;
        int n = model.getImportsCount();
        while (result == null && i < n) {
            ModelImport imp = model.getImport(i);
            if (imp.getResolved() != null) {
                result = this.resolveType((IResolvableModel)imp.getResolved(), name);
            }
            ++i;
        }
        return result;
    }

    private class CallExpressionTester
    implements ICallExpressionTester<M, O, E, V> {
        private String name;
        private CallArgument[] arguments;
        private VilException lastException;

        CallExpressionTester(String name, CallArgument ... arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        @Override
        public E createAndCheckCall(M model, boolean isSuper, M fromModel) {
            Object result = null;
            try {
                Object tmp = Resolver.this.createCallExpression(model, isSuper, this.name, this.arguments);
                ((ModelCallExpression)tmp).inferType();
                if (!((ModelCallExpression)tmp).isVisible(fromModel)) {
                    this.lastException = new VilException(((ModelCallExpression)tmp).getResolved().getSignature() + " is not visible from " + fromModel.getName(), 30018);
                } else {
                    result = tmp;
                }
            }
            catch (VilException e) {
                this.lastException = e;
            }
            return result;
        }

        @Override
        public VilException getLastException() {
            return this.lastException;
        }
    }
}

