/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.defaultInstantiators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.Zip;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.ZipHandler;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

@Instantiator(value="unzip")
public class Unzip
implements IVilType {
    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> unzip(Path zip, Path target) throws VilException {
        return Unzip.unpack(zip, target, new ZipHandler());
    }

    @Invisible
    public static Set<FileArtifact> unpack(Path zip, Path target, ZipHandler handler) throws VilException {
        ArrayList<File> files = new ArrayList<File>();
        try {
            handler.unpack(zip.getAbsolutePath(), target.getAbsolutePath(), null, files);
        }
        catch (IOException e) {
            throw new VilException(e, 50001);
        }
        return Zip.toFileArtifactSet(files, target.getArtifactModel());
    }

    @Invisible
    public static Set<FileArtifact> unpack(Path zip, Path target, String pattern, ZipHandler handler) throws VilException {
        ArrayList<File> files = new ArrayList<File>();
        try {
            handler.unpack(zip.getAbsolutePath(), target.getAbsolutePath(), pattern, files);
        }
        catch (IOException e) {
            throw new VilException(e, 50001);
        }
        return Zip.toFileArtifactSet(files, target.getArtifactModel());
    }
}

