/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionIterator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class CompositeExpression
extends Expression
implements IExpressionIterator {
    private List<Expression> expressionList;

    CompositeExpression() {
    }

    public CompositeExpression(List<Expression> expressionList) {
        this.expressionList = expressionList;
    }

    public CompositeExpression(Expression ... expressions) {
        this.expressionList = new ArrayList<Expression>(expressions.length);
        int e = 0;
        while (e < expressions.length) {
            this.expressionList.add(expressions[e]);
            ++e;
        }
    }

    @Override
    public int getExpressionsCount() {
        return this.expressionList.size();
    }

    @Override
    public Expression getExpression(int index) {
        return this.expressionList.get(index);
    }

    public void setExpression(int index, Expression expr) {
        this.expressionList.set(index, expr);
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return TypeRegistry.stringType();
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitCompositeExpression(this);
    }
}

