/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionIterator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.expressions.ITracer;
import net.ssehub.easy.instantiation.core.model.expressions.MultiAndExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ParenthesisExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ValueAssignmentExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractListWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.varModel.model.values.NullValue;

public class EvaluationVisitor
implements IExpressionVisitor {
    private IRuntimeEnvironment environment;
    private ITracer tracer;

    public EvaluationVisitor(IRuntimeEnvironment environment, ITracer tracer) {
        this.environment = environment;
        this.tracer = tracer;
    }

    public IRuntimeEnvironment getRuntimeEnvironment() {
        return this.environment;
    }

    @Override
    public Object visitParenthesisExpression(ParenthesisExpression par) throws VilException {
        return par.getExpr().accept(this);
    }

    @Override
    public Object visitCallExpression(CallExpression call) throws VilException {
        return this.visitCall(call, call.getParent(), call.getResolved(), call.getCallType());
    }

    private Object visitCall(AbstractCallExpression call, Object parent, OperationDescriptor resolved, CallExpression.CallType type) throws VilException {
        Object result;
        HashMap<String, Object> named = null;
        boolean acceptsNamed = resolved.acceptsNamedParameters();
        if (acceptsNamed) {
            named = new HashMap<String, Object>();
            int p = 0;
            while (p < call.getArgumentsCount()) {
                CallArgument arg = call.getArgument(p);
                if (arg.hasName()) {
                    named.put(arg.getName(), arg.accept(this));
                }
                ++p;
            }
            if (parent != null && resolved.acceptsImplicitParameters()) {
                named.put("$parent", parent);
                named.put("$paths", this.environment.getContextPaths());
            }
            if (resolved.acceptsImplicitParameters()) {
                this.addImplicitParamters(named);
            }
        }
        int pCount = resolved.getParameterCount();
        if (acceptsNamed) {
            ++pCount;
        }
        Object[] args = new Object[pCount];
        int aCount = 0;
        HashMap<String, Object> namedArgs = null;
        int p = 0;
        while (p < call.getArgumentsCount()) {
            CallArgument arg = call.getArgument(p);
            if (!arg.hasName()) {
                args[aCount++] = arg.accept(this);
            } else {
                IMetaParameterDeclaration pDecl = resolved.getParameter(arg.getName());
                if (pDecl != null) {
                    if (namedArgs == null) {
                        namedArgs = new HashMap<String, Object>();
                    }
                    namedArgs.put(arg.getName(), arg.accept(this));
                }
            }
            ++p;
        }
        while (aCount < resolved.getParameterCount()) {
            Object val;
            IMetaParameterDeclaration pDecl = resolved.getParameter(aCount);
            Object object = val = namedArgs != null ? (Object)namedArgs.get(pDecl.getName()) : null;
            if (val == null && pDecl.getExpression() != null) {
                val = pDecl.getExpression().accept(this);
            }
            args[aCount++] = val;
        }
        if (acceptsNamed) {
            args[pCount - 1] = named;
        }
        resolved = AbstractCallExpression.dynamicDispatch(resolved, args, OperationDescriptor.class, this.environment.getTypeRegistry(), call, null);
        this.tracer.visitingCallExpression(resolved, type, args);
        if (resolved.storeArtifactsBeforeExecution()) {
            this.environment.storeArtifacts(true);
        }
        if ((result = resolved.invoke(args)) == null && call.inferType() == TypeRegistry.voidType()) {
            result = NullValue.VALUE;
        }
        this.tracer.visitedCallExpression(resolved, type, args, result);
        return result;
    }

    protected void addImplicitParamters(Map<String, Object> named) {
    }

    @Override
    public Object visitConstantExpression(ConstantExpression cst) throws VilException {
        return cst.getValue();
    }

    @Override
    public Object visitStringExpression(StringExpression ex) throws VilException {
        Object res = ex.getExpression().accept(this);
        if (res != null) {
            res = StringValueHelper.getStringValueInReplacement(res, null);
        }
        return res;
    }

    @Override
    public Object visitVarModelIdentifierExpression(VarModelIdentifierExpression identifier) throws VilException {
        return this.environment.getIvmlValue(identifier.getIdentifier());
    }

    @Override
    public Object visitVilTypeExpression(VilTypeExpression typeExpression) throws VilException {
        return typeExpression.getResolved();
    }

    @Override
    public Object visitVariableExpression(VariableExpression cst) throws VilException {
        return this.environment.getValue(cst.getDeclaration());
    }

    @Override
    public Object visitExpression(Expression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitExpressionEvaluator(ExpressionEvaluator ex) throws VilException {
        ex.bind(this);
        return ex;
    }

    @Override
    public Object visitValueAssignmentExpression(ValueAssignmentExpression ex) throws VilException {
        Boolean result;
        VariableDeclaration var = ex.getVarDecl();
        FieldDescriptor field = ex.getField();
        Object val = ex.getValueExpression().accept(this);
        if (val != null) {
            try {
                if (field != null) {
                    field.setValue(this.environment.getValue(var), val);
                } else {
                    this.environment.setValue(var, val);
                }
                this.notifyValueDefined(var, field, val);
                result = Boolean.TRUE;
            }
            catch (VilException e) {
                result = null;
                TracerFactory.createInstantiatorTracer().traceError(e.getMessage());
            }
        } else {
            result = null;
        }
        return result;
    }

    protected void notifyValueDefined(VariableDeclaration var, FieldDescriptor field, Object val) {
    }

    @Override
    public Object visitContainerInitializerExpression(ContainerInitializerExpression ex) throws VilException {
        TypeDescriptor<?>[] param;
        ArrayList<Object> data = new ArrayList<Object>();
        TypeDescriptor<?> type = ex.inferType();
        int e = 0;
        while (e < ex.getInitExpressionsCount()) {
            data.add(ex.getInitExpression(e).accept(this));
            ++e;
        }
        if (type.getGenericParameterCount() > 0) {
            param = TypeDescriptor.createArray(type.getGenericParameterCount());
            int p = 0;
            while (p < param.length) {
                param[p] = type.getGenericParameterType(p);
                ++p;
            }
        } else {
            param = TypeDescriptor.createArray(1);
            param[0] = type;
        }
        AbstractListWrapper result = type.isSet() ? new ListSet(data, param) : new ListSequence(data, param);
        return result;
    }

    @Override
    public Object visitCompositeExpression(CompositeExpression ex) throws VilException {
        return this.evaluateContentExpression(ex);
    }

    protected String evaluateContentExpression(IExpressionIterator iter) throws VilException {
        String result = "";
        Expression lastEx = null;
        Object lastValue = null;
        boolean replaceEmptyLine = false;
        int e = 0;
        while (e < iter.getExpressionsCount()) {
            Object value;
            Expression expression = iter.getExpression(e);
            try {
                value = expression.accept(this);
            }
            catch (VilException e1) {
                if (e1.getId() == 50000) {
                    result = null;
                    this.tracer.failedAt(expression);
                    break;
                }
                throw e1;
            }
            if (value != null) {
                String sValue = StringValueHelper.getStringValueInReplacement(value, null);
                if (replaceEmptyLine) {
                    char c;
                    int i = 0;
                    while (((c = sValue.charAt(i)) == '\r' || c == '\n') && ++i < sValue.length()) {
                    }
                    if (i > sValue.length()) {
                        sValue = null;
                    } else if (i > 0) {
                        sValue = sValue.substring(i);
                    }
                }
                if (sValue != null) {
                    result = this.appendInCompositeExpression(result, lastEx, lastValue, sValue, expression);
                }
            } else {
                result = null;
                break;
            }
            lastEx = expression;
            lastValue = value;
            replaceEmptyLine = this.lastContentReplaceEmptyLine() && lastValue != null && lastValue.toString().length() == 0;
            ++e;
        }
        return result;
    }

    protected boolean lastContentReplaceEmptyLine() {
        return false;
    }

    protected String appendInCompositeExpression(String s1, Expression e1, Object v1, String s2, Expression e2) {
        return s1 + s2;
    }

    @Override
    public Object visitFieldAccessExpression(FieldAccessExpression ex) throws VilException {
        Object result = null;
        try {
            Object ownerValue = ex.getVariable() != null ? this.environment.getValue(ex.getVariable()) : (ex.getNested() == null ? null : ex.getNested().accept(this));
            result = ex.isMetaAccess() ? ex.getField().getMetaValue(ownerValue) : ex.getField().getValue(ownerValue);
        }
        catch (VilException e) {
            TracerFactory.createInstantiatorTracer().traceError(e.getMessage());
        }
        return result;
    }

    @Override
    public Object visitResolvableOperationExpression(ResolvableOperationExpression ex) throws VilException {
        return ex.getOperation();
    }

    @Override
    public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
        Object result = null;
        Object val = this.environment.getValue(ex.getVariable());
        if (val instanceof OperationDescriptor) {
            result = this.visitCall(ex, null, (OperationDescriptor)val, CallExpression.CallType.NORMAL);
        } else if (val instanceof Expression) {
            result = ((Expression)val).accept(this);
        }
        return result;
    }

    @Override
    public Object visitMultiAndExpression(MultiAndExpression ex) throws VilException {
        Object result = Boolean.TRUE;
        int e = 0;
        while (Boolean.TRUE.equals(result) && e < ex.getExpressionCount()) {
            result = ex.getExpression(e).accept(this);
            ++e;
        }
        return result;
    }
}

