/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.EvaluationVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ExpressionEvaluator
extends Expression
implements IVilType,
IStringValueProvider {
    private EvaluationVisitor evaluationVisitor;
    private Expression expression;
    private VariableDeclaration iterator;
    private List<VariableDeclaration> declarators;

    public ExpressionEvaluator(Expression expression, VariableDeclaration iterator, List<? extends VariableDeclaration> declarators) {
        this.expression = expression;
        this.iterator = iterator;
        this.declarators = new ArrayList<VariableDeclaration>();
        if (declarators == null) {
            this.declarators.add(iterator);
        } else {
            int d = 0;
            while (d < declarators.size()) {
                this.declarators.add(declarators.get(d));
                ++d;
            }
        }
    }

    public int getDeclaratorsCount() {
        return this.declarators.size();
    }

    public VariableDeclaration getDeclarator(int index) {
        return this.declarators.get(index);
    }

    public TypeDescriptor<?> getResultType() {
        TypeDescriptor<?> result = null;
        VariableDeclaration resDecl = this.getResultDeclarator();
        if (resDecl != null) {
            result = resDecl.getType();
        }
        return result;
    }

    private VariableDeclaration getResultDeclarator() {
        VariableDeclaration decl;
        VariableDeclaration result = null;
        if (this.declarators.size() > 1 && (decl = this.declarators.get(0)).getExpression() != null) {
            result = decl;
        }
        return result;
    }

    public Object getResultValue() throws VilException {
        VariableDeclaration resDecl = this.getResultDeclarator();
        Object result = resDecl != null ? this.evaluationVisitor.getRuntimeEnvironment().getValue(resDecl) : null;
        return result;
    }

    public void bind(EvaluationVisitor evaluationVisitor) {
        this.evaluationVisitor = evaluationVisitor;
    }

    public void unbind() {
        this.evaluationVisitor = null;
    }

    public Object evaluate(Object iteratorValue) throws VilException {
        if (this.expression == null) {
            throw new VilException("cannot evaluate null", 70000);
        }
        this.evaluationVisitor.getRuntimeEnvironment().setValue(this.iterator, iteratorValue);
        return this.expression.accept(this.evaluationVisitor);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public VariableDeclaration getIteratorVariable() {
        return this.iterator;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return TypeRegistry.DEFAULT.getType(ExpressionEvaluator.class);
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitExpressionEvaluator(this);
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "<evaluator>";
    }

    public void initializeDeclarators() throws VilException {
        int d = 0;
        while (d < this.declarators.size()) {
            VariableDeclaration decl = this.declarators.get(d);
            if (decl.getExpression() != null) {
                this.evaluationVisitor.getRuntimeEnvironment().setValue(decl, decl.getExpression().accept(this.evaluationVisitor));
            }
            ++d;
        }
    }
}

