/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.io.Writer;
import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangWriter;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractWriter;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionIterator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.MultiAndExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ParenthesisExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ValueAssignmentExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableEx;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;

public class ExpressionWriter
extends AbstractWriter
implements IExpressionVisitor {
    private static boolean oclCompliance = false;
    private transient Stack<CompositeExpression> compositeExpressions = new Stack();
    private transient boolean isInContent = false;
    private transient boolean isInExpression = false;

    public ExpressionWriter(Writer out) {
        super(out);
    }

    public static void setOclCompliance(boolean compliance) {
        oclCompliance = compliance;
    }

    public static boolean considerOclCompliance() {
        return oclCompliance;
    }

    @Override
    public Object visitParenthesisExpression(ParenthesisExpression par) throws VilException {
        this.print("(");
        par.getExpr().accept(this);
        this.print(")");
        return null;
    }

    private void printName(CallExpression call) {
        if (call.getPrefix() != null) {
            this.print(call.getPrefix());
            this.print("::");
        }
        this.print(call.getName());
    }

    protected void printType(TypeDescriptor<?> type) {
        this.print(type.getVilName());
    }

    private void printIteratorDeclarators(CallExpression call) throws VilException {
        if (call.isIteratorCall()) {
            ExpressionEvaluator eval = (ExpressionEvaluator)call.getArgument(1).getExpression();
            int done = 0;
            int d = 0;
            while (d < eval.getDeclaratorsCount()) {
                VariableDeclaration decl = eval.getDeclarator(d);
                if (!decl.isImplicit()) {
                    if (d > 0) {
                        if (decl.hasExplicitType()) {
                            this.print(";");
                        } else {
                            this.print(",");
                        }
                        this.printWhitespace();
                    }
                    if (decl.hasExplicitType()) {
                        this.printType(decl.getType());
                        this.printWhitespace();
                    }
                    this.print(decl.getName());
                    this.printWhitespace();
                    if (decl.getExpression() != null) {
                        this.print("=");
                        this.printWhitespace();
                        decl.getExpression().accept(this);
                    }
                    ++done;
                }
                ++d;
            }
            if (done > 0) {
                this.print("|");
                this.printWhitespace();
            }
        }
    }

    @Override
    public Object visitCallExpression(CallExpression call) throws VilException {
        CallExpression.CallType cType = call.getCallType();
        if (CallExpression.CallType.TRANSPARENT != cType) {
            OperationDescriptor desc = call.getResolved();
            switch (desc.getOperationType()) {
                case INFIX: {
                    call.getArgument(0).accept(this);
                    this.printWhitespace();
                    this.printName(call);
                    this.printWhitespace();
                    call.getArgument(1).accept(this);
                    break;
                }
                case NORMAL: {
                    if ("[]".equals(desc.getName())) {
                        call.getArgument(0).accept(this);
                        this.print("[");
                        this.printArguments(call, 1);
                        this.print("]");
                        break;
                    }
                    if (desc.isConstructor()) {
                        this.print("new ");
                        this.print(((TypeDescriptor)desc.getDeclaringType()).getName());
                        this.printArgumentList(call, 0);
                        break;
                    }
                    if (CallExpression.CallType.EXTERNAL == cType) {
                        this.printName(call);
                        this.printArgumentList(call, 0);
                        break;
                    }
                    call.getArgument(0).accept(this);
                    this.printCallAccess(call);
                    this.printName(call);
                    this.print("(");
                    this.printIteratorDeclarators(call);
                    this.printArguments(call, 1);
                    this.print(")");
                    break;
                }
                case POSTFIX: {
                    if (call.getArgumentsCount() > 1) {
                        this.printArgumentList(call, 0);
                    } else {
                        this.printArguments(call, 0);
                    }
                    this.printName(call);
                    break;
                }
                case PREFIX: {
                    this.printName(call);
                    if (call.getArgumentsCount() > 1) {
                        this.printArgumentList(call, 0);
                        break;
                    }
                    this.printArguments(call, 0);
                    break;
                }
                case FUNCTION: {
                    this.printName(call);
                    this.printArgumentList(call, 0);
                    break;
                }
            }
        } else if (call.getArgumentsCount() > 0) {
            call.getArgument(0).accept(this);
        }
        return null;
    }

    private void printCallAccess(CallExpression call) throws VilException {
        if (call.isIteratorCall()) {
            this.print("->");
        } else if (ExpressionWriter.considerOclCompliance() && call.getArgument(0).inferType().isCollection()) {
            this.print("->");
        } else {
            this.print(".");
        }
    }

    protected void printArguments(IArgumentProvider provider, int start) throws VilException {
        int a = start;
        while (a < provider.getArgumentsCount()) {
            CallArgument arg;
            if (a > start) {
                this.print(", ");
            }
            if ((arg = provider.getArgument(a)).hasName()) {
                this.print(arg.getName());
                this.print("=");
            }
            provider.getArgument(a).accept(this);
            ++a;
        }
    }

    protected void printArgumentList(IArgumentProvider provider, int start) throws VilException {
        this.print("(");
        this.printArguments(provider, start);
        this.print(")");
    }

    @Override
    public Object visitStringExpression(StringExpression ex) throws VilException {
        if (this.isInContent) {
            this.print("\"");
        }
        this.print("$");
        if (ex.isNested()) {
            this.print("{");
        }
        ex.getExpression().accept(this);
        if (ex.isNested()) {
            this.print("}");
        }
        if (this.isInContent) {
            this.print("\"");
        }
        return null;
    }

    @Override
    public Object visitConstantExpression(ConstantExpression cst) throws VilException {
        Object value = cst.getValue();
        if (value instanceof EnumValue) {
            EnumValue eValue = (EnumValue)value;
            this.print(eValue.getTypeName());
            if (ExpressionWriter.considerOclCompliance()) {
                this.print("::");
            } else {
                this.print(".");
            }
            this.print(eValue.getName());
        } else if (value instanceof String) {
            boolean isInComposite = this.isInComposite();
            if (isInComposite && this.isInContent) {
                String tmp = (String)value;
                tmp = tmp.replace("\\", "\\\\");
                tmp = tmp.replaceAll("'", "\\\\'");
                this.print(tmp);
            } else {
                this.printJavaEscaped((String)value);
            }
        } else if (value instanceof Version) {
            this.print("v");
            this.print(value);
        } else if (value == TypeRegistry.NULL) {
            this.print("null");
        } else {
            this.print(value);
        }
        return null;
    }

    @Override
    public Object visitVarModelIdentifierExpression(VarModelIdentifierExpression identifier) throws VilException {
        this.print(identifier.getIdentifier());
        return null;
    }

    @Override
    public Object visitVilTypeExpression(VilTypeExpression typeExpression) throws VilException {
        this.print(typeExpression.getIdentifier());
        return null;
    }

    @Override
    public Object visitExpression(Expression ex) throws VilException {
        EASyLoggerFactory.INSTANCE.getLogger(BuildlangWriter.class, "net.ssehub.easy.instantiation.core").warn("unspecific expression visit: " + String.valueOf(ex));
        return null;
    }

    @Override
    public Object visitExpressionEvaluator(ExpressionEvaluator ex) throws VilException {
        return ex.getExpression().accept(this);
    }

    @Override
    public Object visitVariableExpression(VariableExpression cst) throws VilException {
        String name = cst.getQualifiedName();
        if (name == null) {
            name = cst.getDeclaration().getName();
        }
        this.print(name);
        return null;
    }

    @Override
    public Object visitFieldAccessExpression(FieldAccessExpression ex) throws VilException {
        if (ex.getVariable() != null) {
            this.print(ex.getVariable().getName());
            this.print(".");
            this.print(ex.getField().getName());
        } else {
            if (ex.getNested() == null) {
                this.print(ex.getField().getDeclaringType().getName());
            } else {
                ex.getNested().accept(this);
            }
            this.print(".");
            this.print(ex.getField().getName());
        }
        return null;
    }

    @Override
    public Object visitValueAssignmentExpression(ValueAssignmentExpression ex) throws VilException {
        this.print(ex.getVarDecl().getName());
        FieldDescriptor fd = ex.getField();
        if (fd != null) {
            this.print(".");
            this.print(fd.getName());
        }
        this.print(" = ");
        ex.getValueExpression().accept(this);
        return null;
    }

    @Override
    public Object visitContainerInitializerExpression(ContainerInitializerExpression ex) throws VilException {
        if (!ex.isImplicit()) {
            this.print("{");
        }
        int e = 0;
        while (e < ex.getInitExpressionsCount()) {
            if (e > 0) {
                this.print(", ");
            }
            ex.getInitExpression(e).accept(this);
            ++e;
        }
        if (!ex.isImplicit()) {
            this.print("}");
        }
        return null;
    }

    @Override
    public Object visitCompositeExpression(CompositeExpression ex) throws VilException {
        this.compositeExpressions.push(ex);
        if (!this.isInContent) {
            this.print("\"");
        }
        this.printContentExpressions(ex);
        if (!this.isInContent) {
            this.print("\"");
        }
        this.compositeExpressions.pop();
        return null;
    }

    protected void printContentExpressions(IExpressionIterator iter) throws VilException {
        int e = 0;
        while (e < iter.getExpressionsCount()) {
            Expression expression = iter.getExpression(e);
            if (expression instanceof VariableExpression && !(expression instanceof VariableEx)) {
                this.print("$");
                expression.accept(this);
            } else if (expression instanceof ConstantExpression) {
                if (this.isInExpression) {
                    this.print("\"");
                }
                expression.accept(this);
                if (this.isInExpression) {
                    this.print("\"");
                }
            } else {
                boolean quote;
                boolean before = this.isInExpression;
                this.isInExpression = quote = this.quoteExpression(expression) && !(expression instanceof StringExpression);
                if (quote) {
                    this.print("${");
                }
                expression.accept(this);
                if (expression.getFormattingHint() != null) {
                    this.print("|");
                    this.print(expression.getFormattingHint());
                }
                if (quote) {
                    this.print("}");
                }
                this.isInExpression = before;
            }
            ++e;
        }
    }

    protected boolean quoteExpression(Expression expression) {
        return true;
    }

    @Override
    public Object visitResolvableOperationExpression(ResolvableOperationExpression ex) throws VilException {
        this.print(ex.getOperation().getName());
        return null;
    }

    @Override
    public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
        this.print(ex.getVariable().getName());
        this.printArgumentList(ex, 0);
        return null;
    }

    @Override
    public Object visitMultiAndExpression(MultiAndExpression ex) throws VilException {
        int e = 0;
        while (e < ex.getExpressionCount()) {
            AbstractCallExpression expr = ex.getExpression(e);
            if (expr.getArgumentsCount() > 0) {
                if (e == 0) {
                    expr.getArgument(0).accept(this);
                }
                int a = 1;
                while (a < expr.getArgumentsCount()) {
                    this.printWhitespace();
                    this.print(expr.getName());
                    this.printWhitespace();
                    expr.getArgument(a).accept(this);
                    ++a;
                }
            }
            ++e;
        }
        return null;
    }

    protected boolean isInComposite() {
        return this.compositeExpressions.size() > 0;
    }

    protected boolean isInContent() {
        return this.isInContent;
    }

    protected void setInContent(boolean isInContent) {
        this.isInContent = isInContent;
    }
}

