/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.dslCore.translation.IMessageReceiver;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.IResolver;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class Resolver<V extends IResolvable>
implements IResolver<V> {
    private Stack<Level<V>> levels = new Stack();
    private IRuntimeEnvironment environment;
    private TypeRegistry registry;

    public Resolver(TypeRegistry registry) {
        this.registry = registry;
        this.pushLevel();
    }

    public Resolver(IRuntimeEnvironment environment) {
        this(environment.getTypeRegistry());
        this.environment = environment;
    }

    public IRuntimeEnvironment getRuntimeEnvironment() {
        return this.environment;
    }

    public TypeRegistry getTypeRegistry() {
        return this.registry;
    }

    @Override
    public V resolve(String name, boolean local) {
        return this.resolve(name, local, null, null, null);
    }

    public V resolve(String name, boolean local, EObject cause, EStructuralFeature causeFeature, IMessageReceiver receiver) {
        IResolvable result = null;
        if (this.environment != null) {
            result = this.environment.get(name);
        }
        boolean limited = false;
        int l = this.levels.size() - 1;
        while (result == null && l >= 0) {
            Level level = (Level)this.levels.get(l);
            result = level.get(name);
            if (limited && result != null && receiver != null) {
                receiver.warning("discouraged scope access to variable '" + name + "'", cause, causeFeature, 20214);
            }
            if (local) break;
            if (result == null && level.isLimited()) {
                limited = true;
            }
            --l;
        }
        return (V)result;
    }

    public IContextType getContextType() {
        return this.levels.peek().getContextType();
    }

    public void setContextType(IContextType context) {
        this.levels.peek().setContextType(context);
    }

    public void add(V decl) {
        this.add(decl, "");
    }

    public void remove(V decl) {
        this.remove(decl, "");
    }

    public void addAlias(String name, V decl) {
        Level<V> level = this.levels.peek();
        if (level.get(name) == null) {
            level.put(name, decl);
        }
    }

    protected void add(V decl, String qualification) {
        Level<V> level = this.levels.peek();
        level.put(qualification + decl.getName(), decl);
    }

    protected void remove(V decl, String qualification) {
        Level<V> level = this.levels.peek();
        level.remove(qualification + decl.getName());
    }

    public void limitVariablesOnCurrentLevel() {
        this.levels.peek().limitVariables();
    }

    public boolean contains(V decl) {
        return this.contains(decl.getName());
    }

    public boolean contains(String name) {
        boolean contains = false;
        int l = this.levels.size() - 1;
        while (!contains && l >= 0) {
            contains = ((Level)this.levels.get(l)).contains(name);
            --l;
        }
        return contains;
    }

    public void add(V[] decls) {
        if (decls != null) {
            int v = 0;
            while (v < decls.length) {
                this.add(decls[v]);
                ++v;
            }
        }
    }

    public void add(List<V> decls) {
        if (decls != null) {
            int v = 0;
            while (v < decls.size()) {
                this.add((IResolvable)decls.get(v));
                ++v;
            }
        }
    }

    protected abstract IContextType getDefaultType();

    public void pushLevel() {
        IContextType type = this.levels.isEmpty() ? this.getDefaultType() : this.levels.peek().getContextType();
        this.levels.push(new Level(type));
    }

    public void popLevel() {
        if (this.levels.size() > 1) {
            this.levels.pop();
        }
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    @Override
    public Object getIvmlElement(String name) {
        return null;
    }

    public IModel getCurrentModel() {
        return null;
    }

    public TypeDescriptor<?> resolveType(String name) {
        return null;
    }

    protected static interface IContextType {
    }

    private static class Level<V extends IResolvable> {
        private Map<String, V> variables = new HashMap<String, V>();
        private IContextType context;
        private boolean limit = false;

        public Level(IContextType context) {
            this.setContextType(context);
        }

        public void put(String name, V var) {
            this.variables.put(name, var);
        }

        public void remove(String name) {
            this.variables.remove(name);
        }

        public boolean contains(String name) {
            return this.variables.containsKey(name);
        }

        public V get(String name) {
            return (V)((IResolvable)this.variables.get(name));
        }

        public void setContextType(IContextType context) {
            this.context = context;
        }

        public IContextType getContextType() {
            return this.context;
        }

        public void limitVariables() {
            this.limit = true;
        }

        public boolean isLimited() {
            return this.limit;
        }
    }
}

