/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;

public class ContentFormatter {
    private static final Map<String, Profile> PROFILES = new HashMap<String, Profile>();
    private Profile profile;
    private FormattingConfiguration fConf;
    private IndentationConfiguration iConf;
    private boolean lastLineEmpty = false;

    static {
        PROFILES.put("JAVA", new JavaProfile());
        PROFILES.put("JSON", new DefaultProfile());
        PROFILES.put("YAML", new DefaultProfile());
        PROFILES.put("PYTHON", new PythonProfile());
        PROFILES.put("", new DefaultProfile());
    }

    private Profile determineProfile() {
        Profile result = this.profile;
        if (result == null) {
            String profileName = this.fConf.getProfile();
            profileName = profileName != null ? profileName.toUpperCase().trim() : "";
            result = PROFILES.get(profileName);
            if (result == null) {
                result = PROFILES.get("");
            }
            this.profile = result = result.createInstance();
        }
        result.configure(this.fConf);
        return result;
    }

    public void setFormattingConfiguration(FormattingConfiguration fConf) {
        this.fConf = fConf;
    }

    public void setIndentationConfiguration(IndentationConfiguration iConf) {
        this.iConf = iConf;
        this.profile = null;
    }

    private static boolean isFormatterConfigEnabled(FormattingConfiguration fConf) {
        return fConf.getLineLength() > 0 || fConf.getProfile() != null && fConf.getProfile().length() > 0;
    }

    public String format(String content) {
        String result = content;
        if (this.iConf != null && this.fConf != null && ContentFormatter.isFormatterConfigEnabled(this.fConf)) {
            this.determineProfile();
            if (this.profile.removeMultiEmptyLines()) {
                if (result.trim().length() == 0) {
                    if (this.lastLineEmpty) {
                        result = null;
                    } else {
                        this.lastLineEmpty = true;
                    }
                } else {
                    this.lastLineEmpty = false;
                }
            }
            if (result != null) {
                StringBuilder bld = new StringBuilder(result);
                if (this.profile.removeMultiEmptyLines()) {
                    this.removeMulipleEmptyLines(bld);
                }
                this.splitLines(bld);
                result = bld.toString();
            }
        }
        if (this.fConf != null && result != null) {
            String lineBreak = this.fConf.getLineEnding();
            if (lineBreak != null) {
                if (lineBreak.equals("\n")) {
                    result = result.replace("\r\n", lineBreak);
                } else if (lineBreak.equals("\r\n")) {
                    result = result.replaceAll("([^\r])\n", "$1" + lineBreak);
                }
            }
            if (this.fConf.getCharset() != null) {
                result = new String(result.getBytes(), this.fConf.getCharset());
            }
        }
        return result;
    }

    private void removeMulipleEmptyLines(StringBuilder bld) {
        int pos = 0;
        int lastNewLinePos = 0;
        int lastNonWsPos = -1;
        boolean lastEmpty = false;
        while (pos < bld.length()) {
            int posAdjust = 1;
            int c = bld.charAt(pos);
            if (!ContentFormatter.isNewline((char)c) && !Character.isWhitespace((char)c)) {
                lastNonWsPos = pos;
            }
            if (ContentFormatter.isCrNl(bld, pos)) {
                ++pos;
                c = 10;
            }
            if (ContentFormatter.isNewline((char)c)) {
                if (lastNonWsPos < 0) {
                    if (lastEmpty) {
                        bld.delete(lastNewLinePos, pos + 1);
                        posAdjust = -(pos - lastNewLinePos);
                    } else {
                        lastEmpty = true;
                    }
                } else {
                    lastEmpty = false;
                }
                lastNewLinePos = pos + posAdjust;
                lastNonWsPos = -1;
            }
            pos += posAdjust;
        }
    }

    private char nextChar(StringBuilder builder, int pos) {
        return pos + 1 < builder.length() ? builder.charAt(pos + 1) : (char)'\u0000';
    }

    private void splitLines(StringBuilder builder) {
        int maxLineLength = this.profile.getLineLength(this.fConf);
        int pos = 0;
        int lastStartPos = 0;
        int lastSplitPos = 0;
        int lastNlPos = 0;
        int doubleChars = 0;
        while (pos < builder.length()) {
            int advance = 0;
            char c = builder.charAt(pos);
            this.profile.processingChar(c, pos);
            if (ContentFormatter.isCrNl(builder, pos)) {
                ++pos;
                c = '\n';
                ++doubleChars;
            }
            if (this.canSplit(c, this.nextChar(builder, pos))) {
                boolean split;
                int count = pos - doubleChars - lastStartPos + 1;
                boolean bl = split = count >= maxLineLength;
                if (!split) {
                    int nPos = pos + 1;
                    while (nPos < builder.length() && !this.canSplit(builder.charAt(nPos), this.nextChar(builder, nPos))) {
                        ++nPos;
                    }
                    boolean bl2 = split = nPos > pos + 1 && nPos - doubleChars - lastStartPos - 1 > maxLineLength;
                }
                if (split) {
                    int adv = this.splitLines(c, builder, pos, lastNlPos);
                    if (adv > 0) {
                        lastStartPos = lastSplitPos;
                        lastSplitPos = pos + (advance += adv);
                    } else {
                        split = false;
                    }
                }
                if (!split) {
                    lastSplitPos = pos;
                    if (ContentFormatter.isNewline(c)) {
                        lastStartPos = pos;
                    }
                }
                if (ContentFormatter.isNewline(c)) {
                    lastNlPos = pos;
                    doubleChars = 0;
                }
            }
            pos += advance == 0 ? 1 : advance;
        }
    }

    private boolean canSplit(char ch, char nextChar) {
        return ContentFormatter.isNewline(ch) || ch == ' ' || this.profile.isSplitChar(ch, nextChar);
    }

    private int splitLines(char ch, StringBuilder buffer, int splitPos, int startPos) {
        int result = 0;
        if (!ContentFormatter.isNewline(ch)) {
            String lineBreak = FormattingConfiguration.getLineEnding(this.fConf);
            int indentStep = this.iConf.getIndentationStep();
            Object ins = "";
            char nextCh = this.nextChar(buffer, splitPos);
            if (this.profile.enableSplit(ch, nextCh)) {
                if (!this.profile.isSplitChar(ch, nextCh)) {
                    buffer.delete(splitPos, splitPos + 1);
                } else {
                    ++splitPos;
                    ++result;
                }
                ins = (String)ins + this.profile.addBeforeSplit(ch) + lineBreak + this.adjustIndentation(buffer, startPos, indentStep) + this.profile.addAfterSplit(ch);
                int adjustSplitPos = this.profile.adjustSplitPosition(ch);
                buffer.insert(splitPos + adjustSplitPos, (String)ins);
                result += ((String)ins).length() - adjustSplitPos;
            }
        }
        return result;
    }

    private static boolean isCrNl(StringBuilder bld, int pos) {
        return bld.charAt(pos) == '\r' && pos + 1 < bld.length() && bld.charAt(pos + 1) == '\n';
    }

    private static boolean isNewline(char ch) {
        return ch == '\r' || ch == '\n';
    }

    private String adjustIndentation(StringBuilder string, int lastStart, int indentStep) {
        Object result = "";
        if (this.profile.adjustIndentation() && indentStep > 0 && lastStart >= 0) {
            while (lastStart < string.length() && ContentFormatter.isNewline(string.charAt(lastStart))) {
                ++lastStart;
            }
            int pos = lastStart;
            while (pos < string.length() && string.charAt(pos) == ' ') {
                ++pos;
            }
            int indent = (pos - lastStart) / indentStep;
            if (this.profile.enableIndentation(indent)) {
                indent += this.profile.additionalIndent();
                int i = 1;
                while (i <= indent) {
                    int j = 1;
                    while (j <= indentStep) {
                        result = (String)result + " ";
                        ++j;
                    }
                    ++i;
                }
            }
            result = (String)result + this.profile.addToIndent();
        }
        return result;
    }

    public void reset() {
        if (this.profile != null) {
            this.profile.reset();
        }
        this.lastLineEmpty = false;
    }

    public static class DefaultProfile
    implements Profile {
        @Override
        public boolean adjustIndentation() {
            return false;
        }

        @Override
        public int additionalIndent() {
            return 0;
        }

        @Override
        public boolean enableIndentation(int indent) {
            return indent > 0;
        }

        @Override
        public String addToIndent() {
            return "";
        }

        @Override
        public boolean isSplitChar(char ch, char nextChar) {
            return false;
        }

        @Override
        public int adjustSplitPosition(char ch) {
            return 0;
        }

        @Override
        public String addBeforeSplit(char ch) {
            return "";
        }

        @Override
        public String addAfterSplit(char ch) {
            return "";
        }

        @Override
        public void processingChar(char ch, int pos) {
        }

        @Override
        public boolean removeMultiEmptyLines() {
            return false;
        }

        @Override
        public Profile createInstance() {
            return new DefaultProfile();
        }

        @Override
        public void reset() {
        }

        @Override
        public void configure(FormattingConfiguration fConfig) {
        }
    }

    public static class JavaProfile
    implements Profile {
        private State state;
        private String javadocIndent = " * ";
        private Set<String> noSplit2Chars = new HashSet<String>();

        public JavaProfile() {
            this.reset();
            this.noSplit2Chars.add("==");
            this.noSplit2Chars.add("!=");
            this.noSplit2Chars.add("<=");
            this.noSplit2Chars.add(">=");
            this.noSplit2Chars.add("->");
            this.noSplit2Chars.add("|=");
            this.noSplit2Chars.add("&=");
            this.noSplit2Chars.add("%=");
            this.noSplit2Chars.add("^=");
            this.noSplit2Chars.add("-=");
            this.noSplit2Chars.add("+=");
            this.noSplit2Chars.add("*=");
            this.noSplit2Chars.add("/=");
            this.noSplit2Chars.add("++");
            this.noSplit2Chars.add("--");
            this.noSplit2Chars.add("\"\"");
            this.noSplit2Chars.add(">>");
            this.noSplit2Chars.add("<<");
            this.noSplit2Chars.add("..");
        }

        @Override
        public void reset() {
            this.state = State.CODE;
        }

        @Override
        public Profile createInstance() {
            JavaProfile result = new JavaProfile();
            result.javadocIndent = this.javadocIndent;
            return result;
        }

        @Override
        public boolean adjustIndentation() {
            return true;
        }

        @Override
        public boolean enableIndentation(int indent) {
            return State.CODE == this.state ? indent >= 0 : indent > 0;
        }

        @Override
        public int additionalIndent() {
            int result = 0;
            if (State.CODE == this.state || State.STRING_START == this.state || State.STRING == this.state) {
                result = 1;
            }
            return result;
        }

        @Override
        public boolean enableSplit(char ch, char nextCh) {
            boolean result = true;
            if ((State.STRING == this.state || State.STRING_START == this.state) && nextCh == '\"') {
                result = false;
            }
            return result;
        }

        @Override
        public String addToIndent() {
            String result = "";
            if (State.ML_COMMENT_JAVADOC == this.state) {
                result = this.javadocIndent;
            } else if (State.SL_COMMENT == this.state) {
                result = "// ";
            }
            return result;
        }

        @Override
        public boolean isSplitChar(char ch, char nextChar) {
            boolean result = false;
            if (State.CODE == this.state) {
                result = ch == '.' || ch == '\"' || ch == '(';
                result |= ch == '+' || ch == '-' || ch == '/';
                result |= ch == '*' || ch == '[';
                result &= !this.noSplit2Chars.contains(String.valueOf(ch) + nextChar);
            } else if (State.STRING_START == this.state) {
                result = ch == '\"';
            } else if (State.STRING == this.state) {
                result = true;
            }
            return result;
        }

        @Override
        public int adjustSplitPosition(char ch) {
            int result = 0;
            if (State.STRING_START == this.state) {
                result = -1;
            }
            return result;
        }

        @Override
        public String addBeforeSplit(char ch) {
            String result = "";
            if (State.STRING == this.state && ch != '\"') {
                result = "\"";
            }
            return result;
        }

        @Override
        public String addAfterSplit(char ch) {
            String result = "";
            if (State.STRING == this.state && ch != '\"') {
                result = "+ \"";
            }
            return result;
        }

        @Override
        public void processingChar(char ch, int pos) {
            State before = this.state;
            if ('/' == ch) {
                if (State.CODE == this.state) {
                    this.state = State.SLASH;
                } else if (State.SLASH == this.state) {
                    this.state = State.SL_COMMENT;
                } else if (State.ML_COMMENT_STAR == this.state) {
                    this.state = State.CODE;
                } else if (State.ML_COMMENT_JAVADOC_STAR == this.state) {
                    this.state = State.CODE;
                }
            } else if ('\\' == ch) {
                if (State.STRING == this.state) {
                    this.state = State.STRING_ESCAPE;
                }
            } else if ('*' == ch) {
                if (State.SLASH == this.state) {
                    this.state = State.ML_COMMENT_1;
                } else if (State.ML_COMMENT_1 == this.state) {
                    this.state = State.ML_COMMENT_JAVADOC;
                } else if (State.ML_COMMENT == this.state) {
                    this.state = State.ML_COMMENT_STAR;
                } else if (State.ML_COMMENT_JAVADOC == this.state) {
                    this.state = State.ML_COMMENT_JAVADOC_STAR;
                }
            } else if (ContentFormatter.isNewline(ch)) {
                if (this.state == State.SL_COMMENT) {
                    this.state = State.CODE;
                }
            } else if ('\"' == ch) {
                if (State.CODE == this.state) {
                    this.state = State.STRING_START;
                } else if (State.STRING_START == this.state || State.STRING == this.state) {
                    this.state = State.CODE;
                }
            }
            if (this.state == before) {
                if (State.SLASH == this.state) {
                    this.state = State.CODE;
                } else if (State.ML_COMMENT_STAR == this.state) {
                    this.state = State.ML_COMMENT;
                } else if (State.ML_COMMENT_JAVADOC_STAR == this.state) {
                    this.state = State.ML_COMMENT_JAVADOC;
                } else if (State.ML_COMMENT_1 == this.state) {
                    this.state = State.ML_COMMENT;
                } else if (State.STRING_ESCAPE == this.state || State.STRING_START == this.state) {
                    this.state = State.STRING;
                }
            }
        }

        @Override
        public boolean removeMultiEmptyLines() {
            return true;
        }

        @Override
        public void configure(FormattingConfiguration fConfig) {
            String arg = fConfig.getProfileArgument("javadocIndent");
            if (arg != null) {
                this.javadocIndent = arg;
            }
        }

        private static enum State {
            CODE,
            SLASH,
            STRING_START,
            STRING,
            STRING_ESCAPE,
            ML_COMMENT,
            ML_COMMENT_1,
            ML_COMMENT_JAVADOC,
            ML_COMMENT_STAR,
            ML_COMMENT_JAVADOC_STAR,
            SL_COMMENT;

        }
    }

    public static interface Profile {
        public boolean adjustIndentation();

        public boolean enableIndentation(int var1);

        public int additionalIndent();

        public String addToIndent();

        public boolean isSplitChar(char var1, char var2);

        public int adjustSplitPosition(char var1);

        default public boolean enableSplit(char ch, char nextCh) {
            return true;
        }

        public String addBeforeSplit(char var1);

        public String addAfterSplit(char var1);

        public void processingChar(char var1, int var2);

        public boolean removeMultiEmptyLines();

        public Profile createInstance();

        public void reset();

        public void configure(FormattingConfiguration var1);

        default public int getLineLength(FormattingConfiguration fConfig) {
            return fConfig == null ? 80 : fConfig.getLineLength();
        }
    }

    public static class PythonProfile
    extends DefaultProfile {
        @Override
        public int getLineLength(FormattingConfiguration fConfig) {
            return Integer.MAX_VALUE;
        }

        @Override
        public Profile createInstance() {
            return new PythonProfile();
        }
    }
}

