/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.List;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;

public class Def
extends TemplateBlock
implements ITemplateLangElement,
IResolvableOperation<VariableDeclaration>,
IStringValueProvider {
    private Template parent;
    private String name;
    private VariableDeclaration[] param;
    private Map<String, VariableDeclaration> namedParam;
    private TypeDescriptor<?> specifiedType;
    private boolean isProtected = false;
    private String[] annotations;

    public Def() {
        super(null);
    }

    public Def(String name, VariableDeclaration[] param, ITemplateElement[] body, TypeDescriptor<?> specifiedType, Template parent) {
        super(body);
        this.parent = parent;
        this.name = name;
        this.param = param;
        this.namedParam = VariableDeclaration.mapDefaultedParameters(this.namedParam, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
        this.specifiedType = specifiedType;
        this.setParent(this);
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TypeDescriptor<?> getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public int getParameterCount() {
        return this.param == null ? 0 : this.param.length;
    }

    @Override
    public VariableDeclaration getParameter(int index) {
        if (this.param == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.param[index];
    }

    @Override
    public int getRequiredParameterCount() {
        return VariableDeclaration.getRequiredParameterCount(this.namedParam, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
    }

    @Override
    public VariableDeclaration getParameter(String name) {
        return (VariableDeclaration)VariableDeclaration.getParameter(this.namedParam, (String)name, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitDef(this);
    }

    @Override
    public IMetaType getParameterType(int index) {
        return this.param[index].getType();
    }

    @Override
    public String getJavaSignature() {
        return this.getSignature();
    }

    @Override
    public String getSignature() {
        StringBuilder signature = new StringBuilder();
        if (this.getName() != null) {
            signature.append(this.getName());
        }
        signature.append("(");
        if (this.param != null) {
            int p = 0;
            while (p < this.param.length) {
                signature.append(this.param[p].getType().getVilName());
                if (p < this.param.length - 1) {
                    signature.append(",");
                }
                ++p;
            }
        }
        signature.append(")");
        return signature.toString();
    }

    @Override
    public TypeDescriptor<?> getReturnType() {
        return this.specifiedType != null ? this.specifiedType : TypeRegistry.anyType();
    }

    @Override
    public boolean acceptsNamedParameters() {
        return false;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> result = super.inferType();
        if (this.specifiedType != null && !this.specifiedType.isAssignableFrom(result)) {
            boolean ok = this.checkEmptyContainerIntializerCompliance(result, this.specifiedType);
            if (!ok && this.specifiedType.getBaseType() instanceof TypeDescriptor) {
                ok = this.checkEmptyContainerIntializerCompliance(result, (TypeDescriptor)this.specifiedType.getBaseType());
            }
            if (!ok) {
                throw new VilException("resulting type of block " + result.getVilName() + " does not fit to specified type " + this.specifiedType.getVilName(), 70001);
            }
        }
        return result;
    }

    private boolean checkEmptyContainerIntializerCompliance(TypeDescriptor<?> result, TypeDescriptor<?> specifiedType) {
        Expression eltEx;
        ITemplateElement elt;
        boolean ok = false;
        if (result.isCollection() && specifiedType.isCollection() && (elt = this.getTypeDefiningElement()) instanceof ExpressionStatement && (eltEx = ((ExpressionStatement)elt).getExpression()) instanceof ContainerInitializerExpression) {
            ok = ((ContainerInitializerExpression)eltEx).getInitExpressionsCount() == 0;
        }
        return ok;
    }

    @Override
    public boolean isFirstParameterOperand() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public IMetaType getDeclaringType() {
        return this.parent;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getSignature();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.name);
        result.append("(");
        if (this.param != null && this.param.length > 0) {
            result.append(this.param[0].toString());
            int i = 1;
            while (i < this.param.length) {
                result.append(", ");
                result.append(this.param[i].toString());
                ++i;
            }
        }
        result.append(")");
        return result.toString();
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        int p = 0;
        while (p < this.getParameterCount()) {
            this.getParameter(p).setParent(this);
            ++p;
        }
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        return null;
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        return null;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    public void setAnnotations(List<String> annotations) {
        if (annotations != null) {
            this.annotations = annotations.toArray(new String[annotations.size()]);
        }
    }

    public int getAnnotationCount() {
        return this.annotations == null ? 0 : this.annotations.length;
    }

    public String getAnnotation(int index) {
        if (this.annotations == null) {
            throw new IndexOutOfBoundsException("no annotations defined");
        }
        return this.annotations[index];
    }

    @Override
    public boolean hasAnnotation(String annotation) {
        return CustomOperation.hasAnnotation((String[])this.annotations, (String)annotation);
    }
}

