/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentFormatter;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;

public class Formatting {
    private static Map<Thread, Template> models = new HashMap<Thread, Template>();
    private static Supplier<FormattingConfiguration> defaultFormatting = () -> new FormattingConfiguration(120, System.lineSeparator());
    private static Supplier<IndentationConfiguration> defaultIndentation = () -> new IndentationConfiguration(4, 4, 0);

    public static void register(Template model) {
        models.put(Thread.currentThread(), model);
    }

    public static void unregister(Template model) {
        Thread current = Thread.currentThread();
        if (models.get(current) == model) {
            models.remove(current);
        }
    }

    public static void setDefaultFormattingConfiguration(Supplier<FormattingConfiguration> dflt) {
        if (dflt != null) {
            defaultFormatting = dflt;
        }
    }

    public static void setDefaultIndentationConfiguration(Supplier<IndentationConfiguration> dflt) {
        if (dflt != null) {
            defaultIndentation = dflt;
        }
    }

    public static IndentationConfiguration getIndentationConfiguration() {
        IndentationConfiguration result = null;
        Template model = models.get(Thread.currentThread());
        if (model != null) {
            result = model.getIndentationConfiguration();
        }
        if (result == null) {
            result = defaultIndentation.get();
        }
        return result;
    }

    public static FormattingConfiguration getFormattingConfiguration() {
        FormattingConfiguration result = null;
        Template model = models.get(Thread.currentThread());
        if (model != null) {
            result = model.getFormattingConfiguration();
        }
        if (result == null) {
            result = defaultFormatting.get();
        }
        return result;
    }

    public static ContentFormatter getContentFormatter() {
        ContentFormatter contentFormatter = new ContentFormatter();
        contentFormatter.setFormattingConfiguration(Formatting.getFormattingConfiguration());
        contentFormatter.setIndentationConfiguration(Formatting.getIndentationConfiguration());
        return contentFormatter;
    }
}

