/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class FormattingConfiguration {
    private String lineEnding;
    private String lineEndingOrig;
    private int lineLength;
    private String profile;
    private boolean useTabs = false;
    private int indentSteps = -1;
    private Charset charset;
    private Map<String, String> profileArguments = new HashMap<String, String>();

    public FormattingConfiguration() {
    }

    public FormattingConfiguration(int lineLength, String lineEnding) {
        this.lineLength = lineLength;
        this.setLineEnding(lineEnding);
    }

    public void setLineEnding(String lineEnding) {
        this.lineEndingOrig = lineEnding;
        if (lineEnding != null) {
            String tmp = lineEnding.toLowerCase();
            if (tmp.equals("windows")) {
                lineEnding = "\r\n";
            } else if (tmp.equals("linux") || tmp.equals("unix") || tmp.equals("mac") || tmp.equals("macos")) {
                lineEnding = "\n";
            }
        }
        this.lineEnding = lineEnding;
    }

    public String getLineEnding() {
        return this.lineEnding;
    }

    public String getLineEndingOrig() {
        return this.lineEndingOrig;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfileArgument(String name, String value) {
        if (name != null) {
            this.profileArguments.put(name, value);
        }
    }

    public String getProfileArgument(String name) {
        return this.getProfileArgument(name, null);
    }

    public String getProfileArgument(String name, String dflt) {
        String tmp;
        String result = dflt;
        if (name != null && (tmp = this.profileArguments.get(name)) != null) {
            result = tmp;
        }
        return result;
    }

    public static String getLineEnding(FormattingConfiguration cfg) {
        String result = null;
        if (cfg != null) {
            result = cfg.getLineEnding();
        }
        if (result == null) {
            result = System.getProperty("line.separator");
        }
        return result;
    }

    public boolean useTabs() {
        return this.useTabs;
    }

    public void setUseTabs(boolean useTabs) {
        this.useTabs = useTabs;
    }

    public int getIndentSteps() {
        return this.indentSteps;
    }

    public void setIndentSteps(int indentSteps) {
        this.indentSteps = Math.max(0, indentSteps);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

