/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.io.Writer;
import net.ssehub.easy.instantiation.core.model.common.ITraceFilter;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionWriter;
import net.ssehub.easy.instantiation.core.model.templateModel.BuilderBlockExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;

public class StreamTracer
extends net.ssehub.easy.instantiation.core.model.common.StreamTracer
implements ITracer {
    private boolean emitFailed;

    public StreamTracer(Writer out, String ... baseFolder) {
        super(out, baseFolder);
    }

    public StreamTracer(Writer out, boolean emitFailed, String ... baseFolder) {
        super(out, baseFolder);
        this.emitFailed = emitFailed;
    }

    @Override
    public void setTraceFilter(ITraceFilter filter) {
    }

    @Override
    public ITraceFilter getTraceFilter() {
        return null;
    }

    @Override
    public void visitDef(Def def, RuntimeEnvironment<?, ?> environment) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print("-> " + def.getName() + "(");
            int i = 0;
            while (i < def.getParameterCount()) {
                if (i > 0) {
                    this.print(", ");
                }
                this.print(def.getParameter(i).getType().getVilName());
                ++i;
            }
            this.print(")");
            if (def.getParameterCount() > 0) {
                this.print(" with (");
                i = 0;
                while (i < def.getParameterCount()) {
                    if (i > 0) {
                        this.print(", ");
                    }
                    try {
                        this.print(StringValueHelper.getStringValue(environment.getValue(def.getParameter(i)), NORMALIZER));
                    }
                    catch (VilException e) {
                        this.print("<null>");
                    }
                    ++i;
                }
                this.print(")");
            }
            this.println();
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedDef(Def def, RuntimeEnvironment<?, ?> environment, Object result) {
        if (this.isEnabled()) {
            this.decreaseIndentation();
        }
    }

    @Override
    public void visitBuilderBlock(BuilderBlockExpression ex, RuntimeEnvironment<?, ?> environment) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print("( " + ex.getVariable().getName() + " |...");
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedBuilderBlock(BuilderBlockExpression ex, RuntimeEnvironment<?, ?> environment, Object result) {
        if (this.isEnabled()) {
            this.decreaseIndentation();
        }
    }

    @Override
    public void visitedSwitch(Object select, int alternative, Object value) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.println("switch(" + StringValueHelper.getStringValue(select, NORMALIZER) + ")");
            this.increaseIndentation();
            this.printIndentation();
            this.println(alternative + " : " + StringValueHelper.getStringValue(value, NORMALIZER));
            this.decreaseIndentation();
        }
    }

    @Override
    public void visitLoop(VariableDeclaration var) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.println("for " + var.getName() + " {");
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedLoop(VariableDeclaration var) {
        if (this.isEnabled()) {
            this.decreaseIndentation();
            this.printIndentation();
            this.println("}");
        }
    }

    @Override
    public void visitAlternative(boolean takeIf) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print("visit ");
            if (takeIf) {
                this.println("if-branch");
            } else {
                this.println("else-branch");
            }
        }
    }

    @Override
    public void failedAt(ITemplateLangElement element) {
        if (this.emitFailed && this.isEnabled()) {
            this.print("failed at: ");
            TemplateLangWriter writer = new TemplateLangWriter(this.getOut());
            try {
                element.accept(writer);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
    }

    @Override
    protected ExpressionWriter getWriter(Writer out) {
        return new TemplateLangWriter(this.getOut());
    }

    @Override
    public void visitTemplate(Template template) {
    }

    @Override
    public void visitedTemplate(Template template) {
    }

    @Override
    public void visitWhileBody() {
        if (this.isEnabled()) {
            this.printIndentation();
            this.println("while body {");
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedWhileBody() {
        if (this.isEnabled()) {
            this.decreaseIndentation();
            this.printIndentation();
            this.println("}");
        }
    }

    @Override
    public void visitFlush() {
    }

    @Override
    public void visitedFlush() {
        if (this.isEnabled()) {
            this.printIndentation();
            this.println("flush");
        }
    }
}

