/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.common.AbstractResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IVariableDeclarationReceiver;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.JavaExtension;
import net.ssehub.easy.instantiation.core.model.templateModel.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateDescriptor;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaField;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class Template
extends AbstractResolvableModel<VariableDeclaration, Template>
implements ITemplateLangElement,
IResolvableModel<VariableDeclaration, Template>,
IVariableDeclarationReceiver<VariableDeclaration> {
    private Version version;
    private String name;
    private ModelImport<Template> extension;
    private JavaExtension[] javaExtensions;
    private List<VariableDeclaration> declarations;
    private VariableDeclaration[] param;
    private Map<String, VariableDeclaration> namedParams;
    private List<Def> defs;
    private IndentationConfiguration indentationConfiguration;
    private FormattingConfiguration formattingConfiguration;
    private long timestamp = System.currentTimeMillis();

    Template() {
        super(null, null, null);
    }

    public Template(String name, ModelImport<Template> extension, TemplateDescriptor descriptor, TypeRegistry registry) throws VilException {
        super(descriptor.getImports(), registry, descriptor.getAdvices());
        if (name == null || name.length() == 0) {
            throw new VilException("no name given", 70001);
        }
        this.name = name;
        this.extension = extension;
        this.javaExtensions = descriptor.getJavaExtensions();
        this.indentationConfiguration = descriptor.getIndentationConfiguration();
        this.formattingConfiguration = descriptor.getFormattingConfiguration();
        this.setParams(descriptor);
    }

    public void setParams(TemplateDescriptor descriptor) {
        this.param = descriptor.getParameter();
        this.namedParams = VariableDeclaration.mapDefaultedParameters(this.namedParams, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
        this.adjustParents();
    }

    protected void adjustParents() {
        int p = 0;
        while (p < this.getParameterCount()) {
            this.getParameter(p).setParent(this);
            ++p;
        }
        int d = 0;
        while (d < this.getVariableDeclarationCount()) {
            this.getVariableDeclaration(d).setParent(this);
            ++d;
        }
    }

    public int getJavaExtensionCount() {
        return this.javaExtensions == null ? 0 : this.javaExtensions.length;
    }

    public JavaExtension getJavaExtension(int index) {
        if (this.javaExtensions == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.javaExtensions[index];
    }

    @Override
    public boolean isImplicit(VariableDeclaration decl) {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public void addVariableDeclaration(VariableDeclaration var) {
        if (this.declarations == null) {
            this.declarations = new ArrayList<VariableDeclaration>();
        }
        this.declarations.add(var);
        var.setParent(this);
    }

    @Override
    public int getVariableDeclarationCount() {
        return this.declarations == null ? 0 : this.declarations.size();
    }

    @Override
    public VariableDeclaration getVariableDeclaration(int index) {
        if (this.declarations == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.declarations.get(index);
    }

    public int getDefCount() {
        return this.defs == null ? 0 : this.defs.size();
    }

    public void addDef(Def def) {
        if (this.defs == null) {
            this.defs = new ArrayList<Def>();
        }
        this.defs.add(def);
        def.setParent(this);
    }

    public void removeDef(Def def) {
        if (this.defs != null) {
            this.defs.remove(def);
        }
    }

    public Def getDef(int index) {
        if (this.defs == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.defs.get(index);
    }

    @Override
    public int getParameterCount() {
        return this.param == null ? 0 : this.param.length;
    }

    @Override
    public VariableDeclaration getParameter(int index) {
        if (this.param == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.param[index];
    }

    @Override
    public int getRequiredParameterCount() {
        return VariableDeclaration.getRequiredParameterCount(this.namedParams, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
    }

    @Override
    public VariableDeclaration getParameter(String name) {
        return (VariableDeclaration)VariableDeclaration.getParameter(this.namedParams, (String)name, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitTemplate(this);
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public ModelImport<Template> getSuper() {
        return this.extension;
    }

    @Override
    public int getOperationsCount() {
        return this.getDefCount();
    }

    @Override
    public IMetaOperation getOperation(int index) {
        return this.getDef(index);
    }

    @Override
    public boolean isAssignableFrom(IMetaType type) {
        boolean assignable = false;
        if (type instanceof Template) {
            Template iter = (Template)type;
            while (iter != null && !assignable) {
                Template parent = iter.extension == null ? null : (Template)iter.extension.getResolved();
                assignable = parent == this;
                iter = parent;
            }
        }
        return assignable;
    }

    @Override
    public IMetaOperation findConversion(IMetaType sourceType, IMetaType targetType) {
        return null;
    }

    @Override
    public Template getParent() {
        Template result = this.extension == null ? null : (Template)this.extension.getResolved();
        return result;
    }

    @Override
    public int getExtensionTypesCount() {
        return this.getJavaExtensionCount();
    }

    @Override
    public IMetaType getExtensionType(int index) {
        return this.getJavaExtension(index).getResolved();
    }

    public IndentationConfiguration getIndentationConfiguration() {
        return this.indentationConfiguration;
    }

    public FormattingConfiguration getFormattingConfiguration() {
        return this.formattingConfiguration;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean enableDynamicDispatch() {
        return true;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public IMetaOperation addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return null;
    }

    @Override
    public boolean isActualTypeOf(IMetaType type) {
        return false;
    }

    @Override
    protected void reload() {
        TemplateModel.INSTANCE.reload(this);
    }

    public IRestrictionEvaluationContext getRestrictionEvaluationContext() {
        return new RuntimeEnvironment();
    }

    @Override
    public IMetaType getBaseType() {
        return null;
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public IMetaField getField(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public IMetaType getSuperType() {
        return this.extension != null ? (IMetaType)this.extension.getResolved() : null;
    }

    @Override
    public int getGenericParameterCount() {
        return 0;
    }

    @Override
    public TypeDescriptor<?> getGenericParameterType(int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        return true;
    }

    @Override
    public List<IMetaOperation> getCandidates(String name, int unnamedArgsCount) {
        return TypeDescriptor.getCandidates(this, name, unnamedArgsCount);
    }

    public long getLastModification() {
        return this.timestamp;
    }
}

