/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.AbstractTemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class TemplateBlock
extends AbstractTemplateElement {
    private ITemplateElement[] body;

    TemplateBlock() {
    }

    public TemplateBlock(ITemplateElement[] body) {
        this.body = body;
    }

    public void setBody(ITemplateElement[] body) {
        this.body = body;
    }

    public int getBodyElementCount() {
        return this.body == null ? 0 : this.body.length;
    }

    public ITemplateElement getBodyElement(int index) {
        if (this.body == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.body[index];
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitTemplateBlock(this);
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        ITemplateElement last = this.getTypeDefiningElement();
        TypeDescriptor<?> result = last == null ? TypeRegistry.voidType() : last.inferType();
        return result;
    }

    protected ITemplateElement getTypeDefiningElement() {
        ITemplateElement result = this.body == null || this.body.length == 0 ? null : this.body[this.body.length - 1];
        return result;
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        if (this.body != null) {
            int b = 0;
            while (b < this.getBodyElementCount()) {
                ITemplateElement elt = this.getBodyElement(b);
                if (elt instanceof AbstractTemplateElement) {
                    ((AbstractTemplateElement)elt).setParent(this);
                }
                ++b;
            }
        }
    }

    @Override
    public boolean endsWithContentStatement() {
        ITemplateElement elt = this.getTypeDefiningElement();
        return elt != null && elt.endsWithContentStatement();
    }
}

