/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractArrayWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.GenericArguments;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.NotOclCompliant;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.SequenceOperations;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;

public class ArraySequence<T>
extends AbstractArrayWrapper<T>
implements Sequence<T> {
    public ArraySequence(T[] array, Class<?> param) {
        super(array, TypeRegistry.DEFAULT, false, param);
    }

    public ArraySequence(T[] array, Class<?> param, TypeRegistry registry) {
        super(array, registry, false, param);
    }

    public ArraySequence(T[] array, TypeDescriptor<?> ... params) {
        super(array, false, params);
    }

    @Override
    public T at(int index) {
        T[] array = this.getArray();
        int i = OclKeyWords.toJavaIndex((int)index);
        T result = array == null || i < 0 || i >= array.length ? null : (T)array[i];
        return result;
    }

    @Override
    public T get(int index) {
        return this.at(OclKeyWords.toJavaIndex((int)index));
    }

    @Invisible
    public static final <T> Sequence<T> empty(Class<?> param, TypeRegistry registry) {
        return ArraySequence.empty(registry.findType(param));
    }

    @Invisible
    public static final <T> Sequence<T> empty(TypeDescriptor<?> param) {
        TypeDescriptor<?>[] params = TypeDescriptor.createArray(1);
        params[0] = param;
        return new ArraySequence<T>(null, params);
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> selectByType(TypeDescriptor<?> type) {
        return new ListSequence(ArraySequence.selectByType(this, type, false, false), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> selectByKind(TypeDescriptor<?> type) {
        return new ListSequence(ArraySequence.selectByType(this, type, true, false), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> typeReject(TypeDescriptor<?> type) {
        return new ListSequence(ArraySequence.selectByType(this, type, true, true), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> excluding(Collection<T> sequence) {
        return new ListSequence(ArraySequence.excluding(this, sequence), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> append(Collection<T> sequence) {
        return new ListSequence<T>(ArraySequence.append(this, sequence), this.getGenericParameter());
    }

    @Override
    public Sequence<?> flatten() throws VilException {
        ArrayList result = new ArrayList();
        ArraySequence.flatten(this, result);
        return new ListSequence(result, this.getFlattenedParams(this));
    }

    @Override
    public Sequence<T> select(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSequence(ArraySequence.select(this, evaluator, true), param);
    }

    @Override
    public Sequence<T> reject(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSequence(ArraySequence.select(this, evaluator, false), param);
    }

    @Override
    public void forEach(ExpressionEvaluator evaluator) throws VilException {
        ArraySequence.collect(this, evaluator, true);
    }

    @Override
    public Sequence<?> collect(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSequence<Object>(ArraySequence.collect(this, evaluator, true), param);
    }

    @Override
    public Sequence<?> collectNested(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSequence<Object>(ArraySequence.collect(this, evaluator, false), param);
    }

    @Override
    public Set<?> closure(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new SetSet<Object>(ArraySequence.closure(this, evaluator), param);
    }

    @Override
    public Object apply(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.apply(this, evaluator);
    }

    @Override
    @OperationMeta(name={"equals"})
    public boolean isEquals(Collection<?> elements) {
        return ArraySequence.equals(this, elements);
    }

    @Override
    public Set<T> toSet() {
        return new ArraySet(this.getArray(), this.getGenericParameter());
    }

    @Override
    public Set<T> asSet() {
        return this.toSet();
    }

    @Override
    public Sequence<T> asSequence() {
        return this;
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> sortAlpha() {
        AbstractCollectionWrapper result = this.getArray() == null ? this : new ListSequence(this.sortAlphaImpl(), this.getGenericParameter());
        return result;
    }

    @Override
    @NotOclCompliant(value={"sort"})
    @ReturnGenerics(value={IVilType.class})
    @OperationMeta(name={"sortedBy", "sort"})
    public Sequence<T> sortedBy(ExpressionEvaluator evaluator) throws VilException {
        AbstractCollectionWrapper result = this.getArray() == null ? this : new ListSequence(this.sortImpl(evaluator), this.getGenericParameter());
        return result;
    }

    @Override
    @NotOclCompliant(value={"revert"})
    @ReturnGenerics(value={IVilType.class})
    @OperationMeta(name={"reverse", "revert"})
    public Sequence<T> revert() {
        AbstractCollectionWrapper result = this.getArray() == null ? this : new ListSequence(this.revertImpl(), this.getGenericParameter());
        return result;
    }

    @Override
    public T first() {
        T[] array = this.getArray();
        T result = array.length == 0 ? null : (T)array[0];
        return result;
    }

    @Override
    public T last() {
        T[] array = this.getArray();
        T result = array.length == 0 ? null : (T)this.getArray()[this.size() - 1];
        return result;
    }

    @Override
    public int indexOf(T element) {
        T[] array = this.getArray();
        int result = -1;
        int i = 0;
        while (result < 0 && i < array.length) {
            Object elt = array[i];
            if (element == null && elt == null || element != null && element.equals(array[i])) {
                result = i;
            }
            ++i;
        }
        return OclKeyWords.toIvmlIndex((int)result);
    }

    @Override
    @GenericArguments(value={0})
    public T add(T element) {
        this.extendCapacity(1);
        T[] array = this.getArray();
        array[array.length - 1] = element;
        return element;
    }

    @Override
    public Map<T, T> mapSequence(Sequence<T> other) {
        return SequenceOperations.mapSequence(this, other);
    }

    @Override
    public Map<T, T> mapAny(Sequence<T> other) {
        return SequenceOperations.mapAny(this, other);
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> union(Sequence<T> seq) {
        return new ListSequence<T>(SequenceOperations.union(this, seq), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> append(T object) {
        return new ListSequence<T>(SequenceOperations.append(this, object), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> prepend(T object) {
        return new ListSequence<T>(SequenceOperations.prepend(this, object), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> insertAt(int index, T object) {
        return new ListSequence<T>(SequenceOperations.insertAt(this, index, object), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Sequence<T> subSequence(int lower, int upper) {
        return new ListSequence(SequenceOperations.subSequence(this, lower, upper), this.getGenericParameter());
    }

    @Override
    public boolean allowSequenceAdjustment() {
        return false;
    }

    @Override
    public boolean hasDuplicates() {
        return SequenceOperations.hasDuplicates(this);
    }

    @Override
    public boolean overlaps(Sequence<T> other) {
        return SequenceOperations.overlaps(this, other);
    }

    @Override
    public boolean isSubsequenceOf(Sequence<T> other) {
        return SequenceOperations.isSubsequenceOf(this, other);
    }

    @Override
    public String joinfields(String separator, String begin, String end) {
        return SequenceOperations.joinfields(this, separator, begin, end);
    }

    @Override
    public Sequence<T> cloneCollection() {
        return new ArraySequence(this.getArray(), this.getGenericParameter());
    }
}

