/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IRegisteredStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;

public class StringValueHelper {
    public static final String NULL_VALUE = "null";
    private static final HashMap<Class<?>, IRegisteredStringValueProvider> REGISTERED_PROVIDERS = new HashMap();

    public static String firstToUpperCase(String string) {
        return StringValueHelper.firstToLowerCase(string, Locale.getDefault());
    }

    public static String firstToUpperCase(String string, Locale locale) {
        Object result = string;
        int len = string.length();
        if (1 == len) {
            result = string.toUpperCase(locale);
        } else if (len > 1) {
            result = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return result;
    }

    public static String lastToUpperCase(String string) {
        return StringValueHelper.lastToLowerCase(string, Locale.getDefault());
    }

    public static String lastToUpperCase(String string, Locale locale) {
        Object result = string;
        int len = string.length();
        if (1 == len) {
            result = string.toUpperCase(locale);
        } else if (len > 1) {
            result = string.substring(0, len - 1) + Character.toUpperCase(string.charAt(len - 1));
        }
        return result;
    }

    public static String firstToLowerCase(String string) {
        return StringValueHelper.firstToLowerCase(string, Locale.getDefault());
    }

    public static String firstToLowerCase(String string, Locale locale) {
        Object result = string;
        int len = string.length();
        if (1 == len) {
            result = string.toLowerCase(locale);
        } else if (len > 1) {
            result = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return result;
    }

    public static String lastToLowerCase(String string) {
        return StringValueHelper.lastToLowerCase(string, Locale.getDefault());
    }

    public static String lastToLowerCase(String string, Locale locale) {
        Object result = string;
        int len = string.length();
        if (1 == len) {
            result = string.toLowerCase(locale);
        } else if (len > 1) {
            result = string.substring(0, len - 1) + Character.toLowerCase(string.charAt(len - 1));
        }
        return result;
    }

    public static String getStringValueInReplacement(Object object, IStringValueProvider.StringComparator comparator) {
        if (object instanceof IvmlElement) {
            object = ((IvmlElement)object).getValue();
        }
        return StringValueHelper.getStringValue(object, comparator);
    }

    public static void registerStringValueProvider(Class<?> objectClass, IRegisteredStringValueProvider provider) {
        if (objectClass != null) {
            REGISTERED_PROVIDERS.put(objectClass, provider);
        }
    }

    public static IRegisteredStringValueProvider getStringValueProvider(Class<?> objectClass) {
        return objectClass == null ? null : REGISTERED_PROVIDERS.get(objectClass);
    }

    public static String getStringValue(Object object, IStringValueProvider.StringComparator comparator) {
        IRegisteredStringValueProvider provider;
        String result = object instanceof IStringValueProvider ? ((IStringValueProvider)object).getStringValue(comparator) : (object instanceof java.util.Map ? Map.getStringValue((java.util.Map)object, comparator) : (object instanceof Iterator ? "<Iterator>" : (object == null || TypeRegistry.NULL == object ? NULL_VALUE : ((provider = StringValueHelper.getStringValueProvider(object.getClass())) != null ? provider.getStringValue(object, comparator) : object.toString()))));
        return result;
    }

    public static String getStringValue(Collection<?> collection, IStringValueProvider.StringComparator comparator) {
        String result;
        if (collection == null) {
            result = NULL_VALUE;
        } else {
            StringBuilder tmp = new StringBuilder("{");
            if (comparator != null) {
                ArrayList<String> tmpList = new ArrayList<String>();
                Iterator<?> iter = collection.iterator();
                while (iter.hasNext()) {
                    tmpList.add(StringValueHelper.getStringValue(iter.next(), comparator));
                }
                Collections.sort(tmpList, comparator);
                int i = 0;
                while (i < tmpList.size()) {
                    if (i > 0) {
                        tmp.append(", ");
                    }
                    tmp.append((String)tmpList.get(i));
                    ++i;
                }
            } else {
                Iterator<?> iter = collection.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    tmp.append(StringValueHelper.getStringValue(o, comparator));
                    if (!iter.hasNext()) continue;
                    tmp.append(", ");
                }
            }
            tmp.append("}");
            result = tmp.toString();
        }
        return result;
    }

    public static <T> Collection<T> sortCollection(Collection<T> collection, IStringValueProvider.StringComparator comparator) {
        if (collection != null && comparator != null) {
            TreeMap<String, T> sortedCollectionEntries = new TreeMap<String, T>(comparator);
            for (T t : collection) {
                sortedCollectionEntries.put(StringValueHelper.getStringValue(t, null), t);
            }
            ArrayList sorted = new ArrayList();
            sorted.addAll(sortedCollectionEntries.values());
            TypeDescriptor<?>[] param = TypeDescriptor.createArray(collection.getGenericParameterCount());
            int d = 0;
            while (d < param.length) {
                param[d] = collection.getGenericParameterType(d);
                ++d;
            }
            if (collection instanceof Set) {
                collection = new ListSet(sorted, param);
            } else if (collection instanceof Sequence) {
                collection = new ListSequence(sorted, param);
            } else {
                EASyLoggerFactory.INSTANCE.getLogger(StringValueHelper.class, "net.ssehub.easy.instantiation.core").warn("unknown collection type " + collection.getClass().getName());
            }
        }
        return collection;
    }
}

