/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IDirectTypeRegistryAccess;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.FakeTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlProjectTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeDescriptor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;

public class IvmlTypeResolver
implements ITypeResolver {
    private static final boolean STATIC = true;
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(IvmlTypeResolver.class, "net.ssehub.easy.instantiation.core");
    private IDirectTypeRegistryAccess access;
    private Project project;
    private TypeRegistry typeRegistry;
    private Map<IDatatype, Set<Attribute>> attributes = new HashMap<IDatatype, Set<Attribute>>();
    private Map<IDatatype, TypeDescriptor<?>> ivmlMap = new HashMap();

    public IvmlTypeResolver(Project project, TypeRegistry typeRegistry) {
        this.project = project;
        this.typeRegistry = typeRegistry;
        int eCount = project.getElementCount();
        int e = 0;
        while (e < eCount) {
            ContainableModelElement elt = project.getElement(e);
            if (elt instanceof DecisionVariableDeclaration) {
                this.cacheVariable((DecisionVariableDeclaration)elt);
            }
            ++e;
        }
    }

    private void cacheVariable(DecisionVariableDeclaration var) {
        IDatatype type = var.getType();
        int aCount = var.getAttributesCount();
        if (aCount > 0) {
            Set<Attribute> aList = this.attributes.get(type);
            if (aList == null) {
                aList = new HashSet<Attribute>();
                this.attributes.put(type, aList);
            }
            int a = 0;
            while (a < aCount) {
                aList.add(var.getAttribute(a));
                ++a;
            }
        }
    }

    @Override
    public TypeDescriptor<?> resolveType(String name, boolean addIfMissing) {
        Object exception = null;
        TypeDescriptor result = this.access.get(name);
        if (result == null) {
            try {
                IDatatype type = ModelQuery.findType((IResolutionScope)this.project, (String)name, null);
                if (type != null) {
                    result = this.obtainType(type);
                } else {
                    Project tmp = ModelQuery.findProject((Project)this.project, (String)name);
                    if (tmp != null) {
                        result = new IvmlProjectTypeDescriptor(tmp, this);
                        this.ivmlMap.put(tmp.getType(), result);
                    }
                }
            }
            catch (ModelQueryException e) {
                exception = e;
            }
            catch (VilException e) {
                exception = e;
            }
        }
        if (result == null && addIfMissing) {
            try {
                if (Advice.getIvmlElement((IResolutionScope)this.project, name) == null) {
                    result = new FakeTypeDescriptor(this.typeRegistry, name);
                    this.addType(name, result);
                }
            }
            catch (VilException e) {
                exception = e;
            }
        }
        return result;
    }

    TypeDescriptor<?> obtainType(IDatatype type) throws VilException {
        IvmlTypeDescriptor result = null;
        if (type != null) {
            result = this.access.get(type.getQualifiedName());
            if (result == null && (result = this.access.get(type.getName())) != null && !result.getQualifiedName().equals(type.getQualifiedName())) {
                result = null;
            }
            if (result == null) {
                IvmlTypeDescriptor itd = new IvmlTypeDescriptor(this.project, type, this);
                this.ivmlMap.put(type, itd);
                itd.resolve(this.project, type, this.attributes.get(type));
                result = itd;
            }
        }
        return result;
    }

    void addType(String name, TypeDescriptor<?> type) {
        if (!this.isKnown(name)) {
            this.access.add(name, type);
        }
    }

    @Override
    public TypeDescriptor<? extends IVilType> resolveInstantiator(String name) {
        return null;
    }

    public boolean isKnown(String name) {
        return this.access.contains(name);
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public void setRegistryAccess(IDirectTypeRegistryAccess access) {
        this.access = access;
        int eCount = this.project.getElementCount();
        int e = 0;
        while (e < eCount) {
            ContainableModelElement elt = this.project.getElement(e);
            if (elt instanceof CustomDatatype) {
                try {
                    this.obtainType((IDatatype)((CustomDatatype)elt));
                }
                catch (VilException ex) {
                    LOGGER.exception((Exception)((Object)ex));
                }
            }
            ++e;
        }
    }

    @Override
    public TypeDescriptor<?> resolveType(IDatatype type) {
        TypeDescriptor<?> result = this.ivmlMap.get(type);
        if (result == null) {
            try {
                result = this.obtainType(type);
            }
            catch (VilException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return result;
    }
}

