/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;

public class TranslationResult<R> {
    private MessageReceiver receiver;
    private List<R> results;

    public TranslationResult() {
        this(null, null);
    }

    public TranslationResult(List<R> results, MessageReceiver receiver) {
        this.receiver = receiver;
        this.results = results;
    }

    public int getMessageCount() {
        return this.receiver == null ? 0 : this.receiver.getMessageCount();
    }

    public int getErrorCount() {
        return this.receiver == null ? 0 : this.receiver.getErrorCount();
    }

    public Message getMessage(int index) {
        if (this.receiver == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.receiver.getMessage(index);
    }

    public MessageReceiver getReceiver() {
        return this.receiver;
    }

    public List<IMessage> getMessageList() {
        ArrayList<Message> result;
        int count = this.getMessageCount();
        if (count > 0) {
            result = new ArrayList<Message>(count);
            int m = 0;
            while (m < count) {
                result.add(this.getMessage(m));
                ++m;
            }
        } else {
            result = null;
        }
        return result;
    }

    public List<Message> getMessageListSpecific() {
        ArrayList<Message> result;
        int count = this.getMessageCount();
        if (count > 0) {
            result = new ArrayList<Message>(count);
            int m = 0;
            while (m < count) {
                result.add(this.getMessage(m));
                ++m;
            }
        } else {
            result = null;
        }
        return result;
    }

    public int getResultCount() {
        return this.results == null ? 0 : this.results.size();
    }

    public R getResult(int index) {
        if (this.results == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.results.get(index);
    }

    public List<R> getResultsList() {
        ArrayList<R> result = new ArrayList<R>();
        if (this.results != null) {
            result.addAll(this.results);
        }
        return result;
    }
}

