/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd;

import au.com.jcloud.lxd.bean.LxdServerCredential;
import au.com.jcloud.lxd.model.Container;
import au.com.jcloud.lxd.model.Operation;
import au.com.jcloud.lxd.service.ILinuxCliService;
import au.com.jcloud.lxd.service.ILxdApiService;
import au.com.jcloud.lxd.service.impl.LinuxCliServiceImpl;
import au.com.jcloud.lxd.service.impl.LxdApiServiceImpl;
import au.com.jcloud.lxd.service.impl.LxdServiceImpl;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class App {
    private static final Logger LOG = Logger.getLogger(App.class);

    public static void main(String[] args) {
        LOG.info((Object)("LXC START. args=" + args.length));
        System.out.println(args[0]);
        try {
            if (args.length == 0) {
                System.out.println("Usage: jlxd [host[:port]] <s|c|i|o> [name] [start|stop|create|delete|snaps|file]");
                System.out.println("");
                System.out.println("   s = server info");
                System.out.println("   c = list containers");
                System.out.println("   i = list images");
                System.out.println("   o = list operations");
                System.out.println("   name = a specific instance of one of the above");
                System.out.println("   start|stop|create|delete|snaps|file = only for containers");
                System.exit(1);
            }
            LxdServiceImpl service = new LxdServiceImpl();
            LxdApiServiceImpl lxdApiService = new LxdApiServiceImpl();
            LinuxCliServiceImpl linuxCliService = new LinuxCliServiceImpl();
            lxdApiService.setLinuxCliService((ILinuxCliService)linuxCliService);
            service.setLxdApiService((ILxdApiService)lxdApiService);
            String remoteHostAndPort = null;
            for (int i = 0; i < args.length; ++i) {
                String name;
                if (args[i].equals("s")) {
                    LOG.info((Object)"");
                    LOG.info((Object)service.loadServerInfo());
                    continue;
                }
                if (args[i].equals("c")) {
                    LOG.info((Object)"");
                    if (args.length - 1 == i || args[i + 1].equals("o") || args[i + 1].equals("i") || args[i + 1].equals("s")) {
                        Collection containers = service.loadContainerMap().values();
                        LOG.info((Object)("containers=" + containers.size()));
                        for (Container container : containers) {
                            LOG.info((Object)("container=" + container));
                        }
                        continue;
                    }
                    if ((args.length <= i + 1 || args[i + 1].equals("o") || args[i + 1].equals("i")) && args[i + 1].equals("s")) continue;
                    name = args[i + 1];
                    Container container = service.loadContainer(name);
                    if (container == null && args.length > ++i + 1 && !args[i + 1].equals("create")) {
                        LOG.error((Object)("container " + name + " does not exist"));
                        System.exit(1);
                    }
                    if (args.length > i + 1 && !args[i + 1].equals("o") && !args[i + 1].equals("i") || !args[i + 1].equals("s")) {
                        Object operation;
                        switch (operation = args[i + 1]) {
                            case "start": {
                                LOG.info((Object)("starting container=" + container));
                                service.startContainer(name);
                                break;
                            }
                            case "stop": {
                                LOG.info((Object)("stopping container=" + container));
                                service.stopContainer(name);
                                break;
                            }
                            case "create": {
                                LOG.info((Object)("creating new container=" + name));
                                service.createContainer(name, "images:ubuntu/jammy");
                                break;
                            }
                            case "delete": {
                                LOG.info((Object)("deleting container=" + container));
                                service.deleteContainer(name);
                                break;
                            }
                            case "snaps": {
                                LOG.info((Object)("Snapshots for container=" + container));
                                LOG.info(service.loadSnapshotMap(container).values());
                                break;
                            }
                            case "file": {
                                if (args.length > i + 2 && !args[i + 2].equals("o") && !args[i + 2].equals("i") || !args[i + 2].equals("s")) {
                                    String filepath = args[i + 2];
                                    LOG.info((Object)("Getting file " + filepath + " for container=" + container));
                                    LOG.info((Object)service.loadFile(container.getName(), filepath));
                                    break;
                                }
                                LOG.warn((Object)("Cannot get file for container=" + container + ". Filepath not provided"));
                                break;
                            }
                            default: {
                                LOG.warn((Object)("Unknown container operation: " + (String)operation));
                                System.exit(1);
                                break;
                            }
                        }
                        continue;
                    }
                    LOG.info((Object)("container=" + container));
                    continue;
                }
                if (args[i].equals("i")) {
                    Object image2;
                    LOG.info((Object)"");
                    Map images = service.loadImageMap();
                    if (args.length - 1 == i || args[i + 1].equals("o") || args[i + 1].equals("c") || args[i + 1].equals("s")) {
                        LOG.info((Object)("images=" + images.size()));
                        for (Object image2 : images.values()) {
                            LOG.info((Object)("image=" + image2));
                        }
                        continue;
                    }
                    if ((args.length <= i + 1 || args[i + 1].equals("o") || args[i + 1].equals("c")) && args[i + 1].equals("s")) continue;
                    String name2 = args[i + 1];
                    image2 = images.keySet().iterator();
                    while (image2.hasNext()) {
                        String key = (String)image2.next();
                        if (!key.contains(name2)) continue;
                        LOG.info((Object)("image=" + images.get(key)));
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals("o")) {
                    LOG.info((Object)"");
                    if (args.length - 1 == i || args[i + 1].equals("i") || args[i + 1].equals("c") || args[i + 1].equals("s")) {
                        Collection operations = service.loadOperationMap().values();
                        LOG.info((Object)("operations=" + operations.size()));
                        for (Object operation : operations) {
                            LOG.info((Object)("operation=" + operation));
                        }
                        continue;
                    }
                    if ((args.length <= i + 1 || args[i + 1].equals("i") || args[i + 1].equals("c")) && args[i + 1].equals("s")) continue;
                    name = args[i + 1];
                    Operation operation = service.loadOperation(name);
                    LOG.info((Object)("operation=" + operation));
                    ++i;
                    continue;
                }
                if (!StringUtils.isBlank(remoteHostAndPort)) continue;
                remoteHostAndPort = args[i];
                LxdServerCredential credential = new LxdServerCredential(remoteHostAndPort);
                service.setLxdServerCredential(credential);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        LOG.info((Object)"LXC DONE");
    }
}

